/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXSnackbar$$Lambda$1;
import com.jfoenix.controls.JFXSnackbar$$Lambda$10;
import com.jfoenix.controls.JFXSnackbar$$Lambda$11;
import com.jfoenix.controls.JFXSnackbar$$Lambda$12;
import com.jfoenix.controls.JFXSnackbar$$Lambda$13;
import com.jfoenix.controls.JFXSnackbar$$Lambda$14;
import com.jfoenix.controls.JFXSnackbar$$Lambda$2;
import com.jfoenix.controls.JFXSnackbar$$Lambda$3;
import com.jfoenix.controls.JFXSnackbar$$Lambda$4;
import com.jfoenix.controls.JFXSnackbar$$Lambda$5;
import com.jfoenix.controls.JFXSnackbar$$Lambda$6;
import com.jfoenix.controls.JFXSnackbar$$Lambda$7;
import com.jfoenix.controls.JFXSnackbar$$Lambda$8;
import com.jfoenix.controls.JFXSnackbar$$Lambda$9;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class JFXSnackbar
extends StackPane {
    private Label toast;
    private JFXButton action;
    private Pane snackbarContainer;
    private Group popup;
    private ChangeListener<? super Number> sizeListener;
    private AtomicBoolean processingQueue = new AtomicBoolean(false);
    private ConcurrentLinkedQueue<SnackbarEvent> eventQueue = new ConcurrentLinkedQueue();
    private StackPane actionContainer;
    private Interpolator easeInterpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
    private BorderPane content = new BorderPane();
    private String activePseudoClass = null;
    private Timeline openAnimation = null;

    public JFXSnackbar() {
        this(null);
    }

    public JFXSnackbar(Pane snackbarContainer) {
        this.toast = new Label();
        this.toast.setMinWidth(Double.NEGATIVE_INFINITY);
        this.toast.getStyleClass().add((Object)"jfx-snackbar-toast");
        this.toast.setWrapText(true);
        StackPane toastContainer = new StackPane(new Node[]{this.toast});
        toastContainer.setPadding(new Insets(20.0));
        this.content.setLeft((Node)toastContainer);
        this.action = new JFXButton();
        this.action.setMinWidth(Double.NEGATIVE_INFINITY);
        this.action.setButtonType(JFXButton.ButtonType.FLAT);
        this.action.getStyleClass().add((Object)"jfx-snackbar-action");
        this.actionContainer = new StackPane(new Node[]{this.action});
        this.actionContainer.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        this.content.setRight((Node)this.actionContainer);
        this.toast.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding((Callable)JFXSnackbar$$Lambda$1.lambdaFactory$(this), (Observable[])new Observable[]{this.prefWidthProperty(), this.actionContainer.widthProperty(), this.actionContainer.visibleProperty()}));
        this.content.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
        this.content.getStyleClass().add((Object)"jfx-snackbar-content");
        this.popup = new Group();
        this.popup.getChildren().add((Object)this.content);
        this.popup.setManaged(false);
        this.popup.setVisible(false);
        this.popup.idProperty().bind((ObservableValue)this.idProperty());
        this.getStyleClass().addListener(JFXSnackbar$$Lambda$2.lambdaFactory$(this));
        this.sizeListener = JFXSnackbar$$Lambda$3.lambdaFactory$(this);
        this.registerSnackbarContainer(snackbarContainer);
        this.popup.layoutBoundsProperty().addListener(JFXSnackbar$$Lambda$4.lambdaFactory$(this));
        this.addEventHandler(SnackbarEvent.SNACKBAR, JFXSnackbar$$Lambda$5.lambdaFactory$(this));
        this.setVisible(false);
        this.setManaged(false);
    }

    public Pane getPopupContainer() {
        return this.snackbarContainer;
    }

    public void registerSnackbarContainer(Pane snackbarContainer) {
        if (snackbarContainer != null) {
            if (this.snackbarContainer != null) {
                throw new IllegalArgumentException("Snackbar Container already set");
            }
            this.snackbarContainer = snackbarContainer;
            this.snackbarContainer.getChildren().add((Object)this.popup);
            this.snackbarContainer.heightProperty().addListener(this.sizeListener);
            this.snackbarContainer.widthProperty().addListener(this.sizeListener);
        }
    }

    public void unregisterSnackbarContainer(Pane snackbarContainer) {
        if (snackbarContainer != null) {
            if (this.snackbarContainer == null) {
                throw new IllegalArgumentException("Snackbar Container not set");
            }
            this.snackbarContainer.getChildren().remove((Object)this.popup);
            this.snackbarContainer.heightProperty().removeListener(this.sizeListener);
            this.snackbarContainer.widthProperty().removeListener(this.sizeListener);
            this.snackbarContainer = null;
        }
    }

    public void show(String toastMessage, long timeout) {
        this.show(toastMessage, null, timeout, null);
    }

    public void show(String message, String actionText, EventHandler<? super MouseEvent> actionHandler) {
        this.show(message, actionText, -1L, actionHandler);
    }

    public void show(String toastMessage, String pseudoClass, long timeout) {
        this.show(toastMessage, pseudoClass, null, timeout, null);
    }

    public void show(String message, String pseudoClass, String actionText, EventHandler<? super MouseEvent> actionHandler) {
        this.show(message, pseudoClass, actionText, -1L, actionHandler);
    }

    public void show(String message, String actionText, long timeout, EventHandler<? super MouseEvent> actionHandler) {
        this.show(message, null, actionText, timeout, actionHandler);
    }

    public void show(String message, String pseudoClass, String actionText, long timeout, EventHandler<? super MouseEvent> actionHandler) {
        this.toast.setText(message);
        if (actionText != null && !actionText.isEmpty()) {
            this.action.setVisible(true);
            this.actionContainer.setVisible(true);
            this.actionContainer.setManaged(true);
            this.action.setText("");
            this.action.setText(actionText);
            this.action.setOnMouseClicked(actionHandler);
        } else {
            this.actionContainer.setVisible(false);
            this.actionContainer.setManaged(false);
            this.action.setVisible(false);
        }
        this.openAnimation = this.getTimeline(timeout);
        if (pseudoClass != null) {
            this.activePseudoClass = pseudoClass;
            this.content.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)this.activePseudoClass), true);
        }
        this.openAnimation.play();
    }

    private Timeline getTimeline(long timeout) {
        Timeline animation;
        if (timeout <= 0L) {
            animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, JFXSnackbar$$Lambda$6.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)this.popup.getLayoutBounds().getHeight(), this.easeInterpolator), new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)10.0), JFXSnackbar$$Lambda$7.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)true, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)1, this.easeInterpolator), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)0, this.easeInterpolator)})});
            animation.setCycleCount(1);
        } else {
            animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, JFXSnackbar$$Lambda$8.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)this.popup.getLayoutBounds().getHeight(), this.easeInterpolator), new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)10.0), JFXSnackbar$$Lambda$9.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)true, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)1, this.easeInterpolator), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)(timeout / 2L)), new KeyValue[0])});
            animation.setAutoReverse(true);
            animation.setCycleCount(2);
            animation.setOnFinished(JFXSnackbar$$Lambda$10.lambdaFactory$(this));
        }
        return animation;
    }

    public void close() {
        this.openAnimation.stop();
        Timeline closeAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, JFXSnackbar$$Lambda$11.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)1, this.easeInterpolator), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)290.0), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)true, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)300.0), JFXSnackbar$$Lambda$12.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)this.popup.getLayoutBounds().getHeight(), this.easeInterpolator), new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)0, this.easeInterpolator)})});
        closeAnimation.setCycleCount(1);
        closeAnimation.setOnFinished(JFXSnackbar$$Lambda$13.lambdaFactory$(this));
        closeAnimation.play();
    }

    private void resetPseudoClass() {
        if (this.activePseudoClass != null) {
            this.content.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)this.activePseudoClass), false);
            this.activePseudoClass = null;
        }
    }

    private void processSnackbars() {
        SnackbarEvent qevent = this.eventQueue.poll();
        if (qevent != null) {
            if (qevent.isPersistent()) {
                this.show(qevent.getMessage(), qevent.getpseudoClass(), qevent.getActionText(), qevent.getActionHandler());
            } else {
                this.show(qevent.getMessage(), qevent.getpseudoClass(), qevent.getActionText(), qevent.getTimeout(), qevent.getActionHandler());
            }
        } else {
            this.processingQueue.getAndSet(false);
        }
    }

    public void refreshPopup() {
        Bounds contentBound = this.popup.getLayoutBounds();
        double offsetX = Math.ceil(this.snackbarContainer.getWidth() / 2.0) - Math.ceil(contentBound.getWidth() / 2.0);
        double offsetY = this.snackbarContainer.getHeight() - contentBound.getHeight();
        this.popup.setLayoutX(offsetX);
        this.popup.setLayoutY(offsetY);
    }

    public void enqueue(SnackbarEvent event) {
        this.eventQueue.add(event);
        if (this.processingQueue.compareAndSet(false, true)) {
            Platform.runLater((Runnable)JFXSnackbar$$Lambda$14.lambdaFactory$(this));
        }
    }

    static /* synthetic */ void lambda$enqueue$13(JFXSnackbar this_) {
        SnackbarEvent qevent = this_.eventQueue.poll();
        if (qevent != null) {
            if (qevent.isPersistent()) {
                this_.show(qevent.getMessage(), qevent.getpseudoClass(), qevent.getActionText(), qevent.getActionHandler());
            } else {
                this_.show(qevent.getMessage(), qevent.getpseudoClass(), qevent.getActionText(), qevent.getTimeout(), qevent.getActionHandler());
            }
        }
    }

    static /* synthetic */ void lambda$close$12(JFXSnackbar this_, ActionEvent e) {
        this_.resetPseudoClass();
        this_.processSnackbars();
    }

    static /* synthetic */ void lambda$close$11(JFXSnackbar this_, ActionEvent e) {
        this_.popup.toBack();
    }

    static /* synthetic */ void lambda$close$10(JFXSnackbar this_, ActionEvent e) {
        this_.popup.toFront();
    }

    static /* synthetic */ void lambda$getTimeline$9(JFXSnackbar this_, ActionEvent e) {
        this_.resetPseudoClass();
        this_.processSnackbars();
    }

    static /* synthetic */ void lambda$getTimeline$8(JFXSnackbar this_, ActionEvent e) {
        this_.popup.toFront();
    }

    static /* synthetic */ void lambda$getTimeline$7(JFXSnackbar this_, ActionEvent e) {
        this_.popup.toBack();
    }

    static /* synthetic */ void lambda$getTimeline$6(JFXSnackbar this_, ActionEvent e) {
        this_.popup.toFront();
    }

    static /* synthetic */ void lambda$getTimeline$5(JFXSnackbar this_, ActionEvent e) {
        this_.popup.toBack();
    }

    static /* synthetic */ void lambda$new$4(JFXSnackbar this_, SnackbarEvent e) {
        this_.enqueue(e);
    }

    static /* synthetic */ void lambda$new$3(JFXSnackbar this_, ObservableValue o, Bounds oldVal, Bounds newVal) {
        this_.refreshPopup();
    }

    static /* synthetic */ void lambda$new$2(JFXSnackbar this_, ObservableValue o, Number oldVal, Number newVal) {
        this_.refreshPopup();
    }

    static /* synthetic */ void lambda$new$1(JFXSnackbar this_, ListChangeListener.Change c) {
        while (c.next()) {
            if (c.wasAdded()) {
                this_.popup.getStyleClass().addAll((Collection)c.getAddedSubList());
            }
            if (!c.wasRemoved()) continue;
            this_.popup.getStyleClass().removeAll((Collection)c.getRemoved());
        }
    }

    static /* synthetic */ Double lambda$new$0(JFXSnackbar this_) throws Exception {
        if (this_.getPrefWidth() == -1.0) {
            return this_.getPrefWidth();
        }
        double actionWidth = this_.actionContainer.isVisible() ? this_.actionContainer.getWidth() : 0.0;
        return this_.prefWidthProperty().get() - actionWidth;
    }

    public static class SnackbarEvent
    extends Event {
        public static final EventType<SnackbarEvent> SNACKBAR = new EventType(Event.ANY, "SNACKBAR");
        private final String message;
        private final String actionText;
        private final String pseudoClass;
        private final long timeout;
        private final boolean persistent;
        private final EventHandler<? super MouseEvent> actionHandler;

        public SnackbarEvent(String message) {
            this(message, null, 3000L, false, null);
        }

        public SnackbarEvent(String message, String pseudoClass) {
            this(message, pseudoClass, null, 3000L, false, null);
        }

        public SnackbarEvent(String message, String actionText, long timeout, boolean persistent, EventHandler<? super MouseEvent> actionHandler) {
            this(message, null, actionText, timeout, persistent, actionHandler);
        }

        public SnackbarEvent(String message, String pseudoClass, String actionText, long timeout, boolean persistent, EventHandler<? super MouseEvent> actionHandler) {
            super(SNACKBAR);
            this.message = message;
            this.pseudoClass = pseudoClass;
            this.actionText = actionText;
            this.timeout = timeout < 1L ? 3000L : timeout;
            this.actionHandler = actionHandler;
            this.persistent = persistent;
        }

        public String getMessage() {
            return this.message;
        }

        public String getActionText() {
            return this.actionText;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public EventHandler<? super MouseEvent> getActionHandler() {
            return this.actionHandler;
        }

        public EventType<? extends SnackbarEvent> getEventType() {
            return super.getEventType();
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public String getpseudoClass() {
            return this.pseudoClass;
        }
    }
}

