/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.concurrency.JFXUtilities;
import com.jfoenix.controls.JFXTreeTableRow;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$1;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$10;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$11;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$12;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$13;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$14;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$15;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$16;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$17;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$18;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$2;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$3;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$4;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$5;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$6;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$7;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$8;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$9;
import com.jfoenix.controls.RecursiveTreeItem;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import com.jfoenix.skins.JFXTreeTableViewSkin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;

public class JFXTreeTableView<S extends RecursiveTreeObject<S>>
extends TreeTableView<S> {
    private TreeItem<S> originalRoot;
    private boolean itemWasSelected = false;
    private ObservableList<TreeTableColumn<S, ?>> groupOrder = FXCollections.observableArrayList();
    private final Lock lock = new ReentrantLock(true);
    private ScheduledExecutorService threadPool = this.createThreadPool();
    private Runnable filterRunnable;
    private ScheduledFuture<?> task;
    private ObjectProperty<Predicate<TreeItem<S>>> predicate;
    private IntegerProperty currentItemsCount;
    private Map<Object, Map<Object, ?>> groups;

    public JFXTreeTableView() {
        this.filterRunnable = JFXTreeTableView$$Lambda$1.lambdaFactory$(this);
        this.predicate = new SimpleObjectProperty((Object)JFXTreeTableView$$Lambda$2.lambdaFactory$());
        this.currentItemsCount = new SimpleIntegerProperty(0);
        this.init();
    }

    public JFXTreeTableView(TreeItem<S> root) {
        super(root);
        this.filterRunnable = JFXTreeTableView$$Lambda$3.lambdaFactory$(this);
        this.predicate = new SimpleObjectProperty((Object)JFXTreeTableView$$Lambda$4.lambdaFactory$());
        this.currentItemsCount = new SimpleIntegerProperty(0);
        this.originalRoot = root;
        this.init();
    }

    public void propagateMouseEventsToParent() {
        this.addEventHandler(MouseEvent.ANY, JFXTreeTableView$$Lambda$5.lambdaFactory$(this));
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXTreeTableViewSkin(this);
    }

    protected void init() {
        this.setRowFactory(JFXTreeTableView$$Lambda$6.lambdaFactory$());
        this.getSelectionModel().selectedItemProperty().addListener(JFXTreeTableView$$Lambda$7.lambdaFactory$(this));
        this.predicate.addListener(JFXTreeTableView$$Lambda$8.lambdaFactory$(this));
        this.sceneProperty().addListener(JFXTreeTableView$$Lambda$9.lambdaFactory$(this));
        this.rootProperty().addListener(JFXTreeTableView$$Lambda$10.lambdaFactory$(this));
        this.setCurrentItemsCount(this.count(this.getRoot()));
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/css/controls/jfx-tree-table-view.css").toExternalForm();
    }

    public int getTreeItemLevel(TreeItem<?> node) {
        TreeItem root = this.getRoot();
        if (node == null) {
            return -1;
        }
        if (node == root) {
            return 0;
        }
        int level = 0;
        for (TreeItem parent = node.getParent(); parent != null; parent = parent.getParent()) {
            ++level;
            if (parent == root) break;
            if (parent.getValue() == null || !(parent.getValue() instanceof RecursiveTreeObject) || ((RecursiveTreeObject)parent.getValue()).getGroupedColumn() == null) continue;
            --level;
        }
        return level;
    }

    public void sort() {
        this.getSelectionModel().clearSelection();
        super.sort();
        if (this.itemWasSelected) {
            this.getSelectionModel().select(0);
        }
    }

    final ObservableList<TreeTableColumn<S, ?>> getGroupOrder() {
        return this.groupOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void group(TreeTableColumn<S, ?> ... treeTableColumns) {
        try {
            this.lock.lock();
            if (this.groupOrder.size() == 0) {
                this.groups = new HashMap();
            }
            try {
                if (this.originalRoot == null) {
                    this.originalRoot = this.getRoot();
                }
                for (TreeTableColumn<S, ?> treeTableColumn : treeTableColumns) {
                    this.groups = this.group(treeTableColumn, this.groups, null, (RecursiveTreeItem)this.originalRoot);
                }
                this.groupOrder.addAll((Object[])treeTableColumns);
                this.buildGroupedRoot(this.groups, null, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void refreshGroups(List<TreeTableColumn<S, ?>> groupColumns) {
        this.groups = new HashMap();
        for (TreeTableColumn<S, ?> treeTableColumn : groupColumns) {
            this.groups = this.group(treeTableColumn, this.groups, null, (RecursiveTreeItem)this.originalRoot);
        }
        this.groupOrder.addAll(groupColumns);
        this.buildGroupedRoot(this.groups, null, 0);
    }

    public void unGroup(TreeTableColumn<S, ?> ... treeTableColumns) {
        try {
            this.lock.lock();
            if (this.groupOrder.size() > 0) {
                this.groupOrder.removeAll((Object[])treeTableColumns);
                ArrayList grouped = new ArrayList();
                grouped.addAll((Collection<TreeTableColumn<S, ?>>)this.groupOrder);
                this.groupOrder.clear();
                JFXUtilities.runInFXAndWait(JFXTreeTableView$$Lambda$11.lambdaFactory$(this, grouped));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private Map group(TreeTableColumn<S, ?> column, Map parentGroup, Object key, RecursiveTreeItem<S> root) {
        if (parentGroup.isEmpty()) {
            parentGroup = this.groupByFunction((List<TreeItem<S>>)root.filteredItems, column);
            return parentGroup;
        }
        Object value = parentGroup.get(key);
        if (value instanceof List) {
            Map newGroup = this.groupByFunction((List)value, column);
            parentGroup.put(key, newGroup);
            return parentGroup;
        }
        if (value instanceof Map) {
            for (Object childKey : ((Map)value).keySet()) {
                value = this.group(column, (Map)value, childKey, root);
            }
            parentGroup.put(key, value);
            return parentGroup;
        }
        if (key == null) {
            for (Object childKey : parentGroup.keySet()) {
                parentGroup = this.group(column, parentGroup, childKey, root);
            }
            return parentGroup;
        }
        return parentGroup;
    }

    protected Map groupByFunction(List<TreeItem<S>> items, TreeTableColumn<S, ?> column) {
        HashMap map = new HashMap();
        for (TreeItem<S> child : items) {
            Object key = column.getCellData(child);
            map.computeIfAbsent(key, JFXTreeTableView$$Lambda$12.lambdaFactory$());
            ((List)map.get(key)).add(child);
        }
        return map;
    }

    private void buildGroupedRoot(Map groupedItems, RecursiveTreeItem parent, int groupIndex) {
        boolean setRoot = false;
        if (parent == null) {
            parent = new RecursiveTreeItem(new RecursiveTreeObject(), JFXTreeTableView$$Lambda$13.lambdaFactory$());
            setRoot = true;
        }
        for (Object key : groupedItems.keySet()) {
            RecursiveTreeObject groupItem = new RecursiveTreeObject();
            groupItem.setGroupedValue(key);
            groupItem.setGroupedColumn((TreeTableColumn)this.groupOrder.get(groupIndex));
            RecursiveTreeItem node = new RecursiveTreeItem(groupItem, JFXTreeTableView$$Lambda$14.lambdaFactory$());
            node.expandedProperty().addListener(JFXTreeTableView$$Lambda$15.lambdaFactory$(this));
            parent.originalItems.add(node);
            parent.getChildren().add(node);
            Object children = groupedItems.get(key);
            if (children instanceof List) {
                node.originalItems.addAll((Collection)((List)children));
                node.getChildren().addAll((Collection)((List)children));
                continue;
            }
            if (!(children instanceof Map)) continue;
            this.buildGroupedRoot((Map)children, node, groupIndex + 1);
        }
        if (setRoot) {
            RecursiveTreeItem newParent = parent;
            JFXUtilities.runInFX(JFXTreeTableView$$Lambda$16.lambdaFactory$(this, newParent));
        }
    }

    private ScheduledExecutorService createThreadPool() {
        return Executors.newScheduledThreadPool(1, JFXTreeTableView$$Lambda$17.lambdaFactory$());
    }

    private void filter(Predicate<TreeItem<S>> predicate) {
        if (this.task != null) {
            this.task.cancel(false);
        }
        this.task = this.threadPool.schedule(this.filterRunnable, 200L, TimeUnit.MILLISECONDS);
    }

    public void reGroup() {
        if (!this.groupOrder.isEmpty()) {
            ArrayList tempGroups = new ArrayList(this.groupOrder);
            this.groupOrder.clear();
            this.group(tempGroups.toArray(new TreeTableColumn[tempGroups.size()]));
        }
    }

    public final ObjectProperty<Predicate<TreeItem<S>>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<TreeItem<S>> getPredicate() {
        return (Predicate)this.predicateProperty().get();
    }

    public final void setPredicate(Predicate<TreeItem<S>> predicate) {
        this.predicateProperty().set(predicate);
    }

    public final IntegerProperty currentItemsCountProperty() {
        return this.currentItemsCount;
    }

    public final int getCurrentItemsCount() {
        return this.currentItemsCountProperty().get();
    }

    public final void setCurrentItemsCount(int currentItemsCount) {
        this.currentItemsCountProperty().set(currentItemsCount);
    }

    private int count(TreeItem<?> node) {
        if (node == null) {
            return 0;
        }
        int count = 1;
        if (node.getValue() == null || node.getValue() != null && node.getValue().getClass().equals(RecursiveTreeObject.class)) {
            count = 0;
        }
        for (TreeItem child : node.getChildren()) {
            count += this.count(child);
        }
        return count;
    }

    static /* synthetic */ boolean lambda$new$13(TreeItem t) {
        return true;
    }

    static /* synthetic */ void lambda$new$12(JFXTreeTableView this_) {
        if (this_.originalRoot == null) {
            this_.originalRoot = this_.getRoot();
        }
        ((RecursiveTreeItem)this_.originalRoot).setPredicate(this_.getPredicate());
        this_.reGroup();
        Platform.runLater((Runnable)JFXTreeTableView$$Lambda$18.lambdaFactory$(this_));
    }

    static /* synthetic */ void lambda$null$11(JFXTreeTableView this_) {
        this_.getSelectionModel().select(0);
        this_.setCurrentItemsCount(this_.count(this_.getRoot()));
    }

    static /* synthetic */ Thread lambda$createThreadPool$10(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName("JFXTreeTableView Filter Thread");
        thread.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(thread);
        return thread;
    }

    static /* synthetic */ void lambda$buildGroupedRoot$9(JFXTreeTableView this_, RecursiveTreeItem newParent) {
        ArrayList sortOrder = new ArrayList();
        sortOrder.addAll(this_.getSortOrder());
        this_.setRoot(newParent);
        this_.getSortOrder().addAll(sortOrder);
        this_.getSelectionModel().select(0);
    }

    static /* synthetic */ void lambda$buildGroupedRoot$8(JFXTreeTableView this_, ObservableValue o, Boolean oldVal, Boolean newVal) {
        this_.getSelectionModel().clearSelection();
    }

    static /* synthetic */ List lambda$groupByFunction$7(Object k) {
        return new ArrayList();
    }

    static /* synthetic */ void lambda$unGroup$6(JFXTreeTableView this_, List grouped) {
        ArrayList sortOrder = new ArrayList();
        sortOrder.addAll(this_.getSortOrder());
        List<Object> children = Arrays.asList(this_.originalRoot.getChildren().toArray());
        this_.originalRoot.getChildren().clear();
        this_.originalRoot.getChildren().setAll(children);
        this_.setRoot(this_.originalRoot);
        this_.getSelectionModel().select(0);
        this_.getSortOrder().addAll(sortOrder);
        if (grouped.size() != 0) {
            this_.refreshGroups(grouped);
        }
    }

    static /* synthetic */ void lambda$init$5(JFXTreeTableView this_, Observable observable) {
        if (this_.getRoot() != null) {
            this_.setCurrentItemsCount(this_.count(this_.getRoot()));
        }
    }

    static /* synthetic */ void lambda$init$4(JFXTreeTableView this_, Observable observable) {
        if (this_.getScene() == null) {
            this_.threadPool.shutdownNow();
        } else if (this_.threadPool.isTerminated()) {
            this_.threadPool = this_.createThreadPool();
        }
    }

    static /* synthetic */ void lambda$init$3(JFXTreeTableView this_, Observable observable) {
        this_.filter(this_.getPredicate());
    }

    static /* synthetic */ void lambda$init$2(JFXTreeTableView this_, ObservableValue o, TreeItem oldVal, TreeItem newVal) {
        if (newVal != null && newVal.getValue() != null) {
            this_.itemWasSelected = true;
        }
    }

    static /* synthetic */ TreeTableRow lambda$init$1(TreeTableView param) {
        return new JFXTreeTableRow();
    }

    static /* synthetic */ void lambda$propagateMouseEventsToParent$0(JFXTreeTableView this_, MouseEvent e) {
        e.consume();
        this_.getParent().fireEvent((Event)e);
    }
}

