/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXTreeTableColumn;
import com.jfoenix.controls.JFXTreeTableView;
import com.jfoenix.controls.behavior.JFXTreeTableCellBehavior;
import com.jfoenix.skins.JFXTreeTableRowSkin;
import com.sun.javafx.scene.control.behavior.TreeTableCellBehavior;
import com.sun.javafx.scene.control.skin.TableCellSkinBase;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;

public class JFXTreeTableCellSkin<S, T>
extends TableCellSkinBase<TreeTableCell<S, T>, TreeTableCellBehavior<S, T>> {
    private final TreeTableColumn<S, T> tableColumn;

    public JFXTreeTableCellSkin(TreeTableCell<S, T> treeTableCell) {
        super(treeTableCell, new JFXTreeTableCellBehavior<S, T>(treeTableCell));
        this.tableColumn = treeTableCell.getTableColumn();
        super.init(treeTableCell);
    }

    protected BooleanProperty columnVisibleProperty() {
        return this.tableColumn.visibleProperty();
    }

    protected ReadOnlyDoubleProperty columnWidthProperty() {
        return this.tableColumn.widthProperty();
    }

    protected double leftLabelPadding() {
        double leftPadding = super.leftLabelPadding();
        double height = this.getCellSize();
        TreeTableColumn tableColumn = ((TreeTableCell)this.getSkinnable()).getTableColumn();
        if (tableColumn == null) {
            return leftPadding;
        }
        TreeTableView treeTable = ((TreeTableCell)this.getSkinnable()).getTreeTableView();
        if (treeTable == null) {
            return leftPadding;
        }
        int columnIndex = treeTable.getVisibleLeafIndex(tableColumn);
        TreeTableColumn treeColumn = treeTable.getTreeColumn();
        if (!(treeTable instanceof JFXTreeTableView) && (treeColumn == null && columnIndex != 0 || treeColumn != null && !tableColumn.equals(treeColumn))) {
            return leftPadding;
        }
        TreeTableRow treeTableRow = ((TreeTableCell)this.getSkinnable()).getTreeTableRow();
        if (treeTableRow == null) {
            return leftPadding;
        }
        TreeItem treeItem = ((TreeTableCell)this.getSkinnable()).getTreeTableRow().getTreeItem();
        if (treeItem == null) {
            return leftPadding;
        }
        TreeTableColumn treeTableColumn = treeColumn = treeTable.getTreeColumn() == null ? treeTable.getVisibleLeafColumn(0) : treeTable.getTreeColumn();
        if (tableColumn == treeColumn) {
            int nodeLevel = treeTable.getTreeItemLevel(treeItem);
            if (!treeTable.isShowRoot()) {
                --nodeLevel;
            }
            double indentPerLevel = 10.0;
            if (treeTableRow.getSkin() instanceof JFXTreeTableRowSkin) {
                indentPerLevel = ((JFXTreeTableRowSkin)treeTableRow.getSkin()).getIndentationPerLevel();
            }
            leftPadding += (double)nodeLevel * indentPerLevel;
        }
        if ((tableColumn == treeColumn || ((JFXTreeTableColumn)tableColumn).isGrouped()) && JFXTreeTableRowSkin.disclosureWidthMap != null && JFXTreeTableRowSkin.disclosureWidthMap.containsKey(treeTable)) {
            leftPadding += JFXTreeTableRowSkin.disclosureWidthMap.get(treeTable).doubleValue();
        }
        return leftPadding += treeItem.getGraphic() == null ? 0.0 : treeItem.getGraphic().prefWidth(height);
    }
}

