/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision;

import java.util.UUID;
import org.dyn4j.DataContainer;
import org.dyn4j.collision.Filter;
import org.dyn4j.geometry.Convex;
import org.dyn4j.resources.Messages;

public class Fixture
implements DataContainer {
    protected final UUID id;
    protected final Convex shape;
    protected Filter filter;
    protected boolean sensor;
    protected Object userData;

    public Fixture(Convex shape) {
        if (shape == null) {
            throw new NullPointerException(Messages.getString("collision.fixture.nullShape"));
        }
        this.id = UUID.randomUUID();
        this.shape = shape;
        this.filter = Filter.DEFAULT_FILTER;
        this.sensor = false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Fixture) {
            return this.id.equals(((Fixture)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fixture[Id=").append(this.id).append("|Shape=").append(this.shape).append("|Filter=").append(this.filter).append("|IsSensor=").append(this.sensor).append("]");
        return sb.toString();
    }

    public UUID getId() {
        return this.id;
    }

    public Convex getShape() {
        return this.shape;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        if (filter == null) {
            throw new NullPointerException(Messages.getString("collision.fixture.nullFilter"));
        }
        this.filter = filter;
    }

    public boolean isSensor() {
        return this.sensor;
    }

    public void setSensor(boolean flag) {
        this.sensor = flag;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object userData) {
        this.userData = userData;
    }
}

