/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import java.util.List;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Fixture;
import org.dyn4j.collision.broadphase.BroadphaseDetector;
import org.dyn4j.collision.broadphase.BroadphaseFilter;
import org.dyn4j.collision.broadphase.BroadphaseItem;
import org.dyn4j.collision.broadphase.BroadphasePair;
import org.dyn4j.collision.broadphase.DefaultBroadphaseFilter;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public abstract class AbstractBroadphaseDetector<E extends Collidable<T>, T extends Fixture>
implements BroadphaseDetector<E, T> {
    protected final BroadphaseFilter<E, T> defaultFilter = new DefaultBroadphaseFilter();
    protected double expansion = 0.2;

    @Override
    public void add(E collidable) {
        int size = collidable.getFixtureCount();
        int i = 0;
        while (i < size) {
            Object fixture = collidable.getFixture(i);
            this.add(collidable, fixture);
            ++i;
        }
    }

    @Override
    public void remove(E collidable) {
        int size = collidable.getFixtureCount();
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            Object fixture = collidable.getFixture(i);
            this.remove(collidable, fixture);
            ++i;
        }
    }

    @Override
    public void update(E collidable) {
        int size = collidable.getFixtureCount();
        int i = 0;
        while (i < size) {
            Object fixture = collidable.getFixture(i);
            this.update(collidable, fixture);
            ++i;
        }
    }

    @Override
    public boolean detect(E a, E b) {
        AABB aAABB = this.getAABB(a);
        AABB bAABB = this.getAABB(b);
        if (aAABB == null || bAABB == null) {
            return false;
        }
        return aAABB.overlaps(bAABB);
    }

    @Override
    public AABB getAABB(E collidable) {
        int size = collidable.getFixtureCount();
        if (size == 0) {
            return new AABB(0.0, 0.0, 0.0, 0.0);
        }
        AABB union = this.getAABB(collidable, collidable.getFixture(0));
        int i = 1;
        while (i < size) {
            AABB aabb = this.getAABB(collidable, collidable.getFixture(i));
            union.union(aabb);
            ++i;
        }
        return union;
    }

    @Override
    public boolean detect(Convex convex1, Transform transform1, Convex convex2, Transform transform2) {
        AABB b;
        AABB a = convex1.createAABB(transform1);
        return a.overlaps(b = convex2.createAABB(transform2));
    }

    protected boolean raycast(Vector2 start, double length, double invDx, double invDy, AABB aabb) {
        double tx1 = (aabb.getMinX() - start.x) * invDx;
        double tx2 = (aabb.getMaxX() - start.x) * invDx;
        double tmin = Math.min(tx1, tx2);
        double tmax = Math.max(tx1, tx2);
        double ty1 = (aabb.getMinY() - start.y) * invDy;
        double ty2 = (aabb.getMaxY() - start.y) * invDy;
        tmin = Math.max(tmin, Math.min(ty1, ty2));
        if ((tmax = Math.min(tmax, Math.max(ty1, ty2))) < 0.0) {
            return false;
        }
        if (tmin > length) {
            return false;
        }
        return tmax >= tmin;
    }

    @Override
    public List<BroadphasePair<E, T>> detect() {
        return this.detect(this.defaultFilter);
    }

    @Override
    public List<BroadphaseItem<E, T>> detect(AABB aabb) {
        return this.detect(aabb, this.defaultFilter);
    }

    @Override
    public List<BroadphaseItem<E, T>> raycast(Ray ray, double length) {
        return this.raycast(ray, length, this.defaultFilter);
    }

    @Override
    public double getAABBExpansion() {
        return this.expansion;
    }

    @Override
    public void setAABBExpansion(double expansion) {
        this.expansion = expansion;
    }
}

