/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import java.util.UUID;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Fixture;

final class BroadphaseKey {
    final UUID collidable;
    final UUID fixture;
    private final int hashCode;

    public BroadphaseKey(UUID collidable, UUID fixture) {
        this.collidable = collidable;
        this.fixture = fixture;
        this.hashCode = this.computeHashCode();
    }

    public static final BroadphaseKey get(Collidable<?> collidable, Fixture fixture) {
        return new BroadphaseKey(collidable.getId(), fixture.getId());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return false;
        }
        if (obj instanceof BroadphaseKey) {
            BroadphaseKey key = (BroadphaseKey)obj;
            return key.collidable.equals(this.collidable) && key.fixture.equals(this.fixture);
        }
        return false;
    }

    protected final int computeHashCode() {
        int hash = 17;
        hash = hash * 31 + this.collidable.hashCode();
        hash = hash * 31 + this.fixture.hashCode();
        return hash;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BroadphaseKey[CollidableId=").append(this.collidable).append("|FixtureId=").append(this.fixture).append("]");
        return sb.toString();
    }
}

