/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Collisions;
import org.dyn4j.collision.Fixture;
import org.dyn4j.collision.broadphase.AbstractBroadphaseDetector;
import org.dyn4j.collision.broadphase.BroadphaseDetector;
import org.dyn4j.collision.broadphase.BroadphaseFilter;
import org.dyn4j.collision.broadphase.BroadphaseItem;
import org.dyn4j.collision.broadphase.BroadphaseKey;
import org.dyn4j.collision.broadphase.BroadphasePair;
import org.dyn4j.collision.broadphase.SapProxy;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public class Sap<E extends Collidable<T>, T extends Fixture>
extends AbstractBroadphaseDetector<E, T>
implements BroadphaseDetector<E, T> {
    TreeSet<SapProxy<E, T>> tree = new TreeSet();
    Map<BroadphaseKey, SapProxy<E, T>> map;

    public Sap() {
        this(64);
    }

    public Sap(int initialCapacity) {
        this.map = new HashMap<BroadphaseKey, SapProxy<E, T>>(initialCapacity * 4 / 3 + 1, 0.75f);
    }

    @Override
    public void add(E collidable, T fixture) {
        BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
        SapProxy<E, T> proxy = this.map.get(key);
        if (proxy == null) {
            this.add(key, collidable, fixture);
        } else {
            this.update(key, proxy, collidable, fixture);
        }
    }

    void add(BroadphaseKey key, E collidable, T fixture) {
        Transform tx = collidable.getTransform();
        AABB aabb = ((Fixture)fixture).getShape().createAABB(tx);
        aabb.expand(this.expansion);
        SapProxy<E, T> proxy = new SapProxy<E, T>(collidable, fixture, aabb);
        this.map.put(key, proxy);
        this.tree.add(proxy);
    }

    @Override
    public boolean remove(E collidable, T fixture) {
        BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
        SapProxy<E, T> proxy = this.map.remove(key);
        if (proxy != null) {
            this.tree.remove(proxy);
            return true;
        }
        return false;
    }

    @Override
    public void update(E collidable, T fixture) {
        BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
        SapProxy<E, T> proxy = this.map.get(key);
        if (proxy != null) {
            this.update(key, proxy, collidable, fixture);
        } else {
            this.add(key, collidable, fixture);
        }
    }

    void update(BroadphaseKey key, SapProxy<E, T> proxy, E collidable, T fixture) {
        Transform tx = collidable.getTransform();
        AABB aabb = ((Fixture)fixture).getShape().createAABB(tx);
        if (proxy.aabb.contains(aabb)) {
            return;
        }
        aabb.expand(this.expansion);
        this.tree.remove(proxy);
        proxy.aabb = aabb;
        this.tree.add(proxy);
    }

    @Override
    public AABB getAABB(E collidable, T fixture) {
        BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
        SapProxy<E, T> proxy = this.map.get(key);
        if (proxy != null) {
            return proxy.aabb;
        }
        return ((Fixture)fixture).getShape().createAABB(collidable.getTransform());
    }

    @Override
    public boolean contains(E collidable) {
        int size = collidable.getFixtureCount();
        boolean result = true;
        int i = 0;
        while (i < size) {
            Object fixture = collidable.getFixture(i);
            BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
            result &= this.map.containsKey(key);
            ++i;
        }
        return result;
    }

    @Override
    public boolean contains(E collidable, T fixture) {
        BroadphaseKey key = BroadphaseKey.get(collidable, fixture);
        return this.map.containsKey(key);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.tree.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public List<BroadphasePair<E, T>> detect(BroadphaseFilter<E, T> filter) {
        int size = this.tree.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        int eSize = Collisions.getEstimatedCollisionPairs(size);
        ArrayList pairs = new ArrayList(eSize);
        for (SapProxy<E, T> p : this.tree) {
            p.tested = false;
        }
        for (SapProxy<E, T> current : this.tree) {
            NavigableSet<SapProxy<E, T>> set = this.tree.tailSet(current, false);
            for (SapProxy sapProxy : set) {
                if (sapProxy.collidable == current.collidable || sapProxy.tested) continue;
                if (!(current.aabb.getMaxX() >= sapProxy.aabb.getMinX())) break;
                if (!current.aabb.overlaps(sapProxy.aabb) || !filter.isAllowed(current.collidable, current.fixture, sapProxy.collidable, sapProxy.fixture)) continue;
                pairs.add(new BroadphasePair(current.collidable, current.fixture, sapProxy.collidable, sapProxy.fixture));
            }
            current.tested = true;
        }
        return pairs;
    }

    @Override
    public List<BroadphaseItem<E, T>> detect(AABB aabb, BroadphaseFilter<E, T> filter) {
        int size = this.tree.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(Collisions.getEstimatedCollisionsPerObject());
        SapProxy<Object, Object> search = new SapProxy<Object, Object>(null, null, aabb);
        SapProxy<Object, Object> least = this.tree.ceiling(search);
        if (least == null) {
            return Collections.emptyList();
        }
        Iterator<SapProxy<E, T>> it = this.tree.iterator();
        boolean found = false;
        while (it.hasNext()) {
            SapProxy<E, T> proxy = it.next();
            if (proxy == least) {
                found = true;
            }
            if (proxy.aabb.getMaxX() > aabb.getMinX()) {
                if (!proxy.aabb.overlaps(aabb) || !filter.isAllowed(aabb, proxy.collidable, proxy.fixture)) continue;
                list.add(new BroadphaseItem(proxy.collidable, proxy.fixture));
                continue;
            }
            if (found) break;
        }
        return list;
    }

    @Override
    public List<BroadphaseItem<E, T>> raycast(Ray ray, double length, BroadphaseFilter<E, T> filter) {
        if (this.tree.size() == 0) {
            return Collections.emptyList();
        }
        Vector2 s = ray.getStart();
        Vector2 d = ray.getDirectionVector();
        double l = length;
        if (length <= 0.0) {
            l = Double.MAX_VALUE;
        }
        double x1 = s.x;
        double x2 = s.x + d.x * l;
        double y1 = s.y;
        double y2 = s.y + d.y * l;
        Vector2 min = new Vector2(Math.min(x1, x2), Math.min(y1, y2));
        Vector2 max = new Vector2(Math.max(x1, x2), Math.max(y1, y2));
        AABB aabb = new AABB(min, max);
        double invDx = 1.0 / d.x;
        double invDy = 1.0 / d.y;
        int size = this.tree.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        int eSize = Collisions.getEstimatedRaycastCollisions(this.map.size());
        ArrayList list = new ArrayList(eSize);
        SapProxy<Object, Object> search = new SapProxy<Object, Object>(null, null, aabb);
        SapProxy<Object, Object> ceil = this.tree.ceiling(search);
        Iterator<SapProxy<E, T>> it = this.tree.iterator();
        boolean found = false;
        while (it.hasNext()) {
            SapProxy<E, T> proxy = it.next();
            if (proxy == ceil) {
                found = true;
            }
            if (proxy.aabb.getMaxX() > aabb.getMinX()) {
                if (!proxy.aabb.overlaps(aabb) || !this.raycast(s, l, invDx, invDy, proxy.aabb) || !filter.isAllowed(ray, length, proxy.collidable, proxy.fixture)) continue;
                list.add(new BroadphaseItem(proxy.collidable, proxy.fixture));
                continue;
            }
            if (found) break;
        }
        return list;
    }

    @Override
    public void shift(Vector2 shift) {
        for (SapProxy<E, T> proxy : this.tree) {
            proxy.aabb.translate(shift);
        }
    }
}

