/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import org.dyn4j.collision.Filter;
import org.dyn4j.collision.broadphase.BroadphaseFilter;
import org.dyn4j.collision.broadphase.BroadphaseFilterAdapter;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.geometry.AABB;

public class AABBBroadphaseFilter
extends BroadphaseFilterAdapter<Body, BodyFixture>
implements BroadphaseFilter<Body, BodyFixture> {
    private final boolean ignoreInactive;
    private final boolean ignoreSensors;
    private final Filter filter;

    public AABBBroadphaseFilter(boolean ignoreInactive, boolean ignoreSensors, Filter filter) {
        this.ignoreInactive = ignoreInactive;
        this.ignoreSensors = ignoreSensors;
        this.filter = filter;
    }

    @Override
    public boolean isAllowed(AABB aabb, Body body, BodyFixture fixture) {
        if (this.ignoreInactive && !body.isActive()) {
            return false;
        }
        if (this.ignoreSensors && fixture.isSensor()) {
            return false;
        }
        if (this.filter != null && !this.filter.isAllowed(fixture.getFilter())) {
            return false;
        }
        return super.isAllowed(aabb, body, fixture);
    }

    public boolean isIgnoreInactive() {
        return this.ignoreInactive;
    }

    public boolean isIgnoreSensors() {
        return this.ignoreSensors;
    }

    public Filter getFilter() {
        return this.filter;
    }
}

