/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

public class Capacity {
    public static final int DEFAULT_BODY_COUNT = 32;
    public static final int DEFAULT_JOINT_COUNT = 16;
    public static final int DEFAULT_LISTENER_COUNT = 16;
    public static final Capacity DEFAULT_CAPACITY = new Capacity();
    private final int bodyCount;
    private final int jointCount;
    private final int listenerCount;

    public Capacity() {
        this(32, 16, 16);
    }

    public Capacity(int bodyCount, int jointCount, int listenerCount) {
        this.bodyCount = bodyCount > 0 ? bodyCount : 32;
        this.jointCount = jointCount > 0 ? jointCount : 16;
        this.listenerCount = listenerCount > 0 ? listenerCount : 16;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Capacity) {
            Capacity capacity = (Capacity)obj;
            return capacity.bodyCount == this.bodyCount && capacity.jointCount == this.jointCount && capacity.listenerCount == this.listenerCount;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.bodyCount;
        hash = hash * 31 + this.jointCount;
        hash = hash * 31 + this.listenerCount;
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Capacity[BodyCount=").append(this.bodyCount).append("|JointCount=").append(this.jointCount).append("|ListenerCount=").append(this.listenerCount).append("]");
        return sb.toString();
    }

    public int getBodyCount() {
        return this.bodyCount;
    }

    public int getJointCount() {
        return this.jointCount;
    }

    public int getListenerCount() {
        return this.listenerCount;
    }
}

