/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.dyn4j.dynamics.World;
import org.dyn4j.dynamics.joint.Joint;

final class JointIterator
implements Iterator<Joint> {
    private final World world;
    private int index;

    public JointIterator(World world) {
        this.world = world;
        this.index = -1;
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.world.getJointCount();
    }

    @Override
    public Joint next() {
        if (this.index >= this.world.getJointCount()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            ++this.index;
            Joint joint = this.world.getJoint(this.index);
            return joint;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void remove() {
        if (this.index < 0) {
            throw new IllegalStateException();
        }
        if (this.index >= this.world.getJointCount()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.world.removeJoint(this.index);
            --this.index;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }
}

