/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import org.dyn4j.collision.narrowphase.Raycast;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.BodyFixture;

public class RaycastResult
implements Comparable<RaycastResult> {
    protected Body body;
    protected BodyFixture fixture;
    protected Raycast raycast;

    public RaycastResult() {
    }

    public RaycastResult(Body body, BodyFixture fixture, Raycast raycast) {
        this.body = body;
        this.fixture = fixture;
        this.raycast = raycast;
    }

    @Override
    public int compareTo(RaycastResult o) {
        return (int)Math.signum(this.raycast.getDistance() - o.raycast.getDistance());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RaycastResult[Body=").append(this.body).append("|Fixture=").append(this.fixture).append("|Raycast=").append(this.raycast).append("]");
        return sb.toString();
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public BodyFixture getFixture() {
        return this.fixture;
    }

    public void setFixture(BodyFixture fixture) {
        this.fixture = fixture;
    }

    public Raycast getRaycast() {
        return this.raycast;
    }

    public void setRaycast(Raycast raycast) {
        this.raycast = raycast;
    }
}

