/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.contact;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dyn4j.collision.Collisions;
import org.dyn4j.dynamics.Capacity;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.contact.Contact;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.dynamics.contact.ContactConstraintId;
import org.dyn4j.dynamics.contact.ContactListener;
import org.dyn4j.dynamics.contact.ContactManager;
import org.dyn4j.dynamics.contact.ContactPoint;
import org.dyn4j.dynamics.contact.ContactPointId;
import org.dyn4j.dynamics.contact.SolvedContactPoint;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class SimpleContactManager
implements ContactManager,
Shiftable {
    protected List<ContactConstraint> constraintQueue;
    protected Map<ContactConstraintId, ContactConstraint> constraints;

    public SimpleContactManager() {
        this(Capacity.DEFAULT_CAPACITY);
    }

    public SimpleContactManager(Capacity initialCapacity) {
        if (initialCapacity == null) {
            throw new NullPointerException(Messages.getString("dynamics.nullCapacity"));
        }
        int eSize = Collisions.getEstimatedCollisionPairs(initialCapacity.getBodyCount());
        this.constraints = new HashMap<ContactConstraintId, ContactConstraint>(eSize * 4 / 3 + 1, 0.75f);
        this.constraintQueue = new ArrayList<ContactConstraint>(eSize);
    }

    @Override
    public void queue(ContactConstraint constraint) {
        this.constraintQueue.add(constraint);
    }

    @Override
    public void clear() {
        this.constraintQueue.clear();
        this.constraints.clear();
    }

    @Override
    public boolean end(ContactConstraint contactConstraint) {
        return this.constraints.remove(contactConstraint.id) != null;
    }

    @Override
    public void shift(Vector2 shift) {
        for (ContactConstraint cc : this.constraints.values()) {
            cc.shift(shift);
        }
    }

    @Override
    public void updateAndNotify(List<ContactListener> listeners, Settings settings) {
        int size = this.constraintQueue.size();
        int lsize = listeners != null ? listeners.size() : 0;
        for (ContactConstraint contactConstraint : this.constraints.values()) {
            int rsize = contactConstraint.contacts.size();
            int i = 0;
            while (i < rsize) {
                Contact contact = contactConstraint.contacts.get(i);
                ContactPoint point = new ContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.fixture1, contactConstraint.getBody2(), contactConstraint.fixture2, contact.p, contactConstraint.normal, contact.depth);
                int l = 0;
                while (l < lsize) {
                    ContactListener listener = listeners.get(l);
                    listener.end(point);
                    ++l;
                }
                ++i;
            }
        }
        this.constraints.clear();
        int i = 0;
        while (i < size) {
            ContactPoint point;
            int j;
            ContactConstraint newContactConstraint = this.constraintQueue.get(i);
            List<Contact> contacts = newContactConstraint.contacts;
            int nsize = contacts.size();
            if (newContactConstraint.sensor) {
                j = 0;
                while (j < nsize) {
                    Contact contact = contacts.get(j);
                    point = new ContactPoint(new ContactPointId(newContactConstraint.id, contact.id), newContactConstraint.getBody1(), newContactConstraint.fixture1, newContactConstraint.getBody2(), newContactConstraint.fixture2, contact.p, newContactConstraint.normal, contact.depth);
                    int l = 0;
                    while (l < lsize) {
                        ContactListener listener = listeners.get(l);
                        listener.sensed(point);
                        ++l;
                    }
                    ++j;
                }
            } else {
                j = nsize - 1;
                while (j >= 0) {
                    Contact contact = contacts.get(j);
                    point = new ContactPoint(new ContactPointId(newContactConstraint.id, contact.id), newContactConstraint.getBody1(), newContactConstraint.fixture1, newContactConstraint.getBody2(), newContactConstraint.fixture2, contact.p, newContactConstraint.normal, contact.depth);
                    boolean allow = true;
                    int l = 0;
                    while (l < lsize) {
                        ContactListener listener = listeners.get(l);
                        if (!listener.begin(point)) {
                            allow = false;
                        }
                        ++l;
                    }
                    if (!allow) {
                        contacts.remove(j);
                    }
                    --j;
                }
                if (newContactConstraint.contacts.size() > 0) {
                    this.constraints.put(newContactConstraint.id, newContactConstraint);
                }
            }
            ++i;
        }
        this.constraintQueue.clear();
    }

    @Override
    public void preSolveNotify(List<ContactListener> listeners) {
        int lsize = listeners != null ? listeners.size() : 0;
        Iterator<ContactConstraint> itContactConstraints = this.constraints.values().iterator();
        while (itContactConstraints.hasNext()) {
            ContactConstraint contactConstraint = itContactConstraints.next();
            int csize = contactConstraint.contacts.size();
            int j = csize - 1;
            while (j >= 0) {
                Contact contact = contactConstraint.contacts.get(j);
                ContactPoint point = new ContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.fixture1, contactConstraint.getBody2(), contactConstraint.fixture2, contact.p, contactConstraint.normal, contact.depth);
                boolean allow = true;
                int l = 0;
                while (l < lsize) {
                    ContactListener listener = listeners.get(l);
                    if (!listener.preSolve(point)) {
                        allow = false;
                    }
                    ++l;
                }
                if (!allow) {
                    contactConstraint.contacts.remove(j);
                }
                --j;
            }
            if (contactConstraint.contacts.size() != 0) continue;
            itContactConstraints.remove();
        }
    }

    @Override
    public void postSolveNotify(List<ContactListener> listeners) {
        int lsize = listeners != null ? listeners.size() : 0;
        for (ContactConstraint contactConstraint : this.constraints.values()) {
            int rsize = contactConstraint.contacts.size();
            int j = 0;
            while (j < rsize) {
                Contact contact = contactConstraint.contacts.get(j);
                SolvedContactPoint point = new SolvedContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.fixture1, contactConstraint.getBody2(), contactConstraint.fixture2, contact.p, contactConstraint.normal, contact.depth, contact.jn, contact.jt);
                int l = 0;
                while (l < lsize) {
                    ContactListener listener = listeners.get(l);
                    listener.postSolve(point);
                    ++l;
                }
                ++j;
            }
        }
    }
}

