/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.contact;

import org.dyn4j.collision.continuous.TimeOfImpact;
import org.dyn4j.collision.narrowphase.Separation;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Vector2;

public class TimeOfImpactSolver {
    public void solve(Body body1, Body body2, TimeOfImpact timeOfImpact, Settings settings) {
        double linearTolerance = settings.getLinearTolerance();
        double maxLinearCorrection = settings.getMaximumLinearCorrection();
        Vector2 c1 = body1.getWorldCenter();
        Vector2 c2 = body2.getWorldCenter();
        Mass m1 = body1.getMass();
        Mass m2 = body2.getMass();
        double mass1 = m1.getMass();
        double mass2 = m2.getMass();
        double invMass1 = mass1 * m1.getInverseMass();
        double invI1 = mass1 * m1.getInverseInertia();
        double invMass2 = mass2 * m2.getInverseMass();
        double invI2 = mass2 * m2.getInverseInertia();
        Separation separation = timeOfImpact.getSeparation();
        Vector2 p1w = separation.getPoint1();
        Vector2 p2w = separation.getPoint2();
        Vector2 r1 = c1.to(p1w);
        Vector2 r2 = c2.to(p2w);
        Vector2 n = separation.getNormal();
        double d = separation.getDistance();
        double C = Interval.clamp(d - linearTolerance, -maxLinearCorrection, 0.0);
        double rn1 = r1.cross(n);
        double rn2 = r2.cross(n);
        double K = invMass1 + invMass2 + invI1 * rn1 * rn1 + invI2 * rn2 * rn2;
        double impulse = 0.0;
        if (K > 0.0) {
            impulse = -C / K;
        }
        Vector2 J = n.product(impulse);
        body1.translate(J.product(invMass1));
        body1.rotate(invI1 * r1.cross(J), c1.x, c1.y);
        body2.translate(J.product(-invMass2));
        body2.rotate(-invI2 * r2.cross(J), c2.x, c2.y);
    }
}

