/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.dynamics.joint.LimitState;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class PulleyJoint
extends Joint
implements Shiftable,
DataContainer {
    protected Vector2 pulleyAnchor1;
    protected Vector2 pulleyAnchor2;
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected double ratio;
    protected boolean slackEnabled;
    private LimitState limitState;
    private final double length1;
    private final double length2;
    private double length;
    private Vector2 n1;
    private Vector2 n2;
    private double invK;
    private double impulse;

    public PulleyJoint(Body body1, Body body2, Vector2 pulleyAnchor1, Vector2 pulleyAnchor2, Vector2 bodyAnchor1, Vector2 bodyAnchor2) {
        super(body1, body2, false);
        if (body1 == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (pulleyAnchor1 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.pulley.nullPulleyAnchor1"));
        }
        if (pulleyAnchor2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.pulley.nullPulleyAnchor2"));
        }
        if (bodyAnchor1 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.pulley.nullBodyAnchor1"));
        }
        if (bodyAnchor2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.pulley.nullBodyAnchor2"));
        }
        this.pulleyAnchor1 = pulleyAnchor1;
        this.pulleyAnchor2 = pulleyAnchor2;
        this.localAnchor1 = body1.getLocalPoint(bodyAnchor1);
        this.localAnchor2 = body2.getLocalPoint(bodyAnchor2);
        this.ratio = 1.0;
        this.length1 = bodyAnchor1.distance(pulleyAnchor1);
        this.length2 = bodyAnchor2.distance(pulleyAnchor2);
        this.length = this.length1 + this.length2;
        this.impulse = 0.0;
        this.slackEnabled = false;
        this.limitState = LimitState.AT_UPPER;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PulleyJoint[").append(super.toString()).append("|PulleyAnchor1=").append(this.pulleyAnchor1).append("|PulleyAnchor2=").append(this.pulleyAnchor2).append("|Anchor1=").append(this.getAnchor1()).append("|Anchor2=").append(this.getAnchor2()).append("|Ratio=").append(this.ratio).append("|Length=").append(this.length).append("|SlackEnabled=").append(this.slackEnabled).append("]");
        return sb.toString();
    }

    @Override
    public void initializeConstraints(Step step, Settings settings) {
        double l2;
        double linearTolerance = settings.getLinearTolerance();
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 p1 = r1.sum(this.body1.getWorldCenter());
        Vector2 p2 = r2.sum(this.body2.getWorldCenter());
        Vector2 s1 = this.pulleyAnchor1;
        Vector2 s2 = this.pulleyAnchor2;
        this.n1 = s1.to(p1);
        this.n2 = s2.to(p2);
        double l1 = this.n1.normalize();
        double l = l1 + this.ratio * (l2 = this.n2.normalize());
        if (l > this.length || !this.slackEnabled) {
            this.limitState = LimitState.AT_UPPER;
            if (l1 <= 10.0 * linearTolerance) {
                this.n1.zero();
            }
            if (l2 <= 10.0 * linearTolerance) {
                this.n2.zero();
            }
            double r1CrossN1 = r1.cross(this.n1);
            double r2CrossN2 = r2.cross(this.n2);
            double pm1 = invM1 + invI1 * r1CrossN1 * r1CrossN1;
            double pm2 = invM2 + invI2 * r2CrossN2 * r2CrossN2;
            this.invK = pm1 + this.ratio * this.ratio * pm2;
            this.invK = this.invK > Epsilon.E ? 1.0 / this.invK : 0.0;
            double dtRatio = step.getDeltaTimeRatio();
            this.impulse *= dtRatio;
            Vector2 J1 = this.n1.product(-this.impulse);
            Vector2 J2 = this.n2.product(-this.ratio * this.impulse);
            this.body1.getLinearVelocity().add(J1.product(invM1));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * r1.cross(J1));
            this.body2.getLinearVelocity().add(J2.product(invM2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() + invI2 * r2.cross(J2));
        } else {
            this.impulse = 0.0;
            this.limitState = LimitState.INACTIVE;
        }
    }

    @Override
    public void solveVelocityConstraints(Step step, Settings settings) {
        if (this.limitState != LimitState.INACTIVE) {
            Transform t1 = this.body1.getTransform();
            Transform t2 = this.body2.getTransform();
            Mass m1 = this.body1.getMass();
            Mass m2 = this.body2.getMass();
            double invM1 = m1.getInverseMass();
            double invM2 = m2.getInverseMass();
            double invI1 = m1.getInverseInertia();
            double invI2 = m2.getInverseInertia();
            Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
            Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
            Vector2 v1 = this.body1.getLinearVelocity().sum(r1.cross(this.body1.getAngularVelocity()));
            Vector2 v2 = this.body2.getLinearVelocity().sum(r2.cross(this.body2.getAngularVelocity()));
            double C = -this.n1.dot(v1) - this.ratio * this.n2.dot(v2);
            double impulse = this.invK * -C;
            this.impulse += impulse;
            Vector2 J1 = this.n1.product(-impulse);
            Vector2 J2 = this.n2.product(-impulse * this.ratio);
            this.body1.getLinearVelocity().add(J1.product(invM1));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * r1.cross(J1));
            this.body2.getLinearVelocity().add(J2.product(invM2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() + invI2 * r2.cross(J2));
        }
    }

    @Override
    public boolean solvePositionConstraints(Step step, Settings settings) {
        if (this.limitState != LimitState.INACTIVE) {
            double linearTolerance = settings.getLinearTolerance();
            Transform t1 = this.body1.getTransform();
            Transform t2 = this.body2.getTransform();
            Mass m1 = this.body1.getMass();
            Mass m2 = this.body2.getMass();
            double invM1 = m1.getInverseMass();
            double invM2 = m2.getInverseMass();
            double invI1 = m1.getInverseInertia();
            double invI2 = m2.getInverseInertia();
            Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
            Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
            Vector2 p1 = r1.sum(this.body1.getWorldCenter());
            Vector2 p2 = r2.sum(this.body2.getWorldCenter());
            Vector2 s1 = this.pulleyAnchor1;
            Vector2 s2 = this.pulleyAnchor2;
            this.n1 = s1.to(p1);
            this.n2 = s2.to(p2);
            double l1 = this.n1.normalize();
            double l2 = this.n2.normalize();
            if (l1 <= 10.0 * linearTolerance) {
                this.n1.zero();
            }
            if (l2 <= 10.0 * linearTolerance) {
                this.n2.zero();
            }
            double linearError = 0.0;
            double r1CrossN1 = r1.cross(this.n1);
            double r2CrossN2 = r2.cross(this.n2);
            double pm1 = invM1 + invI1 * r1CrossN1 * r1CrossN1;
            double pm2 = invM2 + invI2 * r2CrossN2 * r2CrossN2;
            this.invK = pm1 + this.ratio * this.ratio * pm2;
            this.invK = this.invK > Epsilon.E ? 1.0 / this.invK : 0.0;
            double C = this.length - l1 - this.ratio * l2;
            linearError = Math.abs(C);
            double impulse = -this.invK * C;
            Vector2 J1 = this.n1.product(-impulse);
            Vector2 J2 = this.n2.product(-this.ratio * impulse);
            this.body1.translate(J1.x * invM1, J1.y * invM1);
            this.body1.rotateAboutCenter(r1.cross(J1) * invI1);
            this.body2.translate(J2.x * invM2, J2.y * invM2);
            this.body2.rotateAboutCenter(r2.cross(J2) * invI2);
            return linearError < linearTolerance;
        }
        return true;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double invdt) {
        return this.n2.product(this.impulse * invdt);
    }

    @Override
    public double getReactionTorque(double invdt) {
        return 0.0;
    }

    @Override
    public void shift(Vector2 shift) {
        this.pulleyAnchor1.add(shift);
        this.pulleyAnchor2.add(shift);
    }

    public Vector2 getPulleyAnchor1() {
        return this.pulleyAnchor1;
    }

    public Vector2 getPulleyAnchor2() {
        return this.pulleyAnchor2;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
    }

    public double getLength1() {
        Vector2 ba = this.body1.getWorldPoint(this.localAnchor1);
        return this.pulleyAnchor1.distance(ba);
    }

    public double getLength2() {
        Vector2 ba = this.body2.getWorldPoint(this.localAnchor2);
        return this.pulleyAnchor2.distance(ba);
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        if (ratio <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.pulley.invalidRatio"));
        }
        if (ratio != this.ratio) {
            this.ratio = ratio;
            this.length = this.length1 + this.ratio * this.length2;
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
    }

    public boolean isSlackEnabled() {
        return this.slackEnabled;
    }

    public void setSlackEnabled(boolean flag) {
        this.slackEnabled = flag;
    }

    public LimitState getLimitState() {
        return this.limitState;
    }
}

