/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.dynamics.joint.LimitState;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Matrix33;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vector3;
import org.dyn4j.resources.Messages;

public class RevoluteJoint
extends Joint
implements Shiftable,
DataContainer {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected boolean motorEnabled;
    protected double motorSpeed;
    protected double maximumMotorTorque;
    protected boolean limitEnabled;
    protected double upperLimit;
    protected double lowerLimit;
    protected double referenceAngle;
    private LimitState limitState;
    private Matrix33 K;
    private double motorMass;
    private Vector3 impulse;
    private double motorImpulse;

    public RevoluteJoint(Body body1, Body body2, Vector2 anchor) {
        super(body1, body2, false);
        if (body1 == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (anchor == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor"));
        }
        this.localAnchor1 = body1.getLocalPoint(anchor);
        this.localAnchor2 = body2.getLocalPoint(anchor);
        this.lowerLimit = this.referenceAngle = body1.getTransform().getRotation() - body2.getTransform().getRotation();
        this.upperLimit = this.referenceAngle;
        this.limitEnabled = false;
        this.limitState = LimitState.INACTIVE;
        this.impulse = new Vector3();
        this.K = new Matrix33();
        this.motorEnabled = false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RevoluteJoint[").append(super.toString()).append("|Anchor=").append(this.getAnchor1()).append("|IsMotorEnabled=").append(this.motorEnabled).append("|MotorSpeed=").append(this.motorSpeed).append("|MaximumMotorTorque=").append(this.maximumMotorTorque).append("|IsLimitEnabled=").append(this.limitEnabled).append("|LowerLimit=").append(this.lowerLimit).append("|UpperLimit=").append(this.upperLimit).append("|ReferenceAngle=").append(this.referenceAngle).append("]");
        return sb.toString();
    }

    @Override
    public void initializeConstraints(Step step, Settings settings) {
        double angularTolerance = settings.getAngularTolerance();
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        if (this.motorEnabled && invI1 <= 0.0 && invI2 <= 0.0) {
            throw new IllegalStateException(Messages.getString("dynamics.joint.revolute.twoAngularFixedBodies"));
        }
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.K.m00 = invM1 + invM2 + r1.y * r1.y * invI1 + r2.y * r2.y * invI2;
        this.K.m01 = -r1.y * r1.x * invI1 - r2.y * r2.x * invI2;
        this.K.m02 = -r1.y * invI1 - r2.y * invI2;
        this.K.m10 = this.K.m01;
        this.K.m11 = invM1 + invM2 + r1.x * r1.x * invI1 + r2.x * r2.x * invI2;
        this.K.m12 = r1.x * invI1 + r2.x * invI2;
        this.K.m20 = this.K.m02;
        this.K.m21 = this.K.m12;
        this.K.m22 = invI1 + invI2;
        this.motorMass = invI1 + invI2;
        if (this.motorMass > Epsilon.E) {
            this.motorMass = 1.0 / this.motorMass;
        }
        if (!this.motorEnabled) {
            this.motorImpulse = 0.0;
        }
        if (this.limitEnabled) {
            double angle = this.getRelativeRotation();
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * angularTolerance) {
                this.limitState = LimitState.EQUAL;
            } else if (angle <= this.lowerLimit) {
                if (this.limitState != LimitState.AT_LOWER) {
                    this.impulse.z = 0.0;
                }
                this.limitState = LimitState.AT_LOWER;
            } else if (angle >= this.upperLimit) {
                if (this.limitState == LimitState.AT_UPPER) {
                    this.impulse.z = 0.0;
                }
                this.limitState = LimitState.AT_UPPER;
            } else {
                this.impulse.z = 0.0;
                this.limitState = LimitState.INACTIVE;
            }
        } else {
            this.limitState = LimitState.INACTIVE;
        }
        this.impulse.multiply(step.getDeltaTimeRatio());
        this.motorImpulse *= step.getDeltaTimeRatio();
        Vector2 impulse = new Vector2(this.impulse.x, this.impulse.y);
        this.body1.getLinearVelocity().add(impulse.product(invM1));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * (r1.cross(impulse) + this.motorImpulse + this.impulse.z));
        this.body2.getLinearVelocity().subtract(impulse.product(invM2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * (r2.cross(impulse) + this.motorImpulse + this.impulse.z));
    }

    @Override
    public void solveVelocityConstraints(Step step, Settings settings) {
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        if (this.motorEnabled && this.limitState != LimitState.EQUAL) {
            double C = this.body1.getAngularVelocity() - this.body2.getAngularVelocity() - this.motorSpeed;
            double impulse = this.motorMass * -C;
            double oldImpulse = this.motorImpulse;
            double maxImpulse = this.maximumMotorTorque * step.getDeltaTime();
            this.motorImpulse = Interval.clamp(this.motorImpulse + impulse, -maxImpulse, maxImpulse);
            impulse = this.motorImpulse - oldImpulse;
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * impulse);
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * impulse);
        }
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 v1 = this.body1.getLinearVelocity().sum(r1.cross(this.body1.getAngularVelocity()));
        Vector2 v2 = this.body2.getLinearVelocity().sum(r2.cross(this.body2.getAngularVelocity()));
        Vector2 Jvb2 = v1.subtract(v2);
        if (this.limitEnabled && this.limitState != LimitState.INACTIVE) {
            double newImpulse;
            double pivotW = this.body1.getAngularVelocity() - this.body2.getAngularVelocity();
            Vector3 Jvb3 = new Vector3(Jvb2.x, Jvb2.y, pivotW);
            Vector3 impulse3 = this.K.solve33(Jvb3.negate());
            if (this.limitState == LimitState.EQUAL) {
                this.impulse.add(impulse3);
            } else if (this.limitState == LimitState.AT_LOWER) {
                newImpulse = this.impulse.z + impulse3.z;
                if (newImpulse < 0.0) {
                    Vector2 reduced = this.K.solve22(Jvb2.negate());
                    impulse3.x = reduced.x;
                    impulse3.y = reduced.y;
                    impulse3.z = -this.impulse.z;
                    this.impulse.x += reduced.x;
                    this.impulse.y += reduced.y;
                    this.impulse.z = 0.0;
                }
            } else if (this.limitState == LimitState.AT_UPPER && (newImpulse = this.impulse.z + impulse3.z) > 0.0) {
                Vector2 reduced = this.K.solve22(Jvb2.negate());
                impulse3.x = reduced.x;
                impulse3.y = reduced.y;
                impulse3.z = -this.impulse.z;
                this.impulse.x += reduced.x;
                this.impulse.y += reduced.y;
                this.impulse.z = 0.0;
            }
            Vector2 impulse = new Vector2(impulse3.x, impulse3.y);
            this.body1.getLinearVelocity().add(impulse.product(invM1));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * (r1.cross(impulse) + impulse3.z));
            this.body2.getLinearVelocity().subtract(impulse.product(invM2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * (r2.cross(impulse) + impulse3.z));
        } else {
            Vector2 impulse = this.K.solve22(Jvb2.negate());
            this.impulse.x += impulse.x;
            this.impulse.y += impulse.y;
            this.body1.getLinearVelocity().add(impulse.product(invM1));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * r1.cross(impulse));
            this.body2.getLinearVelocity().subtract(impulse.product(invM2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * r2.cross(impulse));
        }
    }

    @Override
    public boolean solvePositionConstraints(Step step, Settings settings) {
        double linearTolerance = settings.getLinearTolerance();
        double angularTolerance = settings.getAngularTolerance();
        double maxAngularCorrection = settings.getMaximumAngularCorrection();
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        double linearError = 0.0;
        double angularError = 0.0;
        if (this.limitEnabled && this.limitState != LimitState.INACTIVE) {
            double j;
            double angle = this.getRelativeRotation();
            double impulse = 0.0;
            if (this.limitState == LimitState.EQUAL) {
                j = Interval.clamp(angle - this.lowerLimit, -maxAngularCorrection, maxAngularCorrection);
                impulse = -j * this.motorMass;
                angularError = Math.abs(j);
            } else if (this.limitState == LimitState.AT_LOWER) {
                j = angle - this.lowerLimit;
                angularError = -j;
                j = Interval.clamp(j + angularTolerance, -maxAngularCorrection, 0.0);
                impulse = -j * this.motorMass;
            } else if (this.limitState == LimitState.AT_UPPER) {
                angularError = j = angle - this.upperLimit;
                j = Interval.clamp(j - angularTolerance, 0.0, maxAngularCorrection);
                impulse = -j * this.motorMass;
            }
            this.body1.rotateAboutCenter(invI1 * impulse);
            this.body2.rotateAboutCenter(-invI2 * impulse);
        }
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 p1 = this.body1.getWorldCenter().add(r1);
        Vector2 p2 = this.body2.getWorldCenter().add(r2);
        Vector2 p = p1.difference(p2);
        linearError = p.getMagnitude();
        double large = 10.0 * linearTolerance;
        if (p.getMagnitudeSquared() > large * large) {
            double m = invM1 + invM2;
            if (m > Epsilon.E) {
                m = 1.0 / m;
            }
            Vector2 impulse = p.multiply(-m);
            double scale = 0.5;
            this.body1.translate(impulse.product(invM1 * 0.5));
            this.body2.translate(impulse.product(-invM2 * 0.5));
            p1 = this.body1.getWorldCenter().add(r1);
            p2 = this.body2.getWorldCenter().add(r2);
            p = p1.difference(p2);
        }
        Matrix22 K = new Matrix22();
        K.m00 = invM1 + invM2 + r1.y * r1.y * invI1 + r2.y * r2.y * invI2;
        K.m01 = -invI1 * r1.x * r1.y - invI2 * r2.x * r2.y;
        K.m10 = this.K.m01;
        K.m11 = invM1 + invM2 + r1.x * r1.x * invI1 + r2.x * r2.x * invI2;
        Vector2 J = K.solve(p.negate());
        this.body1.translate(J.product(invM1));
        this.body1.rotateAboutCenter(invI1 * r1.cross(J));
        this.body2.translate(J.product(-invM2));
        this.body2.rotateAboutCenter(-invI2 * r2.cross(J));
        return linearError <= linearTolerance && angularError <= angularTolerance;
    }

    private double getRelativeRotation() {
        double rr = this.body1.getTransform().getRotation() - this.body2.getTransform().getRotation() - this.referenceAngle;
        if (rr < -Math.PI) {
            rr += Math.PI * 2;
        }
        if (rr > Math.PI) {
            rr -= Math.PI * 2;
        }
        return rr;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double invdt) {
        return new Vector2(this.impulse.x * invdt, this.impulse.y * invdt);
    }

    @Override
    public double getReactionTorque(double invdt) {
        return this.impulse.z * invdt;
    }

    @Override
    public void shift(Vector2 shift) {
    }

    public double getJointSpeed() {
        return this.body2.getAngularVelocity() - this.body1.getAngularVelocity();
    }

    public double getJointAngle() {
        return this.getRelativeRotation();
    }

    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    public void setMotorEnabled(boolean flag) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.motorEnabled = flag;
    }

    public double getMaximumMotorTorque() {
        return this.maximumMotorTorque;
    }

    public void setMaximumMotorTorque(double maximumMotorTorque) {
        if (maximumMotorTorque < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidMaximumMotorTorque"));
        }
        this.maximumMotorTorque = maximumMotorTorque;
    }

    public double getMotorSpeed() {
        return this.motorSpeed;
    }

    public void setMotorSpeed(double motorSpeed) {
        if (this.motorEnabled) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.motorSpeed = motorSpeed;
    }

    public double getMotorTorque() {
        return this.motorImpulse;
    }

    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    public void setLimitEnabled(boolean flag) {
        if (this.limitEnabled != flag) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.limitEnabled = flag;
            this.impulse.z = 0.0;
        }
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double upperLimit) {
        if (upperLimit < this.lowerLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidUpperLimit"));
        }
        if (this.limitEnabled && upperLimit != this.upperLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.upperLimit = upperLimit;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double lowerLimit) {
        if (lowerLimit > this.upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLowerLimit"));
        }
        if (this.limitEnabled && lowerLimit != this.lowerLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.lowerLimit = lowerLimit;
    }

    public void setLimits(double lowerLimit, double upperLimit) {
        if (lowerLimit > upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLimits"));
        }
        if (this.limitEnabled && (lowerLimit != this.lowerLimit || upperLimit != this.upperLimit)) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public double getReferenceAngle() {
        return this.referenceAngle;
    }

    public void setReferenceAngle(double angle) {
        this.referenceAngle = angle;
    }

    public LimitState getLimitState() {
        return this.limitState;
    }
}

