/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.dynamics.joint.LimitState;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class RopeJoint
extends Joint
implements Shiftable,
DataContainer {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected double upperLimit;
    protected double lowerLimit;
    protected boolean upperLimitEnabled;
    protected boolean lowerLimitEnabled;
    private double invK;
    private Vector2 n;
    private LimitState limitState;
    private double impulse;

    public RopeJoint(Body body1, Body body2, Vector2 anchor1, Vector2 anchor2) {
        super(body1, body2, false);
        double distance;
        if (body1 == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (anchor1 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor1"));
        }
        if (anchor2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor2"));
        }
        this.localAnchor1 = body1.getLocalPoint(anchor1);
        this.localAnchor2 = body2.getLocalPoint(anchor2);
        this.upperLimitEnabled = true;
        this.lowerLimitEnabled = true;
        this.upperLimit = distance = anchor1.distance(anchor2);
        this.lowerLimit = distance;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RopeJoint[").append(super.toString()).append("|Anchor1=").append(this.getAnchor1()).append("|Anchor2=").append(this.getAnchor2()).append("|IsLowerLimitEnabled=").append(this.lowerLimitEnabled).append("|LowerLimit").append(this.lowerLimit).append("|IsUpperLimitEnabled=").append(this.upperLimitEnabled).append("|UpperLimit=").append(this.upperLimit).append("]");
        return sb.toString();
    }

    @Override
    public void initializeConstraints(Step step, Settings settings) {
        double linearTolerance = settings.getLinearTolerance();
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.n = r1.sum(this.body1.getWorldCenter()).subtract(r2.sum(this.body2.getWorldCenter()));
        double length = this.n.getMagnitude();
        if (length < linearTolerance) {
            this.n.zero();
        } else {
            this.n.multiply(1.0 / length);
        }
        if (this.upperLimitEnabled && this.lowerLimitEnabled) {
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * linearTolerance) {
                this.limitState = LimitState.EQUAL;
            } else if (this.upperLimit > this.lowerLimit) {
                this.limitState = length > this.upperLimit ? LimitState.AT_UPPER : (length < this.lowerLimit ? LimitState.AT_LOWER : LimitState.INACTIVE);
            }
        } else {
            this.limitState = this.upperLimitEnabled ? (length > this.upperLimit ? LimitState.AT_UPPER : LimitState.INACTIVE) : (this.lowerLimitEnabled ? (length < this.lowerLimit ? LimitState.AT_LOWER : LimitState.INACTIVE) : LimitState.INACTIVE);
        }
        if (this.limitState != LimitState.INACTIVE) {
            double cr1n = r1.cross(this.n);
            double cr2n = r2.cross(this.n);
            double invMass = invM1 + invI1 * cr1n * cr1n;
            this.invK = (invMass += invM2 + invI2 * cr2n * cr2n) <= Epsilon.E ? 0.0 : 1.0 / invMass;
            this.impulse *= step.getDeltaTimeRatio();
            Vector2 J = this.n.product(this.impulse);
            this.body1.getLinearVelocity().add(J.product(invM1));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * r1.cross(J));
            this.body2.getLinearVelocity().subtract(J.product(invM2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * r2.cross(J));
        } else {
            this.impulse = 0.0;
        }
    }

    @Override
    public void solveVelocityConstraints(Step step, Settings settings) {
        if (this.limitState != LimitState.INACTIVE) {
            Transform t1 = this.body1.getTransform();
            Transform t2 = this.body2.getTransform();
            Mass m1 = this.body1.getMass();
            Mass m2 = this.body2.getMass();
            double invM1 = m1.getInverseMass();
            double invM2 = m2.getInverseMass();
            double invI1 = m1.getInverseInertia();
            double invI2 = m2.getInverseInertia();
            Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
            Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
            Vector2 v1 = this.body1.getLinearVelocity().sum(r1.cross(this.body1.getAngularVelocity()));
            Vector2 v2 = this.body2.getLinearVelocity().sum(r2.cross(this.body2.getAngularVelocity()));
            double Jv = this.n.dot(v1.difference(v2));
            double j = -this.invK * Jv;
            this.impulse += j;
            Vector2 J = this.n.product(j);
            this.body1.getLinearVelocity().add(J.product(invM1));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * r1.cross(J));
            this.body2.getLinearVelocity().subtract(J.product(invM2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * r2.cross(J));
        }
    }

    @Override
    public boolean solvePositionConstraints(Step step, Settings settings) {
        if (this.limitState != LimitState.INACTIVE) {
            double targetDistance = this.upperLimit;
            if (this.limitState == LimitState.AT_LOWER) {
                targetDistance = this.lowerLimit;
            }
            double linearTolerance = settings.getLinearTolerance();
            double maxLinearCorrection = settings.getMaximumLinearCorrection();
            Transform t1 = this.body1.getTransform();
            Transform t2 = this.body2.getTransform();
            Mass m1 = this.body1.getMass();
            Mass m2 = this.body2.getMass();
            double invM1 = m1.getInverseMass();
            double invM2 = m2.getInverseMass();
            double invI1 = m1.getInverseInertia();
            double invI2 = m2.getInverseInertia();
            Vector2 c1 = this.body1.getWorldCenter();
            Vector2 c2 = this.body2.getWorldCenter();
            Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
            Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
            this.n = r1.sum(this.body1.getWorldCenter()).subtract(r2.sum(this.body2.getWorldCenter()));
            double l = this.n.normalize();
            double C = l - targetDistance;
            C = Interval.clamp(C, -maxLinearCorrection, maxLinearCorrection);
            double impulse = -this.invK * C;
            Vector2 J = this.n.product(impulse);
            this.body1.translate(J.product(invM1));
            this.body1.rotate(invI1 * r1.cross(J), c1);
            this.body2.translate(J.product(-invM2));
            this.body2.rotate(-invI2 * r2.cross(J), c2);
            return Math.abs(C) < linearTolerance;
        }
        return true;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double invdt) {
        return this.n.product(this.impulse * invdt);
    }

    @Override
    public double getReactionTorque(double invdt) {
        return 0.0;
    }

    @Override
    public void shift(Vector2 shift) {
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double upperLimit) {
        if (upperLimit < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.rope.lessThanZeroUpperLimit"));
        }
        if (upperLimit < this.lowerLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidUpperLimit"));
        }
        if (this.upperLimitEnabled && upperLimit != this.upperLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.upperLimit = upperLimit;
    }

    public void setUpperLimitEnabled(boolean flag) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.upperLimitEnabled = flag;
    }

    public boolean isUpperLimitEnabled() {
        return this.upperLimitEnabled;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double lowerLimit) {
        if (lowerLimit < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.rope.lessThanZeroLowerLimit"));
        }
        if (lowerLimit > this.upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLowerLimit"));
        }
        if (this.lowerLimitEnabled && lowerLimit != this.lowerLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.lowerLimit = lowerLimit;
    }

    public void setLowerLimitEnabled(boolean flag) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.lowerLimitEnabled = flag;
    }

    public boolean isLowerLimitEnabled() {
        return this.lowerLimitEnabled;
    }

    public void setLimits(double lowerLimit, double upperLimit) {
        if (lowerLimit < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.rope.lessThanZeroLowerLimit"));
        }
        if (upperLimit < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.rope.lessThanZeroUpperLimit"));
        }
        if (lowerLimit > upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLimits"));
        }
        if (this.lowerLimitEnabled && lowerLimit != this.lowerLimit || this.upperLimitEnabled && upperLimit != this.upperLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.upperLimit = upperLimit;
        this.lowerLimit = lowerLimit;
    }

    public void setLimitsEnabled(double lowerLimit, double upperLimit) {
        this.upperLimitEnabled = true;
        this.lowerLimitEnabled = true;
        this.setLimits(lowerLimit, upperLimit);
    }

    public void setLimitsEnabled(boolean flag) {
        this.upperLimitEnabled = flag;
        this.lowerLimitEnabled = flag;
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
    }

    public void setLimits(double limit) {
        if (limit < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.rope.invalidLimit"));
        }
        if (this.lowerLimitEnabled && limit != this.lowerLimit || this.upperLimitEnabled && limit != this.upperLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.upperLimit = limit;
        this.lowerLimit = limit;
    }

    public void setLimitsEnabled(double limit) {
        this.upperLimitEnabled = true;
        this.lowerLimitEnabled = true;
        this.setLimits(limit);
    }

    public LimitState getLimitState() {
        return this.limitState;
    }
}

