/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import java.util.UUID;
import org.dyn4j.DataContainer;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;

public abstract class AbstractShape
implements Shape,
Transformable,
DataContainer {
    protected final UUID id = UUID.randomUUID();
    final Vector2 center;
    final double radius;
    protected Object userData;

    protected AbstractShape(double radius) {
        this(new Vector2(), radius);
    }

    protected AbstractShape(Vector2 center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Id=").append(this.id).append("|Center=").append(this.center).append("|Radius=").append(this.radius);
        return sb.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Vector2 getCenter() {
        return this.center;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object userData) {
        this.userData = userData;
    }

    @Override
    public void rotate(double theta) {
        this.rotate(theta, 0.0, 0.0);
    }

    @Override
    public void rotateAboutCenter(double theta) {
        this.rotate(theta, this.center.x, this.center.y);
    }

    @Override
    public void rotate(double theta, Vector2 point) {
        this.rotate(theta, point.x, point.y);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        if (!this.center.equals(x, y)) {
            this.center.rotate(theta, x, y);
        }
    }

    @Override
    public void translate(double x, double y) {
        this.center.add(x, y);
    }

    @Override
    public void translate(Vector2 vector) {
        this.translate(vector.x, vector.y);
    }

    @Override
    public Interval project(Vector2 n) {
        return this.project(n, Transform.IDENTITY);
    }

    @Override
    public boolean contains(Vector2 point) {
        return this.contains(point, Transform.IDENTITY);
    }

    @Override
    public AABB createAABB() {
        return this.createAABB(Transform.IDENTITY);
    }
}

