/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Feature;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.PointFeature;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Capsule
extends AbstractShape
implements Convex,
Shape,
Transformable,
DataContainer {
    protected static final double EDGE_FEATURE_SELECTION_CRITERIA = 0.98;
    protected static final double EDGE_FEATURE_EXPANSION_FACTOR = 0.1;
    final double length;
    final double capRadius;
    final Vector2[] foci;
    final Vector2 localXAxis;

    private Capsule(boolean valid, double width, double height) {
        super(Math.max(width, height) * 0.5);
        double major = width;
        double minor = height;
        boolean vertical = false;
        if (width < height) {
            major = height;
            minor = width;
            vertical = true;
        }
        this.length = major;
        this.capRadius = minor * 0.5;
        double f = (major - minor) * 0.5;
        this.foci = new Vector2[2];
        if (vertical) {
            this.foci[0] = new Vector2(0.0, -f);
            this.foci[1] = new Vector2(0.0, f);
            this.localXAxis = new Vector2(0.0, 1.0);
        } else {
            this.foci[0] = new Vector2(-f, 0.0);
            this.foci[1] = new Vector2(f, 0.0);
            this.localXAxis = new Vector2(1.0, 0.0);
        }
    }

    public Capsule(double width, double height) {
        this(Capsule.validate(width, height), width, height);
    }

    private static final boolean validate(double width, double height) {
        if (width <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsule.invalidWidth"));
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsule.invalidHeight"));
        }
        if (Math.abs(width - height) < Epsilon.E) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsule.degenerate"));
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Capsule[").append(super.toString()).append("|Width=").append(this.length).append("|CapRadius=").append(this.capRadius).append("]");
        return sb.toString();
    }

    @Override
    public Vector2[] getAxes(Vector2[] foci, Transform transform) {
        if (foci != null) {
            Vector2[] axes = new Vector2[2 + foci.length];
            axes[0] = transform.getTransformedR(this.localXAxis);
            axes[1] = transform.getTransformedR(this.localXAxis.getRightHandOrthogonalVector());
            Vector2 f1 = transform.getTransformed(this.foci[0]);
            Vector2 f2 = transform.getTransformed(this.foci[1]);
            int i = 0;
            while (i < foci.length) {
                double d1 = f1.distanceSquared(foci[i]);
                double d2 = f2.distanceSquared(foci[i]);
                Vector2 v = null;
                v = d1 < d2 ? f1.to(foci[i]) : f2.to(foci[i]);
                v.normalize();
                axes[2 + i] = v;
                ++i;
            }
            return axes;
        }
        return new Vector2[]{transform.getTransformedR(this.localXAxis), transform.getTransformedR(this.localXAxis.getRightHandOrthogonalVector())};
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        return new Vector2[]{transform.getTransformed(this.foci[0]), transform.getTransformed(this.foci[1])};
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector, Transform transform) {
        vector.normalize();
        Vector2 p = Segment.getFarthestPoint(this.foci[0], this.foci[1], vector, transform);
        return p.add(vector.product(this.capRadius));
    }

    @Override
    public Feature getFarthestFeature(Vector2 vector, Transform transform) {
        Vector2 localAxis = transform.getInverseTransformedR(vector);
        Vector2 n1 = this.localXAxis.getLeftHandOrthogonalVector();
        double d = localAxis.dot(localAxis) * 0.98;
        double d1 = localAxis.dot(n1);
        if (Math.abs(d1) < d) {
            Vector2 point = this.getFarthestPoint(vector, transform);
            return new PointFeature(point);
        }
        Vector2 v = n1.multiply(this.capRadius);
        Vector2 e = this.localXAxis.product(this.length * 0.5 * 0.1);
        if (d1 > 0.0) {
            Vector2 p1 = this.foci[0].sum(v).subtract(e);
            Vector2 p2 = this.foci[1].sum(v).add(e);
            return Segment.getFarthestFeature(p1, p2, vector, transform);
        }
        Vector2 p1 = this.foci[0].difference(v).subtract(e);
        Vector2 p2 = this.foci[1].difference(v).add(e);
        return Segment.getFarthestFeature(p1, p2, vector, transform);
    }

    @Override
    public Interval project(Vector2 vector, Transform transform) {
        Vector2 p1 = this.getFarthestPoint(vector, transform);
        Vector2 center = transform.getTransformed(this.center);
        double c = center.dot(vector);
        double d = p1.dot(vector);
        return new Interval(2.0 * c - d, d);
    }

    @Override
    public AABB createAABB(Transform transform) {
        Interval x = this.project(Vector2.X_AXIS, transform);
        Interval y = this.project(Vector2.Y_AXIS, transform);
        return new AABB(x.getMin(), y.getMin(), x.getMax(), y.getMax());
    }

    @Override
    public Mass createMass(double density) {
        double h = this.capRadius * 2.0;
        double w = this.length - h;
        double r2 = this.capRadius * this.capRadius;
        double ra = w * h;
        double ca = r2 * Math.PI;
        double rm = density * ra;
        double cm = density * ca;
        double m = rm + cm;
        double d = w * 0.5;
        double cI = 0.5 * cm * r2 + cm * d * d;
        double rI = rm * (h * h + w * w) / 12.0;
        double I = rI + cI;
        return new Mass(this.center, m, I);
    }

    @Override
    public double getRadius(Vector2 center) {
        return this.radius + this.center.distance(center);
    }

    @Override
    public boolean contains(Vector2 point, Transform transform) {
        Vector2 p = Segment.getPointOnSegmentClosestToPoint(point, transform.getTransformed(this.foci[0]), transform.getTransformed(this.foci[1]));
        double r2 = this.capRadius * this.capRadius;
        double d2 = p.distanceSquared(point);
        return d2 <= r2;
    }

    @Override
    public void rotate(double theta, double x, double y) {
        super.rotate(theta, x, y);
        this.foci[0].rotate(theta, x, y);
        this.foci[1].rotate(theta, x, y);
        this.localXAxis.rotate(theta);
    }

    @Override
    public void translate(double x, double y) {
        super.translate(x, y);
        this.foci[0].add(x, y);
        this.foci[1].add(x, y);
    }

    public double getRotation() {
        return Vector2.X_AXIS.getAngleBetween(this.localXAxis);
    }

    public double getLength() {
        return this.length;
    }

    public double getCapRadius() {
        return this.capRadius;
    }
}

