/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.decompose.Decomposer;
import org.dyn4j.resources.Messages;

public class Bayazit
implements Decomposer {
    @Override
    public List<Convex> decompose(Vector2 ... points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.decompose.nullArray"));
        }
        int size = points.length;
        if (size < 4) {
            throw new IllegalArgumentException(Messages.getString("geometry.decompose.invalidSize"));
        }
        double winding = Geometry.getWinding(points);
        if (winding < 0.0) {
            Geometry.reverseWinding(points);
        }
        ArrayList<Vector2> polygon = new ArrayList<Vector2>();
        Collections.addAll(polygon, points);
        ArrayList<Convex> polygons = new ArrayList<Convex>();
        this.decomposePolygon(polygon, polygons);
        return polygons;
    }

    protected void decomposePolygon(List<Vector2> polygon, List<Convex> polygons) {
        int size = polygon.size();
        Vector2 upperIntersection = new Vector2();
        Vector2 lowerIntersection = new Vector2();
        double upperDistance = Double.MAX_VALUE;
        double lowerDistance = Double.MAX_VALUE;
        double closestDistance = Double.MAX_VALUE;
        int upperIndex = 0;
        int lowerIndex = 0;
        int closestIndex = 0;
        ArrayList<Vector2> lower = new ArrayList<Vector2>();
        ArrayList<Vector2> upper = new ArrayList<Vector2>();
        int i = 0;
        while (i < size) {
            Vector2 p1;
            Vector2 p = polygon.get(i);
            Vector2 p0 = polygon.get(i - 1 < 0 ? size - 1 : i - 1);
            if (this.isReflex(p0, p, p1 = polygon.get(i + 1 == size ? 0 : i + 1))) {
                int j = 0;
                while (j < size) {
                    double dist;
                    Vector2 q = polygon.get(j);
                    Vector2 q0 = polygon.get(j - 1 < 0 ? size - 1 : j - 1);
                    Vector2 q1 = polygon.get(j + 1 == size ? 0 : j + 1);
                    Vector2 s = new Vector2();
                    if (this.left(p0, p, q) && this.rightOn(p0, p, q0) && this.getIntersection(p0, p, q, q0, s) && this.right(p1, p, s) && (dist = p.distanceSquared(s)) < lowerDistance) {
                        lowerDistance = dist;
                        lowerIntersection.set(s);
                        lowerIndex = j;
                    }
                    if (this.left(p1, p, q1) && this.rightOn(p1, p, q) && this.getIntersection(p1, p, q, q1, s) && this.left(p0, p, s) && (dist = p.distanceSquared(s)) < upperDistance) {
                        upperDistance = dist;
                        upperIntersection.set(s);
                        upperIndex = j;
                    }
                    ++j;
                }
                if (lowerIndex == (upperIndex + 1) % size) {
                    Vector2 s = upperIntersection.sum(lowerIntersection).multiply(0.5);
                    if (i < upperIndex) {
                        lower.addAll(polygon.subList(i, upperIndex + 1));
                        lower.add(s);
                        upper.add(s);
                        if (lowerIndex != 0) {
                            upper.addAll(polygon.subList(lowerIndex, size));
                        }
                        upper.addAll(polygon.subList(0, i + 1));
                    } else {
                        if (i != 0) {
                            lower.addAll(polygon.subList(i, size));
                        }
                        lower.addAll(polygon.subList(0, upperIndex + 1));
                        lower.add(s);
                        upper.add(s);
                        upper.addAll(polygon.subList(lowerIndex, i + 1));
                    }
                } else {
                    if (lowerIndex > upperIndex) {
                        upperIndex += size;
                    }
                    closestIndex = lowerIndex;
                    j = lowerIndex;
                    while (j <= upperIndex) {
                        double dist;
                        int jmod = j % size;
                        Vector2 q = polygon.get(jmod);
                        if (q != p && q != p0 && q != p1 && (dist = p.distanceSquared(q)) < closestDistance && this.isVisible(polygon, i, jmod)) {
                            closestDistance = dist;
                            closestIndex = jmod;
                        }
                        ++j;
                    }
                    if (i < closestIndex) {
                        lower.addAll(polygon.subList(i, closestIndex + 1));
                        if (closestIndex != 0) {
                            upper.addAll(polygon.subList(closestIndex, size));
                        }
                        upper.addAll(polygon.subList(0, i + 1));
                    } else {
                        if (i != 0) {
                            lower.addAll(polygon.subList(i, size));
                        }
                        lower.addAll(polygon.subList(0, closestIndex + 1));
                        upper.addAll(polygon.subList(closestIndex, i + 1));
                    }
                }
                if (lower.size() < upper.size()) {
                    this.decomposePolygon(lower, polygons);
                    this.decomposePolygon(upper, polygons);
                } else {
                    this.decomposePolygon(upper, polygons);
                    this.decomposePolygon(lower, polygons);
                }
                return;
            }
            ++i;
        }
        if (polygon.size() < 3) {
            throw new IllegalArgumentException(Messages.getString("geometry.decompose.crossingEdges"));
        }
        Vector2[] vertices = new Vector2[polygon.size()];
        polygon.toArray(vertices);
        polygons.add(Geometry.createPolygon(vertices));
    }

    protected boolean isReflex(Vector2 p0, Vector2 p, Vector2 p1) {
        return this.right(p1, p0, p);
    }

    protected boolean left(Vector2 a, Vector2 b, Vector2 p) {
        return Segment.getLocation(p, a, b) > 0.0;
    }

    protected boolean leftOn(Vector2 a, Vector2 b, Vector2 p) {
        return Segment.getLocation(p, a, b) >= 0.0;
    }

    protected boolean right(Vector2 a, Vector2 b, Vector2 p) {
        return Segment.getLocation(p, a, b) < 0.0;
    }

    protected boolean rightOn(Vector2 a, Vector2 b, Vector2 p) {
        return Segment.getLocation(p, a, b) <= 0.0;
    }

    protected boolean getIntersection(Vector2 a1, Vector2 a2, Vector2 b1, Vector2 b2, Vector2 p) {
        Vector2 s2;
        Vector2 s1 = a1.difference(a2);
        double det = s1.cross(s2 = b1.difference(b2));
        if (Math.abs(det) <= Epsilon.E) {
            return false;
        }
        det = 1.0 / det;
        double t2 = det * (a1.cross(s1) - b1.cross(s1));
        p.x = b1.x * (1.0 - t2) + b2.x * t2;
        p.y = b1.y * (1.0 - t2) + b2.y * t2;
        return true;
    }

    private boolean isVisible(List<Vector2> polygon, int i, int j) {
        int s = polygon.size();
        Vector2 iv0 = polygon.get(i == 0 ? s - 1 : i - 1);
        Vector2 iv = polygon.get(i);
        Vector2 iv1 = polygon.get(i + 1 == s ? 0 : i + 1);
        Vector2 jv0 = polygon.get(j == 0 ? s - 1 : j - 1);
        Vector2 jv = polygon.get(j);
        Vector2 jv1 = polygon.get(j + 1 == s ? 0 : j + 1);
        if (this.isReflex(iv0, iv, iv1) ? this.leftOn(iv, iv0, jv) && this.rightOn(iv, iv1, jv) : this.rightOn(iv, iv1, jv) || this.leftOn(iv, iv0, jv)) {
            return false;
        }
        if (this.isReflex(jv0, jv, jv1) ? this.leftOn(jv, jv0, iv) && this.rightOn(jv, jv1, iv) : this.rightOn(jv, jv1, iv) || this.leftOn(jv, jv0, iv)) {
            return false;
        }
        int k = 0;
        while (k < s) {
            Vector2 k2;
            Vector2 k1;
            Vector2 in;
            int ki1;
            int n = ki1 = k + 1 == s ? 0 : k + 1;
            if (k != i && k != j && ki1 != i && ki1 != j && (in = Segment.getSegmentIntersection(iv, jv, k1 = polygon.get(k), k2 = polygon.get(ki1))) != null) {
                return false;
            }
            ++k;
        }
        return true;
    }
}

