/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import java.util.ArrayList;
import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Polygon;
import org.dyn4j.geometry.Triangle;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.decompose.DoubleEdgeListFace;
import org.dyn4j.geometry.decompose.DoubleEdgeListHalfEdge;
import org.dyn4j.geometry.decompose.DoubleEdgeListVertex;
import org.dyn4j.geometry.decompose.MonotoneChainType;
import org.dyn4j.geometry.decompose.MonotonePolygon;
import org.dyn4j.geometry.decompose.MonotonePolygonType;
import org.dyn4j.geometry.decompose.MonotoneVertex;
import org.dyn4j.resources.Messages;

final class DoubleEdgeList {
    final List<DoubleEdgeListVertex> vertices = new ArrayList<DoubleEdgeListVertex>();
    final List<DoubleEdgeListHalfEdge> edges = new ArrayList<DoubleEdgeListHalfEdge>();
    final List<DoubleEdgeListFace> faces = new ArrayList<DoubleEdgeListFace>();

    public DoubleEdgeList(Vector2[] points) {
        this.initialize(points);
    }

    public void initialize(Vector2[] points) {
        DoubleEdgeListHalfEdge firstLeftEdge;
        int size = points.length;
        DoubleEdgeListFace face = new DoubleEdgeListFace();
        this.faces.add(face);
        DoubleEdgeListHalfEdge prevLeftEdge = null;
        DoubleEdgeListHalfEdge prevRightEdge = null;
        int i = 0;
        while (i < size) {
            Vector2 point = points[i];
            DoubleEdgeListVertex vertex = new DoubleEdgeListVertex(point);
            DoubleEdgeListHalfEdge left = new DoubleEdgeListHalfEdge();
            DoubleEdgeListHalfEdge right = new DoubleEdgeListHalfEdge();
            left.face = face;
            left.next = null;
            left.origin = vertex;
            left.twin = right;
            right.face = null;
            right.next = prevRightEdge;
            right.origin = null;
            right.twin = left;
            this.edges.add(left);
            this.edges.add(right);
            vertex.leaving = left;
            this.vertices.add(vertex);
            if (prevLeftEdge != null) {
                prevLeftEdge.next = left;
            }
            if (prevRightEdge != null) {
                prevRightEdge.origin = vertex;
            }
            prevLeftEdge = left;
            prevRightEdge = right;
            ++i;
        }
        prevLeftEdge.next = firstLeftEdge = this.edges.get(0);
        DoubleEdgeListHalfEdge firstRightEdge = this.edges.get(1);
        firstRightEdge.next = prevRightEdge;
        prevRightEdge.origin = this.vertices.get(0);
        face.edge = firstLeftEdge;
    }

    public void addHalfEdges(int i, int j) {
        DoubleEdgeListVertex vertex1 = this.vertices.get(i);
        DoubleEdgeListVertex vertex2 = this.vertices.get(j);
        this.addHalfEdges(vertex1, vertex2);
    }

    final void addHalfEdges(DoubleEdgeListVertex v1, DoubleEdgeListVertex v2) {
        DoubleEdgeListFace face = new DoubleEdgeListFace();
        DoubleEdgeListHalfEdge left = new DoubleEdgeListHalfEdge();
        DoubleEdgeListHalfEdge right = new DoubleEdgeListHalfEdge();
        DoubleEdgeListFace referenceDoubleEdgeListFace = this.getReferenceFace(v1, v2);
        DoubleEdgeListHalfEdge prev1 = this.getPreviousEdge(v1, referenceDoubleEdgeListFace);
        DoubleEdgeListHalfEdge prev2 = this.getPreviousEdge(v2, referenceDoubleEdgeListFace);
        face.edge = left;
        referenceDoubleEdgeListFace.edge = right;
        left.face = face;
        left.next = prev2.next;
        left.origin = v1;
        left.twin = right;
        right.face = referenceDoubleEdgeListFace;
        right.next = prev1.next;
        right.origin = v2;
        right.twin = left;
        prev1.next = left;
        prev2.next = right;
        DoubleEdgeListHalfEdge curr = left.next;
        while (curr != left) {
            curr.face = face;
            curr = curr.next;
        }
        this.edges.add(left);
        this.edges.add(right);
        this.faces.add(face);
    }

    final DoubleEdgeListHalfEdge getPreviousEdge(DoubleEdgeListVertex vertex, DoubleEdgeListFace face) {
        DoubleEdgeListHalfEdge twin = vertex.leaving.twin;
        DoubleEdgeListHalfEdge edge = vertex.leaving.twin.next.twin;
        while (edge != twin) {
            if (edge.face == face) {
                return edge;
            }
            edge = edge.next.twin;
        }
        return edge;
    }

    final DoubleEdgeListFace getReferenceFace(DoubleEdgeListVertex v1, DoubleEdgeListVertex v2) {
        if (v1.leaving.face == v2.leaving.face) {
            return v1.leaving.face;
        }
        DoubleEdgeListHalfEdge e1 = v1.leaving.twin.next.twin;
        while (e1 != v1.leaving.twin) {
            DoubleEdgeListHalfEdge e2 = v2.leaving.twin.next.twin;
            while (e2 != v2.leaving.twin) {
                if (e1.face == e2.face) {
                    return e1.face;
                }
                e2 = e2.next.twin;
            }
            e1 = e1.next.twin;
        }
        return v1.leaving.face;
    }

    public void removeHalfEdges(int index) {
        DoubleEdgeListHalfEdge e = this.edges.get(index);
        this.removeHalfEdges(index, e);
    }

    final void removeHalfEdges(DoubleEdgeListHalfEdge edge) {
        int index = this.edges.indexOf(edge);
        this.removeHalfEdges(index, edge);
    }

    final void removeHalfEdges(int index, DoubleEdgeListHalfEdge edge) {
        DoubleEdgeListHalfEdge tNext;
        DoubleEdgeListFace face = edge.twin.face;
        DoubleEdgeListHalfEdge ePrev = edge.getPrevious();
        DoubleEdgeListHalfEdge tPrev = edge.twin.getPrevious();
        DoubleEdgeListHalfEdge eNext = edge.next;
        ePrev.next = tNext = edge.twin.next;
        tPrev.next = eNext;
        face.edge = eNext;
        DoubleEdgeListHalfEdge te = eNext;
        while (te != tNext) {
            te.face = face;
            te = te.next;
        }
        this.faces.remove(edge.face);
        this.edges.remove(index);
        this.edges.remove(index);
    }

    public List<Convex> getConvexDecomposition() {
        ArrayList<Convex> convexes = new ArrayList<Convex>();
        int fSize = this.faces.size();
        int i = 0;
        while (i < fSize) {
            DoubleEdgeListFace face = this.faces.get(i);
            int size = face.getEdgeCount();
            DoubleEdgeListHalfEdge left = face.edge;
            Vector2[] vertices = new Vector2[size];
            vertices[0] = left.origin.point;
            left = left.next;
            int j = 1;
            while (left != face.edge) {
                vertices[j++] = left.origin.point;
                left = left.next;
            }
            if (vertices.length < 3) {
                throw new IllegalArgumentException(Messages.getString("geometry.decompose.crossingEdges"));
            }
            Polygon p = Geometry.createPolygon(vertices);
            convexes.add(p);
            ++i;
        }
        return convexes;
    }

    public List<Triangle> getTriangulation() {
        ArrayList<Triangle> triangles = new ArrayList<Triangle>();
        int fSize = this.faces.size();
        int i = 0;
        while (i < fSize) {
            DoubleEdgeListFace face = this.faces.get(i);
            int size = face.getEdgeCount();
            DoubleEdgeListHalfEdge left = face.edge;
            Vector2[] vertices = new Vector2[size];
            vertices[0] = left.origin.point;
            left = left.next;
            int j = 1;
            while (left != face.edge) {
                vertices[j++] = left.origin.point;
                left = left.next;
            }
            if (vertices.length != 3) {
                throw new IllegalArgumentException(Messages.getString("geometry.decompose.crossingEdges"));
            }
            Triangle t = Geometry.createTriangle(vertices[0], vertices[1], vertices[2]);
            triangles.add(t);
            ++i;
        }
        return triangles;
    }

    public void triangulateYMonotonePolygons() {
        List<MonotonePolygon<DoubleEdgeListVertex>> monotonePolygons = this.getYMonotonePolygons();
        int size = monotonePolygons.size();
        int i = 0;
        while (i < size) {
            this.triangulateYMonotonePolygon(monotonePolygons.get(i));
            ++i;
        }
    }

    final void triangulateYMonotonePolygon(MonotonePolygon<DoubleEdgeListVertex> monotonePolygon) {
        ArrayList stack = new ArrayList();
        List vertices = monotonePolygon.vertices;
        stack.add(vertices.get(0));
        stack.add(vertices.get(1));
        int i = 2;
        while (!stack.isEmpty()) {
            MonotoneVertex vt;
            MonotoneVertex v = vertices.get(i);
            MonotoneVertex vBot = (MonotoneVertex)stack.get(0);
            MonotoneVertex vTop = (MonotoneVertex)stack.get(stack.size() - 1);
            if (v.isAdjacent(vBot) && !v.isAdjacent(vTop)) {
                while (stack.size() > 1) {
                    vt = (MonotoneVertex)stack.remove(stack.size() - 1);
                    this.addHalfEdges((DoubleEdgeListVertex)v.data, (DoubleEdgeListVertex)vt.data);
                }
                stack.clear();
                stack.add(vTop);
                stack.add(v);
            } else if (v.isAdjacent(vTop) && !v.isAdjacent(vBot)) {
                double cross = 0.0;
                int sSize = stack.size();
                while (sSize > 1) {
                    Vector2 v2;
                    Vector2 v1;
                    MonotoneVertex vt2 = (MonotoneVertex)stack.get(sSize - 1);
                    MonotoneVertex vt1 = (MonotoneVertex)stack.get(sSize - 2);
                    Vector2 p1 = ((DoubleEdgeListVertex)v.data).point;
                    Vector2 p2 = ((DoubleEdgeListVertex)vt2.data).point;
                    Vector2 p3 = ((DoubleEdgeListVertex)vt1.data).point;
                    if (v.chainType == MonotoneChainType.LEFT || v.chainType == MonotoneChainType.BOTTOM) {
                        v1 = p2.to(p3);
                        v2 = p2.to(p1);
                        cross = v1.cross(v2);
                    } else {
                        v1 = p1.to(p2);
                        v2 = p3.to(p2);
                        cross = v1.cross(v2);
                    }
                    if (!(cross < Epsilon.E)) break;
                    this.addHalfEdges((DoubleEdgeListVertex)v.data, (DoubleEdgeListVertex)vt1.data);
                    stack.remove(sSize - 1);
                    --sSize;
                }
                stack.add(v);
            } else if (v.isAdjacent(vTop) && v.isAdjacent(vBot)) {
                stack.remove(stack.size() - 1);
                while (stack.size() > 1) {
                    vt = (MonotoneVertex)stack.remove(stack.size() - 1);
                    this.addHalfEdges((DoubleEdgeListVertex)v.data, (DoubleEdgeListVertex)vt.data);
                }
                break;
            }
            ++i;
        }
    }

    final List<MonotonePolygon<DoubleEdgeListVertex>> getYMonotonePolygons() {
        int fSize = this.faces.size();
        ArrayList<MonotonePolygon<DoubleEdgeListVertex>> yMonotonePolygons = new ArrayList<MonotonePolygon<DoubleEdgeListVertex>>(fSize);
        int i = 0;
        while (i < fSize) {
            DoubleEdgeListFace face = this.faces.get(i);
            int size = face.getEdgeCount();
            DoubleEdgeListHalfEdge left = face.edge;
            MonotoneVertex<DoubleEdgeListVertex> root = new MonotoneVertex<DoubleEdgeListVertex>(left.origin);
            left = left.next;
            MonotoneVertex<DoubleEdgeListVertex> prev = root;
            MonotoneVertex<DoubleEdgeListVertex> curr = null;
            MonotoneVertex<DoubleEdgeListVertex> max = root;
            while (left != face.edge) {
                curr = new MonotoneVertex<DoubleEdgeListVertex>(left.origin);
                curr.previous = prev;
                prev.next = curr;
                Vector2 p = ((DoubleEdgeListVertex)curr.data).point;
                Vector2 q = ((DoubleEdgeListVertex)max.data).point;
                double diff = p.y - q.y;
                if (diff == 0.0) {
                    diff = p.x - q.x;
                    if (diff < 0.0) {
                        max = curr;
                    }
                } else if (diff > 0.0) {
                    max = curr;
                }
                left = left.next;
                prev = curr;
            }
            root.previous = curr;
            curr.next = root;
            ArrayList sorted = new ArrayList(size);
            sorted.add(max);
            max.chainType = MonotoneChainType.LEFT;
            MonotoneVertex currLeft = max.next;
            MonotoneVertex currRight = max.previous;
            int j = 1;
            while (j < size) {
                Vector2 l = ((DoubleEdgeListVertex)currLeft.data).point;
                Vector2 r = ((DoubleEdgeListVertex)currRight.data).point;
                if (l.y > r.y) {
                    sorted.add(currLeft);
                    currLeft.chainType = MonotoneChainType.LEFT;
                    currLeft = currLeft.next;
                } else {
                    sorted.add(currRight);
                    currRight.chainType = MonotoneChainType.RIGHT;
                    currRight = currRight.previous;
                }
                ++j;
            }
            ((MonotoneVertex)sorted.get((int)(size - 1))).chainType = MonotoneChainType.RIGHT;
            yMonotonePolygons.add(new MonotonePolygon(MonotonePolygonType.Y, sorted));
            ++i;
        }
        return yMonotonePolygons;
    }

    public void hertelMehlhorn() {
        int vSize = this.vertices.size();
        int i = vSize * 2;
        while (i < this.edges.size()) {
            DoubleEdgeListHalfEdge e = this.edges.get(i);
            DoubleEdgeListVertex v0 = e.getPrevious().origin;
            DoubleEdgeListVertex v1 = e.origin;
            DoubleEdgeListVertex v2 = e.twin.next.next.origin;
            if (this.isReflex(v0, v1, v2)) {
                i += 2;
                continue;
            }
            v0 = e.twin.getPrevious().origin;
            v1 = e.twin.origin;
            v2 = e.next.next.origin;
            if (this.isReflex(v0, v1, v2)) {
                i += 2;
                continue;
            }
            this.removeHalfEdges(i, e);
        }
    }

    boolean isReflex(DoubleEdgeListVertex v0, DoubleEdgeListVertex v1, DoubleEdgeListVertex v2) {
        Vector2 e2;
        Vector2 p0 = v0.point;
        Vector2 p1 = v1.point;
        Vector2 p2 = v2.point;
        Vector2 e1 = p0.to(p1);
        double cross = e1.cross(e2 = p1.to(p2));
        return cross < 0.0;
    }
}

