/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Triangle;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.decompose.Decomposer;
import org.dyn4j.geometry.decompose.DoubleEdgeList;
import org.dyn4j.geometry.decompose.EarClippingVertex;
import org.dyn4j.geometry.decompose.Triangulator;
import org.dyn4j.resources.Messages;

public class EarClipping
implements Decomposer,
Triangulator {
    private static final double CONTAINS_EPSILON = Math.sqrt(Epsilon.E);

    @Override
    public List<Convex> decompose(Vector2 ... points) {
        DoubleEdgeList dcel = this.createTriangulation(points);
        dcel.hertelMehlhorn();
        return dcel.getConvexDecomposition();
    }

    @Override
    public List<Triangle> triangulate(Vector2 ... points) {
        DoubleEdgeList dcel = this.createTriangulation(points);
        return dcel.getTriangulation();
    }

    final DoubleEdgeList createTriangulation(Vector2 ... points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.decompose.nullArray"));
        }
        int size = points.length;
        if (size < 4) {
            throw new IllegalArgumentException(Messages.getString("geometry.decompose.invalidSize"));
        }
        double winding = Geometry.getWinding(points);
        if (winding < 0.0) {
            Geometry.reverseWinding(points);
        }
        DoubleEdgeList dcel = new DoubleEdgeList(points);
        EarClippingVertex root = null;
        EarClippingVertex curr = null;
        EarClippingVertex prev = null;
        int i = 0;
        while (i < size) {
            Vector2 p = points[i];
            curr = new EarClippingVertex(p);
            Vector2 p0 = points[i == 0 ? size - 1 : i - 1];
            Vector2 p1 = points[i + 1 == size ? 0 : i + 1];
            Vector2 v1 = p.to(p0);
            Vector2 v2 = p.to(p1);
            if (v2.isZero()) {
                throw new IllegalArgumentException(Messages.getString("geometry.decompose.coincident"));
            }
            curr.reflex = v1.cross(v2) >= 0.0;
            curr.prev = prev;
            if (prev != null) {
                prev.next = curr;
            }
            curr.index = i;
            prev = curr;
            if (root == null) {
                root = curr;
            }
            ++i;
        }
        root.prev = prev;
        prev.next = root;
        EarClippingVertex node = root;
        int i2 = 0;
        while (i2 < size) {
            node.ear = this.isEar(node, size);
            node = node.next;
            ++i2;
        }
        node = root;
        int n = size;
        while (n > 3) {
            if (node.ear) {
                dcel.addHalfEdges(node.next.index, node.prev.index);
                EarClippingVertex pNode = node.prev;
                EarClippingVertex nNode = node.next;
                pNode.next = node.next;
                nNode.prev = node.prev;
                if (pNode.reflex) {
                    pNode.reflex = this.isReflex(pNode);
                }
                if (nNode.reflex) {
                    nNode.reflex = this.isReflex(nNode);
                }
                if (!pNode.reflex) {
                    pNode.ear = this.isEar(pNode, n);
                }
                if (!nNode.reflex) {
                    nNode.ear = this.isEar(nNode, n);
                }
                --n;
            }
            node = node.next;
        }
        return dcel;
    }

    final boolean isReflex(EarClippingVertex vertex) {
        Vector2 v2;
        Vector2 p = vertex.point;
        Vector2 p0 = vertex.prev.point;
        Vector2 p1 = vertex.next.point;
        Vector2 v1 = p.to(p0);
        return !(v1.cross(v2 = p.to(p1)) < 0.0);
    }

    final boolean isEar(EarClippingVertex vertex, int n) {
        if (vertex.reflex) {
            return false;
        }
        boolean ear = true;
        Vector2 a = vertex.point;
        Vector2 b = vertex.next.point;
        Vector2 c = vertex.prev.point;
        EarClippingVertex tNode = vertex.next.next;
        int j = 0;
        while (j < n - 3) {
            if (tNode.reflex && this.contains(a, b, c, tNode.point)) {
                ear = false;
                break;
            }
            tNode = tNode.next;
            ++j;
        }
        return ear;
    }

    protected boolean contains(Vector2 a, Vector2 b, Vector2 c, Vector2 p) {
        Vector2 ab = a.to(b);
        Vector2 ac = a.to(c);
        Vector2 pa = a.to(p);
        double dot00 = ac.dot(ac);
        double dot01 = ac.dot(ab);
        double dot02 = ac.dot(pa);
        double dot11 = ab.dot(ab);
        double dot12 = ab.dot(pa);
        double denominator = dot00 * dot11 - dot01 * dot01;
        double u = (dot11 * dot02 - dot01 * dot12) / denominator;
        double v = (dot00 * dot12 - dot01 * dot02) / denominator;
        return u > 0.0 && v > 0.0 && u + v <= 1.0 + CONTAINS_EPSILON;
    }
}

