/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.hull;

import java.util.Arrays;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.hull.HullGenerator;
import org.dyn4j.geometry.hull.LinkedVertexHull;
import org.dyn4j.geometry.hull.MinXPointComparator;
import org.dyn4j.resources.Messages;

public class DivideAndConquer
implements HullGenerator {
    @Override
    public Vector2[] generate(Vector2 ... points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.hull.nullArray"));
        }
        int size = points.length;
        if (size <= 2) {
            return points;
        }
        try {
            Arrays.sort(points, new MinXPointComparator());
        }
        catch (NullPointerException e) {
            throw new NullPointerException(Messages.getString("geometry.hull.nullPoints"));
        }
        LinkedVertexHull hull = this.divide(points, 0, size - 1);
        return hull.toArray();
    }

    final LinkedVertexHull divide(Vector2[] points, int first, int last) {
        int size = last - first;
        if (size == 0) {
            return new LinkedVertexHull(points[first]);
        }
        int mid = (first + last) / 2;
        LinkedVertexHull left = this.divide(points, first, mid);
        LinkedVertexHull right = this.divide(points, mid + 1, last);
        return LinkedVertexHull.merge(left, right);
    }
}

