/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.hull;

import java.util.ArrayList;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.hull.HullGenerator;
import org.dyn4j.resources.Messages;

public class GiftWrap
implements HullGenerator {
    @Override
    public Vector2[] generate(Vector2 ... points) {
        Vector2 maxLeft;
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.hull.nullArray"));
        }
        int size = points.length;
        if (size <= 2) {
            return points;
        }
        double x = Double.MAX_VALUE;
        Vector2 leftMost = null;
        int i = 0;
        while (i < size) {
            Vector2 p = points[i];
            if (p == null) {
                throw new NullPointerException(Messages.getString("geometry.hull.nullPoints"));
            }
            if (p.x < x) {
                x = p.x;
                leftMost = p;
            }
            ++i;
        }
        ArrayList<Vector2> hull = new ArrayList<Vector2>(size);
        do {
            hull.add(leftMost);
            maxLeft = points[0];
            if (maxLeft == leftMost) {
                maxLeft = points[1];
            }
            int j = 0;
            while (j < size) {
                Vector2 t = points[j];
                if (t != maxLeft && t != leftMost && Segment.getLocation(t, leftMost, maxLeft) < 0.0) {
                    maxLeft = t;
                }
                ++j;
            }
        } while ((leftMost = maxLeft) != hull.get(0));
        Vector2[] hullPoints = new Vector2[hull.size()];
        hull.toArray(hullPoints);
        return hullPoints;
    }
}

