/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.hull;

import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.hull.LinkedVertex;

final class LinkedVertexHull {
    LinkedVertex root;
    LinkedVertex leftMost;
    LinkedVertex rightMost;
    int size;

    public LinkedVertexHull() {
    }

    public LinkedVertexHull(Vector2 point) {
        LinkedVertex root;
        this.root = root = new LinkedVertex(point);
        this.leftMost = root;
        this.rightMost = root;
        this.size = 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LinkedVertexHull[Size=").append(this.size).append("|Root=").append(this.root.point);
        return sb.toString();
    }

    public final Vector2[] toArray() {
        Vector2[] points = new Vector2[this.size];
        LinkedVertex vertex = this.root;
        int i = 0;
        while (i < this.size) {
            points[i] = vertex.point;
            vertex = vertex.next;
            ++i;
        }
        return points;
    }

    public static final LinkedVertexHull merge(LinkedVertexHull left, LinkedVertexHull right) {
        if (left.size == 1 && right.size == 1) {
            return LinkedVertexHull.mergePointPoint(left, right);
        }
        if (left.size + right.size == 3) {
            return LinkedVertexHull.mergePointSegment(left, right);
        }
        return LinkedVertexHull.mergeHulls(left, right);
    }

    static final LinkedVertexHull mergePointPoint(LinkedVertexHull left, LinkedVertexHull right) {
        LinkedVertex rightRoot;
        LinkedVertex leftRoot = left.root;
        leftRoot.next = rightRoot = right.root;
        leftRoot.prev = rightRoot;
        rightRoot.next = leftRoot;
        rightRoot.prev = leftRoot;
        LinkedVertexHull hull = new LinkedVertexHull();
        hull.root = leftRoot;
        hull.leftMost = leftRoot;
        hull.rightMost = rightRoot;
        hull.size = 2;
        return hull;
    }

    static final LinkedVertexHull mergePointSegment(LinkedVertexHull left, LinkedVertexHull right) {
        LinkedVertexHull hull = new LinkedVertexHull();
        hull.size = 3;
        LinkedVertexHull point = left;
        LinkedVertexHull segment = right;
        if (left.size == 1) {
            hull.leftMost = left.root;
            hull.rightMost = right.rightMost;
        } else {
            hull.leftMost = left.leftMost;
            hull.rightMost = right.root;
            point = right;
            segment = left;
        }
        hull.root = point.root;
        Vector2 p1 = segment.root.point;
        Vector2 p2 = segment.root.next.point;
        Vector2 p = point.root.point;
        Vector2 v1 = p.to(p1);
        Vector2 v2 = p1.to(p2);
        double area = v1.cross(v2);
        if (area < 0.0) {
            point.root.next = segment.root.next;
            segment.root.next.prev = point.root;
            point.root.prev = segment.root;
            segment.root.next = point.root;
        } else {
            point.root.next = segment.root;
            segment.root.prev = point.root;
            point.root.prev = segment.root.next;
            segment.root.next.next = point.root;
        }
        return hull;
    }

    static final LinkedVertexHull mergeHulls(LinkedVertexHull left, LinkedVertexHull right) {
        LinkedVertex v0;
        LinkedVertexHull hull = new LinkedVertexHull();
        hull.leftMost = left.leftMost;
        hull.rightMost = right.rightMost;
        LinkedVertex lu = left.rightMost;
        LinkedVertex ru = right.leftMost;
        Vector2 upper = lu.point.to(ru.point);
        int i = 0;
        while (i < left.size * right.size) {
            Vector2 lv = lu.point.to(lu.next.point);
            Vector2 rv = ru.point.to(ru.prev.point);
            double crossR = rv.cross(upper);
            double crossL = upper.getNegative().cross(lv);
            if (crossR > 0.0 && crossL > 0.0) break;
            if (crossR <= 0.0) {
                ru = ru.prev;
            }
            if (crossL <= 0.0) {
                lu = lu.next;
            }
            upper = lu.point.to(ru.point);
            ++i;
        }
        LinkedVertex ll = left.rightMost;
        LinkedVertex rl = right.leftMost;
        Vector2 lower = ll.point.to(rl.point);
        int i2 = 0;
        while (i2 < left.size * right.size) {
            Vector2 lv = ll.point.to(ll.prev.point);
            Vector2 rv = rl.point.to(rl.next.point);
            double crossR = lower.cross(rv);
            double crossL = lv.cross(lower.getNegative());
            if (crossR > 0.0 && crossL > 0.0) break;
            if (crossR <= 0.0) {
                rl = rl.next;
            }
            if (crossL <= 0.0) {
                ll = ll.prev;
            }
            lower = ll.point.to(rl.point);
            ++i2;
        }
        lu.prev = ru;
        ru.next = lu;
        ll.next = rl;
        rl.prev = ll;
        LinkedVertex v = v0 = (hull.root = lu);
        int size = 0;
        do {
            ++size;
        } while ((v = v.next) != v0);
        hull.size = size;
        return hull;
    }
}

