/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.zip.classes;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import org.zeroturnaround.zip.ByteSource;
import org.zeroturnaround.zip.NameMapper;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipInfoCallback;
import org.zeroturnaround.zip.ZipUtil;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.MiscStream;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="ZipFile")
@Reflection.Namespace(value="php\\compress")
public class PZipFile
extends BaseObject {
    private File zipFile;

    public PZipFile(Environment env, File zipFile) {
        super(env);
        this.zipFile = zipFile;
    }

    public PZipFile(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct(File file) throws FileNotFoundException {
        this.__construct(file, false);
    }

    @Reflection.Signature
    public void __construct(File file, boolean create) throws FileNotFoundException {
        if (!file.isFile()) {
            if (create) {
                ZipUtil.packEntries((File[])new File[0], (File)file);
            } else {
                throw new FileNotFoundException(file.getPath() + " not found, use ZipFile::create() to make zip archive.");
            }
        }
        this.zipFile = file;
    }

    @Reflection.Signature
    public static PZipFile create(Environment env, File file) throws Throwable {
        return PZipFile.create(env, file, true);
    }

    @Reflection.Signature
    public static PZipFile create(Environment env, File file, boolean rewrite) throws Throwable {
        if (rewrite) {
            if (file.exists() && !file.delete()) {
                throw new IOException("Failed to rewrite zip archive: " + file.getPath());
            }
        } else if (file.exists()) {
            throw new IOException("Zip archive already exists: " + file.getPath());
        }
        PZipFile zipFile = new PZipFile(env, file);
        env.invokeMethod((IObject)zipFile, "__construct", new Memory[]{StringMemory.valueOf((String)file.getPath()), Memory.TRUE});
        return zipFile;
    }

    @Reflection.Signature
    public Memory __debugInfo() {
        return ArrayMemory.ofPair((String)"*path", (String)this.getPath()).toConstant();
    }

    @Reflection.Signature
    public String getPath() {
        return this.zipFile.getPath();
    }

    @Reflection.Signature
    public void repack(int compressLevel) {
        ZipUtil.repack((File)this.zipFile, (int)compressLevel);
    }

    @Reflection.Signature
    public void add(String path, InputStream source) throws IOException {
        this.add(path, source, -1);
    }

    private static ZipEntrySource streamToEntrySource(InputStream stream, String path, int compressLevel) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return new ByteSource(path, buffer.toByteArray(), compressLevel);
    }

    @Reflection.Signature
    public void add(String path, InputStream source, int compressLevel) throws IOException {
        ZipUtil.addOrReplaceEntries((File)this.zipFile, (ZipEntrySource[])new ZipEntrySource[]{PZipFile.streamToEntrySource(source, path, compressLevel)});
    }

    @Reflection.Signature
    public void addFromString(Environment env, String path, Memory string) {
        this.addFromString(env, path, string, -1);
    }

    @Reflection.Signature
    public void addFromString(Environment env, String path, Memory string, int compressLevel) {
        ZipUtil.addOrReplaceEntries((File)this.zipFile, (ZipEntrySource[])new ZipEntrySource[]{new ByteSource(path, string.getBinaryBytes(env.getDefaultCharset()), compressLevel)});
    }

    @Reflection.Signature
    public void addDirectory(Environment env, File path) {
        this.addDirectory(env, path, -1, null);
    }

    @Reflection.Signature
    public void addDirectory(Environment env, File path, int compressLevel) {
        this.addDirectory(env, path, compressLevel, null);
    }

    @Reflection.Signature
    public void addDirectory(Environment env, File path, int compressLevel, @Reflection.Nullable Invoker invoker) {
        ZipUtil.pack((File)path, (File)this.zipFile, (NameMapper)PZipFile.invokerToNameMapper(invoker), (int)compressLevel);
    }

    @Reflection.Signature
    public void remove(Environment env, Memory path) {
        if (path.isTraversable()) {
            ForeachIterator iterator = path.getNewIterator(env);
            ArrayList<String> paths = new ArrayList<String>();
            while (iterator.next()) {
                String value = iterator.getValue().toString();
                paths.add(value);
            }
            ZipUtil.removeEntries((File)this.zipFile, (String[])paths.toArray(new String[paths.size()]));
        } else {
            ZipUtil.removeEntry((File)this.zipFile, (String)path.toString());
        }
    }

    private static ArrayMemory zipEntryToArray(ZipEntry zipEntry) {
        ArrayMemory result = new ArrayMemory();
        result.refOfIndex("name").assign(zipEntry.getName());
        result.refOfIndex("crc").assign(zipEntry.getCrc());
        result.refOfIndex("size").assign(zipEntry.getSize());
        result.refOfIndex("compressedSize").assign(zipEntry.getCompressedSize());
        result.refOfIndex("time").assign(zipEntry.getTime());
        result.refOfIndex("method").assign((long)zipEntry.getMethod());
        result.refOfIndex("comment").assign(zipEntry.getComment());
        result.refOfIndex("directory").assign(zipEntry.isDirectory());
        return result;
    }

    @Reflection.Signature
    public Memory stat(String path) {
        final ArrayMemory[] result = new ArrayMemory[1];
        ZipUtil.iterate((File)this.zipFile, (String[])new String[]{path}, (ZipInfoCallback)new ZipInfoCallback(){

            public void process(ZipEntry zipEntry) throws IOException {
                result[0] = PZipFile.zipEntryToArray(zipEntry);
            }
        });
        return result[0].toConstant();
    }

    @Reflection.Signature
    public Memory statAll() {
        final ArrayMemory result = new ArrayMemory();
        ZipUtil.iterate((File)this.zipFile, (ZipInfoCallback)new ZipInfoCallback(){

            public void process(ZipEntry zipEntry) throws IOException {
                result.put((Object)zipEntry.getName(), (Memory)PZipFile.zipEntryToArray(zipEntry));
            }
        });
        return result.toConstant();
    }

    @Reflection.Signature
    public void read(final Environment env, String path, final Invoker callback) {
        ZipUtil.iterate((File)this.zipFile, (String[])new String[]{path}, (ZipEntryCallback)new ZipEntryCallback(){

            public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                callback.callAny(new Object[]{PZipFile.zipEntryToArray(zipEntry), new MiscStream(env, in)});
            }
        });
    }

    @Reflection.Signature
    public void readAll(final Environment env, final Invoker callback) {
        ZipUtil.iterate((File)this.zipFile, (ZipEntryCallback)new ZipEntryCallback(){

            public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                callback.callAny(new Object[]{PZipFile.zipEntryToArray(zipEntry), new MiscStream(env, in)});
            }
        });
    }

    @Reflection.Signature
    public boolean has(String path) {
        return ZipUtil.containsEntry((File)this.zipFile, (String)path);
    }

    @Reflection.Signature
    public static void unwrap(PZipFile zip, File outputDir, @Reflection.Nullable Invoker callback) throws FileNotFoundException {
        if (!zip.zipFile.isFile()) {
            throw new FileNotFoundException(zip.zipFile.getPath() + " not found");
        }
        NameMapper mapper = PZipFile.invokerToNameMapper(callback);
        ZipUtil.unwrap((File)zip.zipFile, (File)outputDir, (NameMapper)mapper);
    }

    @Reflection.Signature
    public void unpack(File outputDir) throws FileNotFoundException {
        this.unpack(outputDir, null, null);
    }

    @Reflection.Signature
    public void unpack(File outputDir, String charset) throws FileNotFoundException {
        this.unpack(outputDir, charset, null);
    }

    @Reflection.Signature
    public void unpack(File outputDir, String charset, @Reflection.Nullable Invoker callback) throws FileNotFoundException {
        if (!this.zipFile.isFile()) {
            throw new FileNotFoundException(this.zipFile.getPath() + " not found");
        }
        NameMapper mapper = PZipFile.invokerToNameMapper(callback);
        if (charset == null || charset.isEmpty()) {
            ZipUtil.unpack((File)this.zipFile, (File)outputDir, (NameMapper)mapper);
        } else {
            ZipUtil.unpack((File)this.zipFile, (File)outputDir, (Charset)Charset.forName(charset));
        }
    }

    private static NameMapper invokerToNameMapper(final Invoker invoker) {
        return new NameMapper(){

            public String map(String name) {
                if (invoker == null) {
                    return name;
                }
                Memory r = invoker.callNoThrow(new Memory[]{StringMemory.valueOf((String)name)});
                if (r.isNull()) {
                    return name;
                }
                return r.toString();
            }
        };
    }
}

