/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.common;

import java.util.HashMap;
import java.util.Map;

public enum HintType {
    ANY,
    STRING,
    INT,
    DOUBLE,
    NUMBER,
    BOOLEAN,
    ARRAY,
    OBJECT,
    CALLABLE,
    VARARG,
    TRAVERSABLE,
    ITERABLE,
    VOID,
    SELF;

    private static final Map<String, HintType> values;

    public String toString() {
        switch (this) {
            case ARRAY: {
                return "array";
            }
            case INT: {
                return "int";
            }
            case DOUBLE: {
                return "float";
            }
            case BOOLEAN: {
                return "bool";
            }
            case CALLABLE: {
                return "callable";
            }
            case STRING: {
                return "string";
            }
            case OBJECT: {
                return "object";
            }
            case VARARG: {
                return "...";
            }
            case TRAVERSABLE: {
                return "traversable";
            }
            case ITERABLE: {
                return "iterable";
            }
            case VOID: {
                return "void";
            }
            case SELF: {
                return "self";
            }
        }
        return "";
    }

    public static HintType of(String code) {
        return values.get(code);
    }

    static {
        values = new HashMap<String, HintType>();
        for (HintType e : HintType.values()) {
            values.put(e.toString(), e);
        }
    }
}

