/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext;

import java.io.IOException;
import java.net.SocketException;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import php.runtime.env.CompileScope;
import php.runtime.env.Environment;
import php.runtime.env.handler.ProgramShutdownHandler;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.ext.core.ArrayConstants;
import php.runtime.ext.core.ArrayFunctions;
import php.runtime.ext.core.InfoConstants;
import php.runtime.ext.core.InfoFunctions;
import php.runtime.ext.core.LangConstants;
import php.runtime.ext.core.LangFunctions;
import php.runtime.ext.core.MathConstants;
import php.runtime.ext.core.MathFunctions;
import php.runtime.ext.core.OutputConstants;
import php.runtime.ext.core.OutputFunctions;
import php.runtime.ext.core.StringFunctions;
import php.runtime.ext.core.classes.WrapClassLoader;
import php.runtime.ext.core.classes.WrapEnvironment;
import php.runtime.ext.core.classes.WrapEnvironmentVariables;
import php.runtime.ext.core.classes.WrapFuture;
import php.runtime.ext.core.classes.WrapInvoker;
import php.runtime.ext.core.classes.WrapJavaExceptions;
import php.runtime.ext.core.classes.WrapModule;
import php.runtime.ext.core.classes.WrapPackage;
import php.runtime.ext.core.classes.WrapPackageLoader;
import php.runtime.ext.core.classes.WrapProcess;
import php.runtime.ext.core.classes.WrapSourceMap;
import php.runtime.ext.core.classes.WrapSystem;
import php.runtime.ext.core.classes.WrapThread;
import php.runtime.ext.core.classes.WrapThreadGroup;
import php.runtime.ext.core.classes.WrapThreadPool;
import php.runtime.ext.core.classes.format.WrapProcessor;
import php.runtime.ext.core.classes.lib.BinUtils;
import php.runtime.ext.core.classes.lib.CharUtils;
import php.runtime.ext.core.classes.lib.FsUtils;
import php.runtime.ext.core.classes.lib.ItemsUtils;
import php.runtime.ext.core.classes.lib.MirrorUtils;
import php.runtime.ext.core.classes.lib.NumUtils;
import php.runtime.ext.core.classes.lib.RxUtils;
import php.runtime.ext.core.classes.lib.SharedUtils;
import php.runtime.ext.core.classes.lib.StrUtils;
import php.runtime.ext.core.classes.lib.legacy.OldBinUtils;
import php.runtime.ext.core.classes.lib.legacy.OldItemsUtils;
import php.runtime.ext.core.classes.lib.legacy.OldMirrorUtils;
import php.runtime.ext.core.classes.lib.legacy.OldNumUtils;
import php.runtime.ext.core.classes.net.WrapServerSocket;
import php.runtime.ext.core.classes.net.WrapSocket;
import php.runtime.ext.core.classes.net.WrapSocketException;
import php.runtime.ext.core.classes.stream.FileObject;
import php.runtime.ext.core.classes.stream.FileStream;
import php.runtime.ext.core.classes.stream.MemoryMiscStream;
import php.runtime.ext.core.classes.stream.MiscStream;
import php.runtime.ext.core.classes.stream.ResourceStream;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.core.classes.stream.WrapIOException;
import php.runtime.ext.core.classes.time.WrapTime;
import php.runtime.ext.core.classes.time.WrapTimeFormat;
import php.runtime.ext.core.classes.time.WrapTimeZone;
import php.runtime.ext.core.classes.time.WrapTimer;
import php.runtime.ext.core.classes.util.WrapConfiguration;
import php.runtime.ext.core.classes.util.WrapFlow;
import php.runtime.ext.core.classes.util.WrapLocale;
import php.runtime.ext.core.classes.util.WrapRegex;
import php.runtime.ext.core.classes.util.WrapScanner;
import php.runtime.ext.core.reflection.Reflection;
import php.runtime.ext.core.reflection.ReflectionClass;
import php.runtime.ext.core.reflection.ReflectionClassConstant;
import php.runtime.ext.core.reflection.ReflectionException;
import php.runtime.ext.core.reflection.ReflectionExtension;
import php.runtime.ext.core.reflection.ReflectionFunction;
import php.runtime.ext.core.reflection.ReflectionFunctionAbstract;
import php.runtime.ext.core.reflection.ReflectionMethod;
import php.runtime.ext.core.reflection.ReflectionObject;
import php.runtime.ext.core.reflection.ReflectionParameter;
import php.runtime.ext.core.reflection.ReflectionProperty;
import php.runtime.ext.core.reflection.ReflectionType;
import php.runtime.ext.core.reflection.Reflector;
import php.runtime.ext.support.Extension;
import php.runtime.ext.support.compile.CompileConstant;
import php.runtime.lang.Closure;
import php.runtime.loader.sourcemap.SourceMap;

public class CoreExtension
extends Extension
implements ProgramShutdownHandler {
    public static final String NAMESPACE = "php\\";

    @Override
    public String getName() {
        return "Core";
    }

    @Override
    public String[] getPackageNames() {
        return new String[]{"std", "core"};
    }

    @Override
    public Extension.Status getStatus() {
        return Extension.Status.STABLE;
    }

    @Override
    public void onRegister(CompileScope scope) {
        long t = System.currentTimeMillis();
        scope.registerProgramShutdownHandler(this);
        this.registerFunctions(new LangFunctions());
        this.registerConstants(new LangConstants());
        this.registerConstants(new InfoConstants());
        this.registerFunctions(new InfoFunctions());
        this.registerConstants(new MathConstants());
        this.registerFunctions(new MathFunctions());
        this.registerFunctions(new StringFunctions());
        this.registerConstants(new ArrayConstants());
        this.registerFunctions(new ArrayFunctions());
        this.registerConstants(new OutputConstants());
        this.registerFunctions(new OutputFunctions());
        for (ErrorType el : ErrorType.values()) {
            CompileConstant compileConstant = new CompileConstant(el.name(), el.value);
            this.constants.put(el.name(), compileConstant);
        }
        this.registerJavaException(scope, WrapJavaExceptions.IllegalArgumentException.class, IllegalArgumentException.class);
        this.registerJavaException(scope, WrapJavaExceptions.IllegalStateException.class, IllegalStateException.class);
        this.registerJavaException(scope, WrapJavaExceptions.NumberFormatException.class, NumberFormatException.class);
        this.registerJavaException(scope, WrapJavaExceptions.InterruptedException.class, InterruptedException.class);
        this.registerClass(scope, CharUtils.class, StrUtils.class, BinUtils.class, NumUtils.class, ItemsUtils.class, MirrorUtils.class, FsUtils.class, OldBinUtils.class, OldItemsUtils.class, OldNumUtils.class, OldMirrorUtils.class, RxUtils.class);
        this.registerClass(scope, SharedUtils.SharedMemory.class, SharedUtils.SharedCollection.class, SharedUtils.SharedValue.class, SharedUtils.SharedStack.class, SharedUtils.SharedQueue.class, SharedUtils.SharedMap.class, SharedUtils.class, WrapPackageLoader.class, WrapClassLoader.class, WrapClassLoader.WrapLauncherClassLoader.class, WrapLocale.class, WrapScanner.class, WrapFlow.class, WrapConfiguration.class, WrapRegex.class);
        this.registerJavaExceptionForContext(scope, WrapRegex.RegexException.class, WrapRegex.class);
        this.registerClass(scope, WrapTimeZone.class, WrapTimeFormat.class, WrapTime.class);
        this.registerWrapperClass(scope, TimerTask.class, WrapTimer.class);
        this.registerClass(scope, WrapInvoker.class, WrapModule.class, WrapPackage.class, Closure.ClosureInvoker.class);
        this.registerWrapperClass(scope, SourceMap.class, WrapSourceMap.class);
        this.registerClass(scope, WrapEnvironment.class, WrapEnvironmentVariables.class, WrapThreadGroup.class, WrapThread.class, WrapSystem.class, Reflector.class, Reflection.class, ReflectionException.class, ReflectionExtension.class, ReflectionType.class, ReflectionFunctionAbstract.class, ReflectionFunction.class, ReflectionParameter.class, ReflectionProperty.class, ReflectionMethod.class, ReflectionClass.class, ReflectionObject.class, ReflectionClassConstant.class);
        this.registerClass(scope, (Class<?>)WrapJavaExceptions.NotImplementedException.class);
        this.registerJavaException(scope, WrapIOException.class, IOException.class);
        this.registerClass(scope, FileObject.class, Stream.class, FileStream.class, MiscStream.class, MemoryMiscStream.class, ResourceStream.class);
        this.registerClass(scope, WrapSocket.class, WrapServerSocket.class);
        this.registerJavaException(scope, WrapSocketException.class, SocketException.class);
        this.registerClass(scope, WrapThreadPool.class, WrapFuture.class);
        this.registerJavaException(scope, WrapJavaExceptions.TimeoutException.class, TimeoutException.class);
        this.registerClass(scope, WrapProcessor.class, WrapProcessor.ProcessorException.class, WrapProcess.class);
    }

    @Override
    public void onLoad(Environment env) {
        Stream.initEnvironment(env);
    }

    @Override
    public void onShutdown(CompileScope scope, Environment env) {
        WrapTimer.cancelAll();
    }
}

