/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.env.Package;
import php.runtime.env.PackageLoader;
import php.runtime.env.TraceInfo;
import php.runtime.ext.core.classes.WrapPackage;
import php.runtime.invoke.DynamicMethodInvoker;
import php.runtime.lang.BaseObject;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lang\\PackageLoader")
public abstract class WrapPackageLoader
extends BaseObject {
    protected PackageLoader loader;

    public WrapPackageLoader(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct() {
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public abstract Memory load(Environment var1, Memory ... var2) throws Throwable;

    @Reflection.Signature
    public void register(Environment env) {
        if (this.loader == null) {
            env.getPackageManager().registerLoader(this._getPackageLoader(env));
        } else {
            env.exception("PackageLoader is already registered", new Object[0]);
        }
    }

    @Reflection.Signature
    public void unregister(Environment env) {
        if (this.loader == null) {
            env.exception("PackageLoader is not registered", new Object[0]);
        }
        env.getPackageManager().unregisterLoader(this.loader);
        this.loader = null;
    }

    protected synchronized PackageLoader _getPackageLoader(final Environment env) {
        if (this.loader == null) {
            final DynamicMethodInvoker invoker = DynamicMethodInvoker.valueOf(env, env.trace(), this, "load");
            this.loader = new PackageLoader(){

                @Override
                public Package load(String name, TraceInfo trace) {
                    if (invoker == null) {
                        env.error(trace, "Cannot call load() method of packageLoader", new Object[0]);
                        return null;
                    }
                    Memory ret = invoker.callNoThrow(StringMemory.valueOf(name));
                    if (ret.isNull()) {
                        return null;
                    }
                    if (ret.instanceOf(WrapPackage.class)) {
                        return ret.toObject(WrapPackage.class).getPackage();
                    }
                    env.error(trace, WrapPackageLoader.this.getReflection().getName() + "::load() method must return an instance of php\\lang\\Package", new Object[0]);
                    return null;
                }
            };
        }
        return this.loader;
    }
}

