/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.net.WrapSocket;
import php.runtime.lang.BaseObject;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\net\\ServerSocket")
public class WrapServerSocket
extends BaseObject {
    protected ServerSocket socket;

    public WrapServerSocket(Environment env) {
        super(env);
    }

    public WrapServerSocket(Environment env, ServerSocket socket) {
        super(env);
        this.setSocket(socket);
    }

    public WrapServerSocket(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public ServerSocket getSocket() {
        return this.socket;
    }

    public void setSocket(ServerSocket socket) {
        this.socket = socket;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="port", optional=@Reflection.Optional(value="NULL")), @Reflection.Arg(value="backLog", optional=@Reflection.Optional(value="50", type=HintType.INT))})
    public Memory __construct(Environment env, Memory ... args) throws IOException {
        if (args[0].isNull()) {
            this.setSocket(new ServerSocket());
        } else {
            this.setSocket(new ServerSocket(args[0].toInteger(), args[1].toInteger()));
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory accept(Environment env, Memory ... args) throws IOException {
        return new ObjectMemory(new WrapSocket(env, this.socket.accept()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="hostname"), @Reflection.Arg(value="port"), @Reflection.Arg(value="backLog", optional=@Reflection.Optional(value="50", type=HintType.INT))})
    public Memory bind(Environment env, Memory ... args) throws IOException {
        this.socket.bind(new InetSocketAddress(args[0].toString(), args[1].toInteger()), args[2].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory close(Environment env, Memory ... args) throws IOException {
        this.socket.close();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory isClosed(Environment env, Memory ... args) {
        return this.socket.isClosed() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isBound(Environment env, Memory ... args) {
        return this.socket.isBound() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="timeout")})
    public Memory setSoTimeout(Environment env, Memory ... args) throws SocketException {
        this.socket.setSoTimeout(args[0].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="on")})
    public Memory setReuseAddress(Environment env, Memory ... args) throws SocketException {
        this.socket.setReuseAddress(args[0].toBoolean());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="size")})
    public Memory setReceiveBufferSize(Environment env, Memory ... args) throws SocketException {
        this.socket.setReceiveBufferSize(args[0].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="connectTime"), @Reflection.Arg(value="latency"), @Reflection.Arg(value="bandWidth")})
    public Memory setPerformancePreferences(Environment env, Memory ... args) throws SocketException {
        this.socket.setPerformancePreferences(args[0].toInteger(), args[1].toInteger(), args[2].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature
    public static Memory findAvailableLocalPort(Environment env, Memory ... args) {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            serverSocket.close();
            return LongMemory.valueOf(serverSocket.getLocalPort());
        }
        catch (IOException e) {
            return Memory.FALSE;
        }
    }
}

