/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.time;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.annotation.Runtime;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.time.WrapTimeZone;
import php.runtime.ext.core.classes.util.WrapLocale;
import php.runtime.lang.BaseObject;
import php.runtime.lang.support.IComparableObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\time\\Time")
public class WrapTime
extends BaseObject
implements IComparableObject<WrapTime> {
    protected static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    protected Date date;
    protected TimeZone timeZone;
    protected Calendar calendar;
    protected Locale locale;

    public WrapTime(Environment env, Date date) {
        super(env);
        this.date = date;
        this.timeZone = UTC;
        this.calendar = Calendar.getInstance(UTC, Locale.ENGLISH);
        this.calendar.setTime(date);
        this.locale = Locale.ENGLISH;
    }

    public WrapTime(Environment env, Date date, TimeZone timeZone) {
        this(env, date, timeZone, null);
    }

    public WrapTime(Environment env, Date date, TimeZone timeZone, Locale locale) {
        super(env);
        this.date = date;
        this.timeZone = timeZone;
        this.locale = locale == null ? Locale.ENGLISH : locale;
        this.calendar = Calendar.getInstance(timeZone, this.locale);
        this.calendar.setTime(date);
    }

    public WrapTime(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public Date getDate() {
        return this.date;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="date", optional=@Reflection.Optional(value="null")), @Reflection.Arg(value="timeZone", nativeType=WrapTimeZone.class, optional=@Reflection.Optional(value="null")), @Reflection.Arg(value="locale", nativeType=WrapLocale.class, optional=@Reflection.Optional(value="null"))})
    public Memory __construct(Environment env, Memory ... args) {
        TimeZone zone;
        this.timeZone = zone = WrapTimeZone.getTimeZone(env, args[1]);
        this.locale = args[2].isNull() ? Locale.ENGLISH : args[2].toObject(WrapLocale.class).getLocale();
        this.date = args[0].isNull() ? Calendar.getInstance(zone, this.locale).getTime() : new Date(args[0].toLong());
        this.calendar = Calendar.getInstance(this.timeZone, this.locale);
        this.calendar.setTime(this.date);
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory __debugInfo(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex("*time").assign(this.date.getTime());
        r.refOfIndex("*timeZone").assign(this.timeZone.getID());
        return r.toConstant();
    }

    @Reflection.Signature
    public Memory getTime(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.date.getTime());
    }

    @Reflection.Signature
    public Memory year(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(1));
    }

    @Reflection.Signature
    public Memory month(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(2) + 1);
    }

    @Reflection.Signature
    public Memory week(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(3));
    }

    @Reflection.Signature
    public Memory weekOfMonth(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(4));
    }

    @Reflection.Signature
    public Memory day(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(6));
    }

    @Reflection.Signature
    public Memory dayOfMonth(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(5));
    }

    @Reflection.Signature
    public Memory dayOfWeek(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(7));
    }

    @Reflection.Signature
    public Memory dayOfWeekInMonth(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(8));
    }

    @Reflection.Signature
    public Memory hour(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(10));
    }

    @Reflection.Signature
    public Memory hourOfDay(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(11));
    }

    @Reflection.Signature
    public Memory minute(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(12));
    }

    @Reflection.Signature
    public Memory second(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(13));
    }

    @Reflection.Signature
    public Memory millisecond(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.get(14));
    }

    @Reflection.Signature
    public Memory getTimeZone(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapTimeZone(env, this.timeZone));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="time", nativeType=WrapTime.class)})
    public Memory compare(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.calendar.compareTo(args[0].toObject(WrapTime.class).calendar));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="timeZone", nativeType=WrapTimeZone.class, optional=@Reflection.Optional(value="null")), @Reflection.Arg(value="locale", nativeType=WrapLocale.class, optional=@Reflection.Optional(value="NULL"))})
    public static Memory now(Environment env, Memory ... args) {
        Locale aLocale = args[1].isNull() ? Locale.ENGLISH : args[1].toObject(WrapLocale.class).getLocale();
        TimeZone zone = WrapTimeZone.getTimeZone(env, args[0]);
        return new ObjectMemory(new WrapTime(env, Calendar.getInstance(zone, aLocale).getTime(), zone, aLocale));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="timeZone", nativeType=WrapTimeZone.class)})
    public Memory withTimezone(Environment env, Memory ... args) {
        TimeZone zone = WrapTimeZone.getTimeZone(env, args[0]);
        return new ObjectMemory(new WrapTime(env, this.date, zone, this.locale));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="locale", nativeType=WrapLocale.class)})
    public Memory withLocale(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapTime(env, this.date, this.timeZone, args[0].toObject(WrapLocale.class).getLocale()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="args", type=HintType.ARRAY)})
    public Memory add(Environment env, Memory ... args) {
        ArrayMemory arg = args[0].toValue(ArrayMemory.class);
        ReferenceMemory year = arg.getByScalar("year");
        ReferenceMemory month = arg.getByScalar("month");
        ReferenceMemory day = arg.getByScalar("day");
        ReferenceMemory hour = arg.getByScalar("hour");
        ReferenceMemory min = arg.getByScalar("min");
        ReferenceMemory sec = arg.getByScalar("sec");
        ReferenceMemory millis = arg.getByScalar("millis");
        Calendar calendar1 = (Calendar)this.calendar.clone();
        if (year != null) {
            calendar1.add(1, year.toInteger());
        }
        if (month != null) {
            calendar1.add(2, month.toInteger());
        }
        if (day != null) {
            calendar1.add(5, day.toInteger());
        }
        if (hour != null) {
            calendar1.add(11, hour.toInteger());
        }
        if (min != null) {
            calendar1.add(12, min.toInteger());
        }
        if (sec != null) {
            calendar1.add(13, sec.toInteger());
        }
        if (millis != null) {
            calendar1.add(14, millis.toInteger());
        }
        return new ObjectMemory(new WrapTime(env, calendar1.getTime(), this.timeZone));
    }

    @Reflection.Signature
    public Memory __toString(Environment env, Memory ... args) {
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoFormat.setTimeZone(this.timeZone);
        return new StringMemory(isoFormat.format(this.date));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="format"), @Reflection.Arg(value="locale", nativeType=WrapLocale.class, optional=@Reflection.Optional(value="NULL"))})
    public Memory toString(Environment env, Memory ... args) {
        Locale aLocale = args[1].isNull() ? this.locale : args[1].toObject(WrapLocale.class).getLocale();
        SimpleDateFormat format = new SimpleDateFormat(args[0].toString(), aLocale);
        format.setTimeZone(this.timeZone);
        return StringMemory.valueOf(format.format(this.date));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="args", type=HintType.ARRAY)})
    public Memory replace(Environment env, Memory ... args) {
        ArrayMemory arg = args[0].toValue(ArrayMemory.class);
        ReferenceMemory year = arg.getByScalar("year");
        ReferenceMemory month = arg.getByScalar("month");
        ReferenceMemory day = arg.getByScalar("day");
        ReferenceMemory hour = arg.getByScalar("hour");
        ReferenceMemory min = arg.getByScalar("min");
        ReferenceMemory sec = arg.getByScalar("sec");
        ReferenceMemory millis = arg.getByScalar("millis");
        Calendar calendar1 = (Calendar)this.calendar.clone();
        if (year != null) {
            calendar1.set(1, year.toInteger());
        }
        if (month != null) {
            calendar1.set(2, month.toInteger() - 1);
        }
        if (day != null) {
            calendar1.set(5, day.toInteger());
        }
        if (hour != null) {
            calendar1.set(11, hour.toInteger());
        }
        if (min != null) {
            calendar1.set(12, min.toInteger());
        }
        if (sec != null) {
            calendar1.set(13, sec.toInteger());
        }
        if (millis != null) {
            calendar1.set(14, millis.toInteger());
        }
        return new ObjectMemory(new WrapTime(env, calendar1.getTime(), calendar1.getTimeZone()));
    }

    @Runtime.FastMethod
    @Reflection.Signature
    public static Memory millis(Environment env, Memory ... args) {
        return LongMemory.valueOf(System.currentTimeMillis());
    }

    @Runtime.FastMethod
    @Reflection.Signature
    public static Memory seconds(Environment env, Memory ... args) {
        return LongMemory.valueOf(System.currentTimeMillis() / 1000L);
    }

    @Runtime.FastMethod
    @Reflection.Signature
    public static Memory nanos(Environment env, Memory ... args) {
        return LongMemory.valueOf(System.nanoTime());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="timeZone", nativeType=WrapTimeZone.class, optional=@Reflection.Optional(value="NULL")), @Reflection.Arg(value="locale", nativeType=WrapLocale.class, optional=@Reflection.Optional(value="NULL"))})
    public static Memory today(Environment env, Memory ... args) {
        Date date1 = new Date();
        Locale aLocale = args[1].isNull() ? Locale.ENGLISH : args[1].toObject(WrapLocale.class).getLocale();
        Calendar calendar = Calendar.getInstance(WrapTimeZone.getTimeZone(env, args[0]), aLocale);
        calendar.setTime(date1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return new ObjectMemory(new WrapTime(env, calendar.getTime(), calendar.getTimeZone(), aLocale));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="args", type=HintType.ARRAY), @Reflection.Arg(value="timeZone", nativeType=WrapTimeZone.class, optional=@Reflection.Optional(value="null")), @Reflection.Arg(value="locale", nativeType=WrapLocale.class, optional=@Reflection.Optional(value="null"))})
    public static Memory of(Environment env, Memory ... args) {
        int day;
        Locale aLocale = args[2].isNull() ? Locale.ENGLISH : args[2].toObject(WrapLocale.class).getLocale();
        Calendar calendar = Calendar.getInstance(WrapTimeZone.getTimeZone(env, args[1]), aLocale);
        Memory arg = args[0];
        int year = arg.valueOfIndex("year").toInteger();
        ReferenceMemory m = arg.toValue(ArrayMemory.class).getByScalar("month");
        int month = 1;
        if (m != null) {
            month = m.toInteger();
        }
        if ((day = arg.valueOfIndex("day").toInteger()) < 1) {
            day = 1;
        }
        int hour = arg.valueOfIndex("hour").toInteger();
        int min = arg.valueOfIndex("min").toInteger();
        int sec = arg.valueOfIndex("sec").toInteger();
        calendar.set(year, month - 1, day, hour, min, sec);
        calendar.set(14, arg.valueOfIndex("millis").toInteger());
        return new ObjectMemory(new WrapTime(env, calendar.getTime(), calendar.getTimeZone(), aLocale));
    }

    @Override
    public boolean __equal(WrapTime iObject) {
        return this.calendar.compareTo(iObject.calendar) == 0;
    }

    @Override
    public boolean __identical(WrapTime iObject) {
        return this.calendar.compareTo(iObject.calendar) == 0 && this.timeZone.getID().equals(iObject.timeZone.getID());
    }

    @Override
    public boolean __greater(WrapTime iObject) {
        return this.calendar.compareTo(iObject.calendar) > 0;
    }

    @Override
    public boolean __greaterEq(WrapTime iObject) {
        return this.calendar.compareTo(iObject.calendar) >= 0;
    }

    @Override
    public boolean __smaller(WrapTime iObject) {
        return this.calendar.compareTo(iObject.calendar) < 0;
    }

    @Override
    public boolean __smallerEq(WrapTime iObject) {
        return this.calendar.compareTo(iObject.calendar) <= 0;
    }

    @Reflection.Signature
    private Memory __clone(Environment env, Memory ... args) {
        return Memory.NULL;
    }
}

