/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.reflection;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.reflection.Reflection;
import php.runtime.ext.core.reflection.ReflectionClass;
import php.runtime.ext.core.reflection.ReflectionFunction;
import php.runtime.ext.core.reflection.ReflectionMethod;
import php.runtime.ext.core.reflection.ReflectionType;
import php.runtime.ext.core.reflection.Reflector;
import php.runtime.invoke.Invoker;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.helper.ClassConstantMemory;
import php.runtime.memory.helper.ConstantMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ParameterEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.support.AbstractFunctionEntity;
import php.runtime.reflection.support.TypeChecker;

@Reflection.Name(value="ReflectionParameter")
@Reflection.Signature(value={@Reflection.Arg(value="name", type=HintType.STRING, readOnly=true)})
public class ReflectionParameter
extends Reflection
implements Reflector {
    private ParameterEntity entity;
    private AbstractFunctionEntity functionEntity;
    private ObjectMemory cachedFunction;
    private int position;

    public ReflectionParameter(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="function"), @Reflection.Arg(value="parameter")})
    public Memory __construct(Environment env, Memory ... args) {
        String name;
        ParameterEntity[] parameters = null;
        if (args[0].isClosure()) {
            ClosureEntity tmp = (ClosureEntity)args[0].toValue(ObjectMemory.class).getReflection();
            parameters = tmp.parameters;
        } else if (args[0].isArray()) {
            Invoker invoker = Invoker.valueOf(env, null, args[0]);
            if (invoker == null) {
                this.exception(env, "%s does not exists", args[0].toString());
                return Memory.NULL;
            }
            parameters = invoker.getParameters();
        } else {
            name = args[0].toString();
            if (name.contains("::")) {
                Invoker invoker = Invoker.valueOf(env, null, args[0]);
                if (invoker == null) {
                    this.exception(env, "%s does not exists", args[0].toString());
                    return Memory.NULL;
                }
                parameters = invoker.getParameters();
            } else {
                FunctionEntity tmp = env.fetchFunction(name);
                this.functionEntity = tmp;
                if (tmp == null) {
                    this.exception(env, "Function %s does not exist", args[0].toString());
                    return Memory.NULL;
                }
                if (tmp.isInternal()) {
                    this.exception(env, "%s(): ReflectionParameter does not support internal functions", tmp.getName());
                    return Memory.NULL;
                }
                parameters = tmp.getParameters();
            }
        }
        this.entity = null;
        name = args[1].toString();
        if (parameters != null) {
            if (args[1].isNumber()) {
                int index = args[1].toInteger();
                if (index >= 0 && index < parameters.length) {
                    this.entity = parameters[index];
                    this.position = index;
                }
            } else {
                int i = 0;
                for (ParameterEntity e : parameters) {
                    if (e.getName().equals(name)) {
                        this.entity = e;
                        this.position = i;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (this.entity == null) {
            this.exception(env, "Parameter %s does not exist", name);
        }
        this.setEntity(this.entity);
        return Memory.NULL;
    }

    public void setEntity(ParameterEntity entity) {
        this.entity = entity;
        this.getProperties().put("name", new StringMemory(entity.getName()));
    }

    public void setFunctionEntity(AbstractFunctionEntity functionEntity) {
        this.functionEntity = functionEntity;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Reflection.Signature
    public Memory allowsNull(Environment env, Memory ... args) {
        return this.entity.isNullableOrDefaultNull() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory hasType(Environment env, Memory ... args) {
        TypeChecker typeChecker = this.entity.getTypeChecker();
        return typeChecker != null ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory getType(Environment env, Memory ... args) {
        TypeChecker typeChecker = this.entity.getTypeChecker();
        if (typeChecker == null) {
            return Memory.NULL;
        }
        return ObjectMemory.valueOf(new ReflectionType(env, typeChecker.getSignature(), this.entity.isNullableOrDefaultNull(), typeChecker.isBuiltin()));
    }

    @Reflection.Signature
    public Memory canBePassedByValue(Environment env, Memory ... args) {
        return this.entity.canBePassedByValue() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory getDefaultValue(Environment env, Memory ... args) {
        if (this.entity.getDefaultValue() == null) {
            this.exception(env, "Parameter has no default value", new Object[0]);
            return Memory.NULL;
        }
        return this.entity.getDefaultValue().toImmutable(env, env.trace());
    }

    @Reflection.Signature
    public Memory getDefaultValueConstantName(Environment env, Memory ... args) {
        if (this.entity.getDefaultValueConstName() == null) {
            return Memory.FALSE;
        }
        return new StringMemory(this.entity.getDefaultValueConstName());
    }

    @Reflection.Signature
    public Memory getName(Environment env, Memory ... args) {
        return new StringMemory(this.entity.getName());
    }

    @Reflection.Signature
    public Memory getPosition(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.position);
    }

    @Reflection.Signature
    public Memory isArray(Environment env, Memory ... args) {
        return this.entity.getType() == HintType.ARRAY ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isCallable(Environment env, Memory ... args) {
        return this.entity.getType() == HintType.CALLABLE ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isString(Environment env, Memory ... args) {
        return this.entity.getType() == HintType.STRING ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isBoolean(Environment env, Memory ... args) {
        return this.entity.getType() == HintType.BOOLEAN ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isNumber(Environment env, Memory ... args) {
        return this.entity.getType() == HintType.NUMBER ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isInteger(Environment env, Memory ... args) {
        return this.entity.getType() == HintType.INT ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isDouble(Environment env, Memory ... args) {
        return this.entity.getType() == HintType.DOUBLE ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isObject(Environment env, Memory ... args) {
        return this.entity.getType() == HintType.OBJECT ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory getHintType(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.entity.getType().ordinal());
    }

    @Reflection.Signature
    public Memory isDefaultValueAvailable(Environment env, Memory ... args) {
        return this.entity.getDefaultValue() != null ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isDefaultValueConstant(Environment env, Memory ... args) {
        return this.entity.getDefaultValue() instanceof ConstantMemory || this.entity.getDefaultValue() instanceof ClassConstantMemory ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isOptional(Environment env, Memory ... args) {
        return this.entity.isOptional() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isPassedByReference(Environment env, Memory ... args) {
        return this.entity.isPassedByReference() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    @Reflection.Name(value="getClass")
    public Memory _getClass(Environment env, Memory ... args) {
        if (this.entity.getTypeClass() == null) {
            return Memory.NULL;
        }
        ClassEntity entity = env.fetchClass(this.entity.getTypeClass(), this.entity.getTypeClassLower(), true);
        if (entity == null) {
            return Memory.NULL;
        }
        ClassEntity classEntity = env.fetchClass("ReflectionClass");
        ReflectionClass r = new ReflectionClass(env, classEntity);
        r.setEntity(entity);
        return new ObjectMemory(r);
    }

    @Reflection.Signature
    public Memory getDeclaringClass(Environment env, Memory ... args) {
        if (this.functionEntity == null) {
            return Memory.NULL;
        }
        if (this.functionEntity instanceof FunctionEntity) {
            return Memory.NULL;
        }
        MethodEntity method = (MethodEntity)this.functionEntity;
        ClassEntity classEntity = env.fetchClass("ReflectionClass");
        ReflectionClass r = new ReflectionClass(env, classEntity);
        r.setEntity(method.getClazz());
        return new ObjectMemory(r);
    }

    @Reflection.Signature
    public Memory getDeclaringFunction(Environment env, Memory ... args) throws Throwable {
        if (this.cachedFunction != null) {
            return this.cachedFunction;
        }
        if (this.functionEntity == null) {
            return Memory.NULL;
        }
        if (this.functionEntity instanceof FunctionEntity) {
            ClassEntity classEntity = env.fetchClass("ReflectionFunction");
            ReflectionFunction e = new ReflectionFunction(env, classEntity);
            e.setFunctionEntity((FunctionEntity)this.functionEntity);
            this.cachedFunction = new ObjectMemory(e);
            return this.cachedFunction;
        }
        ClassEntity classEntity = env.fetchClass("ReflectionMethod");
        ReflectionMethod e = new ReflectionMethod(env, classEntity);
        e.setEntity((MethodEntity)this.functionEntity);
        this.cachedFunction = new ObjectMemory(e);
        return this.cachedFunction;
    }
}

