/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.support.compile;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.ext.support.compile.CompileFunction;
import php.runtime.ext.support.compile.CompileFunctionSpec;
import php.runtime.invoke.Invoker;
import php.runtime.memory.ObjectMemory;

public abstract class FunctionsContainer {
    protected static boolean expectingReference(Environment env, TraceInfo trace, Memory memory, String funcName) {
        if (!memory.isReference()) {
            env.error(trace, (funcName == null ? "" : funcName + "() - ") + "Only variables can be passed by reference", new Object[0]);
            return false;
        }
        return true;
    }

    @Deprecated
    protected static boolean expectingReference(Environment env, TraceInfo trace, Memory memory) {
        return FunctionsContainer.expectingReference(env, trace, memory, null);
    }

    protected static boolean expecting(Environment env, TraceInfo trace, int index, Memory memory, Memory.Type type) {
        if (memory.getRealType() != type) {
            env.warning(trace, "expects parameter " + index + " to be " + type.toString() + ", " + memory.getRealType().toString() + " given", new Object[0]);
            return false;
        }
        return true;
    }

    protected static boolean expectingImplement(Environment env, TraceInfo trace, int index, Memory memory, Class<?> clazz) {
        if (!memory.isObject() || !memory.toValue(ObjectMemory.class).getClass().isAssignableFrom(clazz)) {
            String given = memory.getRealType().toString();
            if (memory.isObject()) {
                given = memory.toValue(ObjectMemory.class).getReflection().getName();
            }
            env.warning(trace, "expects parameter " + index + " must implement " + (clazz.isInterface() ? "interface " : "") + clazz.getSimpleName() + ", " + given + " given", new Object[0]);
            return false;
        }
        return true;
    }

    protected static Invoker expectingCallback(Environment env, TraceInfo trace, int index, Memory memory) {
        Invoker invoker = Invoker.create(env, memory);
        if (invoker == null) {
            env.warning(trace, "expects parameter " + index + " to be valid callback", new Object[0]);
            return null;
        }
        if (invoker.canAccess(env) != 0) {
            env.warning(trace, "expects parameter " + index + " to be valid callback, cannot access", new Object[0]);
            return null;
        }
        return invoker;
    }

    protected Map<String, Method> getNativeFunctions() {
        return new HashMap<String, Method>();
    }

    protected Method getNative(Class clazz, String name, Class<?> ... argumentTypes) {
        try {
            return clazz.getDeclaredMethod(name, argumentTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<CompileFunctionSpec> getFunctionSpecs() {
        HashMap<String, CompileFunctionSpec> result = new HashMap<String, CompileFunctionSpec>();
        for (Method method : this.getClass().getDeclaredMethods()) {
            CompileFunctionSpec function;
            int mod = method.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            String name = method.getName();
            Reflection.Name altName = method.getAnnotation(Reflection.Name.class);
            if (altName != null) {
                name = altName.value();
            }
            if ((function = (CompileFunctionSpec)result.get(name)) == null) {
                function = new CompileFunctionSpec(name);
                result.put(name, function);
            }
            function.addMethod(method);
        }
        for (Map.Entry entry : this.getNativeFunctions().entrySet()) {
            Method method = (Method)entry.getValue();
            CompileFunctionSpec function = new CompileFunctionSpec((String)entry.getKey(), true);
            result.put((String)entry.getKey(), function);
            function.addMethod(method);
        }
        return result.values();
    }

    public Collection<CompileFunction> getFunctions() {
        HashMap<String, CompileFunction> result = new HashMap<String, CompileFunction>();
        for (Method method : this.getClass().getDeclaredMethods()) {
            CompileFunction function;
            int mod = method.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            String name = method.getName();
            Reflection.Name altName = method.getAnnotation(Reflection.Name.class);
            if (altName != null) {
                name = altName.value();
            }
            if ((function = (CompileFunction)result.get(name)) == null) {
                function = new CompileFunction(name);
                result.put(name, function);
            }
            function.addMethod(method);
        }
        for (Map.Entry entry : this.getNativeFunctions().entrySet()) {
            Method method = (Method)entry.getValue();
            CompileFunction function = (CompileFunction)result.get(entry.getKey());
            if (function == null) {
                function = new CompileFunction((String)entry.getKey());
                result.put((String)entry.getKey(), function);
            }
            function.addMethod(method, true);
        }
        return result.values();
    }
}

