/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.compile;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ServiceLoader;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import php.runtime.Memory;
import php.runtime.common.Callback;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.ext.core.classes.WrapClassLoader;
import php.runtime.ext.core.classes.lib.FsUtils;
import php.runtime.ext.support.Extension;
import php.runtime.launcher.LaunchException;
import php.runtime.launcher.StandaloneLauncher;
import php.runtime.loader.dump.ModuleDumper;
import php.runtime.loader.dump.StandaloneLibraryDumper;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.helper.GeneratorEntity;
import php.runtime.reflection.support.ReflectionUtils;

public class StandaloneCompiler {
    private final Environment env;
    private File sourceDirectory;
    private boolean debug = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String[] list;
        Environment env = new Environment();
        String opt = null;
        if (args == null || args.length < 2) {
            System.err.println("ERROR: Pass arguments (--src, --dest, --dest-res).");
            System.exit(1);
        }
        File sourceDirectory = null;
        File destinationDirectory = null;
        File destinationResDirectory = null;
        block15: for (String arg : args) {
            if (arg.startsWith("--")) {
                opt = arg.substring(2);
                continue;
            }
            if (opt == null) continue;
            switch (opt) {
                case "src": {
                    sourceDirectory = new File(arg);
                    continue block15;
                }
                case "dest": {
                    destinationDirectory = new File(arg);
                    continue block15;
                }
                case "dest-res": {
                    destinationResDirectory = new File(arg);
                    continue block15;
                }
                default: {
                    System.err.println("Unknown option - " + opt);
                    System.exit(1);
                }
            }
        }
        if (sourceDirectory == null) {
            System.err.println("ERROR: Pass a source directory (--src opt).");
            System.exit(1);
        }
        if (destinationDirectory == null) {
            System.err.println("ERROR: Pass a destination directory (--dest opt).");
            System.exit(1);
        }
        File jarFile = null;
        if (destinationDirectory.getName().endsWith(".jar")) {
            jarFile = destinationDirectory;
            destinationDirectory = new File(destinationDirectory.getPath() + ".temp");
        }
        if (!destinationDirectory.isDirectory() && !destinationDirectory.mkdirs()) {
            System.err.println("ERROR: Failed to create destination directory: " + destinationDirectory);
            System.exit(2);
        }
        if (destinationResDirectory != null && !destinationResDirectory.isDirectory() && !destinationResDirectory.mkdirs()) {
            System.err.println("ERROR: Failed to create destination res directory: " + destinationDirectory);
            System.exit(2);
        }
        if ((list = destinationDirectory.list()) == null || list.length > 0) {
            if (jarFile != null) {
                FsUtils.clean(env, destinationDirectory.getPath());
            } else {
                System.err.println("ERROR: Destination directory must be empty.");
                System.exit(2);
            }
        }
        long time = System.currentTimeMillis();
        System.out.println("Start compiling...\n -> src: " + sourceDirectory + "\n -> dest: " + destinationDirectory + "\n -> dest-res: " + destinationResDirectory + "\n");
        try {
            StandaloneCompiler compiler = new StandaloneCompiler(sourceDirectory, env);
            if (destinationResDirectory != null) {
                FsUtils.clean(env, destinationResDirectory.getPath());
            }
            compiler.compile(destinationDirectory, destinationResDirectory);
            if (jarFile != null) {
                try {
                    compiler.compileJar(jarFile, destinationDirectory, StandaloneLauncher.class.getName());
                }
                finally {
                    FsUtils.clean(env, destinationDirectory.getPath());
                    FsUtils.delete(destinationDirectory.getPath());
                }
            }
            System.out.println("\nCompiling is SUCCESSFUL, time = " + (System.currentTimeMillis() - time) + "ms.");
        }
        catch (Throwable e) {
            System.err.println("\nCompiling is FAILED, error: " + e.getMessage());
            System.exit(3);
        }
    }

    public StandaloneCompiler(File sourceDirectory, Environment env) {
        this.env = env;
        if (sourceDirectory == null) {
            throw new NullPointerException("sourceDirectory is null");
        }
        this.sourceDirectory = sourceDirectory;
        this.loadExtensions();
    }

    private void loadExtensions() {
        ServiceLoader<Extension> loader = ServiceLoader.load(Extension.class);
        for (Extension extension : loader) {
            this.env.scope.registerExtension(extension);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void saveJavaClass(File file, byte[] data) throws IOException {
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.isDirectory()) {
            parentFile.mkdirs();
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            outputStream.write(data);
        }
    }

    private void saveModuleClasses(ModuleEntity entity, File destinationDirectory, File destinationResDirectory) throws IOException {
        this.saveJavaClass(new File(destinationDirectory, "/" + entity.getInternalName() + ".class"), entity.getData());
        Context _context = entity.getContext();
        String moduleName = this.sourceDirectory.toPath().relativize(Paths.get(_context.getModuleName(), new String[0])).toString().replace('\\', '/');
        Context context = new Context(new ByteArrayInputStream(new byte[0]), moduleName, this.env.getDefaultCharset());
        entity.setContext(context);
        entity.setName(moduleName);
        for (ClassEntity classEntity : entity.getClasses()) {
            this.saveJavaClass(new File(destinationDirectory, "/" + classEntity.getInternalName() + ".class"), classEntity.getData());
        }
        for (FunctionEntity functionEntity : entity.getFunctions()) {
            this.saveJavaClass(new File(destinationDirectory, "/" + functionEntity.getInternalName() + ".class"), functionEntity.getData());
        }
        for (ClosureEntity closureEntity : entity.getClosures()) {
            this.saveJavaClass(new File(destinationDirectory, "/" + closureEntity.getInternalName() + ".class"), closureEntity.getData());
        }
        for (GeneratorEntity generatorEntity : entity.getGenerators()) {
            this.saveJavaClass(new File(destinationDirectory, "/" + generatorEntity.getInternalName() + ".class"), generatorEntity.getData());
        }
        ModuleDumper dumper = new ModuleDumper(context, this.env, this.debug);
        dumper.setIncludeData(false);
        dumper.save(entity, new File(destinationResDirectory, "/" + entity.getInternalName() + ".dump"));
    }

    private ModuleEntity compileFile(File path, File destinationDirectory, File destinationResDirectory) {
        try {
            ModuleEntity entity = this.env.getModuleManager().fetchModule(path.getPath());
            this.saveModuleClasses(entity, destinationDirectory, destinationResDirectory);
            return entity;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void compileJar(File jarFile, File destinationDirectory) throws IOException, InterruptedException {
        this.compileJar(jarFile, destinationDirectory, null);
    }

    public void compileJar(File jarFile, final File destinationDirectory, String mainClassName) throws IOException, InterruptedException {
        Manifest manifest = null;
        if (mainClassName != null) {
            manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_TITLE, "JPHP Compiler");
            manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_VENDOR, "JPHP");
            manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_VERSION, "0.9.0");
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClassName);
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, "jphp-runtime.jar");
        }
        try (FileOutputStream outputStream = new FileOutputStream(jarFile);){
            final JarOutputStream jarOutputStream = manifest != null ? new JarOutputStream((OutputStream)outputStream, manifest) : new JarOutputStream(outputStream);
            try {
                StandaloneCompiler.scan(destinationDirectory, new Callback<Boolean, File>(){

                    @Override
                    public Boolean call(File file) {
                        block17: {
                            Path relPath = destinationDirectory.toPath().relativize(file.toPath());
                            String name = relPath.toString().replace('\\', '/');
                            try {
                                if (file.isFile()) {
                                    JarEntry jarEntry = new JarEntry(name);
                                    jarEntry.setTime(file.lastModified());
                                    jarOutputStream.putNextEntry(jarEntry);
                                    try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                                        int count;
                                        byte[] buffer = new byte[32768];
                                        while ((count = in.read(buffer)) != -1) {
                                            jarOutputStream.write(buffer, 0, count);
                                        }
                                        jarOutputStream.closeEntry();
                                        break block17;
                                    }
                                }
                                if (file.isDirectory()) {
                                    JarEntry jarEntry = new JarEntry(name);
                                    jarEntry.setTime(file.lastModified());
                                    jarOutputStream.putNextEntry(jarEntry);
                                    jarOutputStream.closeEntry();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        return false;
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            jarOutputStream.close();
        }
    }

    public void compile(File destinationDirectory) {
        this.compile(destinationDirectory, null);
    }

    public void compile(final File destinationDirectory, File destinationResDirectory) {
        String classLoader;
        final StandaloneLibraryDumper dumper = new StandaloneLibraryDumper();
        if (destinationResDirectory == null) {
            destinationResDirectory = destinationDirectory;
        }
        if ((classLoader = ReflectionUtils.getClassName(WrapClassLoader.WrapLauncherClassLoader.class)) != null && !classLoader.isEmpty()) {
            ClassEntity classLoaderEntity = this.env.fetchClass(classLoader);
            if (classLoaderEntity == null) {
                throw new LaunchException("Class loader class is not found: " + classLoader);
            }
            try {
                WrapClassLoader loader = (WrapClassLoader)classLoaderEntity.newObject(this.env, TraceInfo.UNKNOWN, true, new Memory[0]);
                this.env.invokeMethod(loader, "register", Memory.TRUE);
            }
            catch (Throwable e) {
                throw new CriticalException(e);
            }
        }
        try {
            final File finalDestinationResDirectory = destinationResDirectory;
            StandaloneCompiler.scan(this.sourceDirectory, new Callback<Boolean, File>(){

                @Override
                public Boolean call(File file) {
                    String ext;
                    if (file.isFile() && (ext = FsUtils.ext(file.getPath())) != null) {
                        switch (ext) {
                            case "php": 
                            case "phb": {
                                System.out.println("Compile: " + file);
                                dumper.addModule(StandaloneCompiler.this.compileFile(file, destinationDirectory, finalDestinationResDirectory));
                                break;
                            }
                            default: {
                                Path path = Paths.get(StandaloneCompiler.this.sourceDirectory.getPath(), new String[0]);
                                Path relPath = path.relativize(file.toPath());
                                try {
                                    System.out.println("Copy: " + file);
                                    Path target = Paths.get(finalDestinationResDirectory.getPath(), "/", relPath.toString());
                                    target.toFile().getParentFile().mkdirs();
                                    Path path2 = Files.copy(file.toPath(), target, new CopyOption[0]);
                                    break;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    return false;
                }
            });
        }
        catch (InterruptedException finalDestinationResDirectory) {
            // empty catch block
        }
        File file = new File(destinationResDirectory, "/JPHP-INF/library.dump");
        file.getParentFile().mkdirs();
        try (FileOutputStream output = new FileOutputStream(file);){
            dumper.save(output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void scan(File sourceDirectory, Callback<Boolean, File> callback) throws InterruptedException {
        File[] files = sourceDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                Boolean result = callback.call(file);
                if (result != null && result.booleanValue()) {
                    throw new InterruptedException();
                }
                if (!file.isDirectory()) continue;
                StandaloneCompiler.scan(file, callback);
            }
        }
    }
}

