/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.output.serialization;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.lang.spl.Serializable;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.PropertyEntity;

public class Serializer {
    protected final Environment env;
    protected final StringBuilder printer;
    protected final TraceInfo trace;

    public Serializer(Environment env, TraceInfo trace, StringBuilder writer) {
        this.env = env;
        this.trace = trace;
        this.printer = writer;
    }

    public void write(Memory memory) {
        switch (memory.type) {
            case NULL: {
                this.writeNull();
                break;
            }
            case BOOL: {
                this.writeBoolean(memory);
                break;
            }
            case INT: {
                this.writeLong((LongMemory)memory);
                break;
            }
            case DOUBLE: {
                this.writeDouble((DoubleMemory)memory);
                break;
            }
            case STRING: {
                this.writeString((StringMemory)memory);
                break;
            }
            case ARRAY: {
                this.writeArray((ArrayMemory)memory);
                break;
            }
            case OBJECT: {
                this.writeObject((ObjectMemory)memory, new HashSet<Integer>());
                break;
            }
            case REFERENCE: {
                if (!memory.isShortcut()) {
                    this.write(memory.toValue());
                    break;
                }
                this.writeNull();
            }
        }
    }

    public void writeNull() {
        this.printer.append("N;");
    }

    public void writeLong(LongMemory memory) {
        this.printer.append("i:");
        this.printer.append(memory.toString());
        this.printer.append(";");
    }

    public void writeDouble(DoubleMemory memory) {
        this.printer.append("d:");
        this.printer.append(memory.toString());
        this.printer.append(";");
    }

    public void writeBoolean(Memory memory) {
        this.printer.append("b:").append(memory.toBoolean() ? "1" : "0").append(";");
    }

    public void writeString(StringMemory memory) {
        String value = memory.toString();
        this.printer.append("s:").append(value.length()).append(":\"").append(value).append("\";");
    }

    public void writeArray(ArrayMemory memory) {
        this.writeArray(memory, new HashSet<Integer>(), true);
    }

    public void writeArray(ArrayMemory memory, Set<Integer> used, boolean appendType) {
        if (used.add(memory.getPointer())) {
            if (appendType) {
                this.printer.append("a:");
            }
            this.printer.append(String.valueOf(memory.size())).append(":{");
            ForeachIterator iterator = memory.foreachIterator(false, false);
            while (iterator.next()) {
                Memory key = iterator.getMemoryKey();
                this.write(key);
                if (iterator.getValue().isReference()) {
                    this.writeNull();
                    continue;
                }
                this.write(iterator.getValue());
            }
            this.printer.append("}");
            used.remove(memory.getPointer());
        } else {
            this.writeNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(ObjectMemory memory, Set<Integer> used) {
        if (used.add(memory.getPointer())) {
            IObject object = memory.value;
            ClassEntity reflection = object.getReflection();
            if (object instanceof Serializable) {
                this.env.pushCall(this.trace, object, "serialize", new Memory[0]);
                try {
                    Memory result = ((Serializable)object).serialize(this.env, new Memory[0]);
                    if (result.isNull()) {
                        this.writeNull();
                        return;
                    }
                    if (result.isString()) {
                        String value = result.toString();
                        this.printer.append("C:").append(reflection.getName().length()).append(":\"").append(reflection.getName()).append("\":").append(value.length()).append(":{").append(value).append("}");
                        return;
                    }
                    this.env.exception(this.trace, reflection.getName() + "::serialize() must return a string or NULL", new Object[0]);
                }
                finally {
                    this.env.popCall();
                }
            }
            ArrayMemory only = null;
            if (reflection.methodMagicSleep != null) {
                this.env.pushCall(this.trace, object, reflection.methodMagicSleep.getName(), new Memory[0]);
                try {
                    Memory result = reflection.methodMagicSleep.invokeDynamic(object, this.env, this.trace, new Memory[0]);
                    if (!result.isArray()) {
                        this.env.error(ErrorType.E_NOTICE, "serialize(): __sleep() should return an array only containing the names of instance-variables to serialize", new Object[0]);
                        this.writeNull();
                        return;
                    }
                    ForeachIterator iterator = result.getNewIterator(this.env, false, false);
                    only = new ArrayMemory(true);
                    ArrayMemory props = memory.getProperties();
                    LinkedHashSet<String> need = new LinkedHashSet<String>();
                    while (iterator.next()) {
                        if (iterator.getValue().isNumber()) continue;
                        need.add(iterator.getValue().toString());
                    }
                    for (PropertyEntity e : reflection.getProperties()) {
                        if (!need.contains(e.getName())) continue;
                        props.refOfIndex(e.getSpecificName());
                    }
                    iterator = result.getNewIterator(this.env, false, false);
                    while (iterator.next()) {
                        Memory value = iterator.getValue().toValue();
                        PropertyEntity entity = reflection.findProperty(value.toString());
                        Memory memory2 = value = entity == null ? props.valueOfIndex(value).toValue() : props.valueOfIndex(entity.getSpecificName()).toValue();
                        if (value == Memory.UNDEFINED) {
                            this.env.error(this.trace, ErrorType.E_NOTICE, "serialize(): \"%s\" returned as member variable from __sleep() but does not exist", iterator.getValue().toString());
                        }
                        if (entity != null) {
                            only.put(entity.getSpecificName(), value);
                            continue;
                        }
                        only.refOfIndex(iterator.getValue()).assign(value);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                finally {
                    this.env.popCall();
                }
            }
            this.printer.append("O:");
            this.printer.append(String.valueOf(reflection.getName().length()));
            this.printer.append(":\"");
            this.printer.append(reflection.getName());
            this.printer.append("\":");
            if (reflection.getProperties() == null) {
                this.writeArray(new ArrayMemory(), used, false);
            } else {
                this.writeArray(only == null ? object.getProperties() : only, used, false);
            }
        } else {
            this.writeNull();
        }
    }
}

