/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.env.Context;
import php.runtime.env.DieException;
import php.runtime.env.Environment;
import php.runtime.exceptions.support.ErrorException;
import php.runtime.memory.ArrayMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.helper.GeneratorEntity;
import php.runtime.reflection.support.Entity;

public class ModuleEntity
extends Entity {
    private int id;
    private Class<?> nativeClazz;
    protected Method nativeMethod;
    private boolean strictTypes = false;
    private final Map<String, ClassEntity> classes = new LinkedHashMap<String, ClassEntity>();
    private final List<FunctionEntity> functions = new ArrayList<FunctionEntity>();
    private final Map<String, ConstantEntity> constants = new LinkedHashMap<String, ConstantEntity>();
    private final List<ClosureEntity> closures = new ArrayList<ClosureEntity>();
    private final List<GeneratorEntity> generators = new ArrayList<GeneratorEntity>();
    protected boolean isLoaded;
    private static final Memory[] argsMock = new Memory[0];

    public ModuleEntity(Context context) {
        super(context);
        this.setName(context.getModuleNameNoThrow());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Method getNativeMethod() {
        return this.nativeMethod;
    }

    public void setNativeMethod(Method nativeMethod) {
        this.nativeMethod = nativeMethod;
    }

    public Memory include(Environment env, ArrayMemory locals) throws Throwable {
        try {
            return (Memory)this.nativeMethod.invoke(null, env, argsMock, locals);
        }
        catch (InvocationTargetException e) {
            return env.__throwException(e);
        }
    }

    public Memory include(Environment env) throws Throwable {
        try {
            return (Memory)this.nativeMethod.invoke(null, env, argsMock, env.getGlobals());
        }
        catch (InvocationTargetException e) {
            return env.__throwException(e);
        }
    }

    public Memory includeNoThrow(Environment env, ArrayMemory locals) {
        try {
            return this.include(env, locals);
        }
        catch (DieException | ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            env.catchUncaught(e);
            return Memory.NULL;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public Memory includeNoThrow(Environment env) {
        return this.includeNoThrow(env, env.getGlobals());
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    public Collection<ConstantEntity> getConstants() {
        return this.constants.values();
    }

    public Collection<ClassEntity> getClasses() {
        return this.classes.values();
    }

    public Collection<ClosureEntity> getClosures() {
        return this.closures;
    }

    public Collection<GeneratorEntity> getGenerators() {
        return this.generators;
    }

    public Collection<FunctionEntity> getFunctions() {
        return this.functions;
    }

    public ClassEntity findClass(String name) {
        return this.classes.get(name.toLowerCase());
    }

    public FunctionEntity findFunction(int index) {
        if (index >= 0 && index < this.functions.size()) {
            return this.functions.get(index);
        }
        return null;
    }

    public ConstantEntity findConstant(String name) {
        return this.constants.get(name.toLowerCase());
    }

    public ClosureEntity findClosure(int index) {
        if (index >= 0 && index < this.closures.size()) {
            return this.closures.get(index);
        }
        return null;
    }

    public GeneratorEntity findGenerator(int index) {
        if (index >= 0 && index < this.generators.size()) {
            return this.generators.get(index);
        }
        return null;
    }

    public void addConstant(ConstantEntity constant) {
        if (!this.constants.containsKey(constant.getName())) {
            this.constants.put(constant.getName(), constant);
        }
    }

    public void addClosure(ClosureEntity closure) {
        this.closures.add(closure);
        if (closure.getGeneratorEntity() != null) {
            this.addGenerator(closure.getGeneratorEntity());
        }
    }

    public void addGenerator(GeneratorEntity generator) {
        this.generators.add(generator);
    }

    public void addClass(ClassEntity clazz) {
        this.classes.put(clazz.getLowerName(), clazz);
        for (MethodEntity entity : clazz.getOwnedMethods()) {
            if (entity.getGeneratorEntity() == null) continue;
            this.addGenerator(entity.getGeneratorEntity());
        }
    }

    public void addFunction(FunctionEntity function) {
        this.functions.add(function);
        if (function.getGeneratorEntity() != null) {
            this.addGenerator(function.getGeneratorEntity());
        }
    }

    public Class<?> getNativeClazz() {
        return this.nativeClazz;
    }

    public void setNativeClazz(Class<?> nativeClazz) {
        this.nativeClazz = nativeClazz;
    }

    public boolean isStrictTypes() {
        return this.strictTypes;
    }

    public void setStrictTypes(boolean strictTypes) {
        this.strictTypes = strictTypes;
    }
}

