/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection.support;

import java.lang.reflect.Field;
import php.runtime.Memory;
import php.runtime.common.HintType;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseWrapper;
import php.runtime.lang.IObject;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.support.ReflectionUtils;

public abstract class TypeChecker {
    public abstract String getSignature();

    public abstract String getHumanString();

    public abstract boolean check(Environment var1, Memory var2, boolean var3, String var4);

    public abstract Memory apply(Environment var1, Memory var2, boolean var3, boolean var4);

    public boolean isBuiltin() {
        return false;
    }

    public static TypeChecker of(HintType type) {
        return new Simple(type);
    }

    public static TypeChecker of(String className) {
        return new ClassName(className);
    }

    public static TypeChecker of(Class<?> typeNativeClass) {
        return new NativeClass(typeNativeClass);
    }

    public static TypeChecker ofEnum(Class<? extends Enum> enumClass) {
        return new EnumClass(enumClass);
    }

    public static class EnumClass
    extends TypeChecker {
        protected Class<? extends Enum> typeEnum;

        public EnumClass(Class<? extends Enum> typeEnum) {
            this.typeEnum = typeEnum;
        }

        public Class<? extends Enum> getTypeEnum() {
            return this.typeEnum;
        }

        @Override
        public String getSignature() {
            return null;
        }

        @Override
        public String getHumanString() {
            Field[] fields = this.getTypeEnum().getFields();
            Object[] names = new String[fields.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = fields[i].getName();
            }
            return "one of range [" + StringUtils.join(names, ", ") + "] as string";
        }

        @Override
        public boolean check(Environment env, Memory value, boolean nullable, String staticClassName) {
            try {
                if (nullable && value.isNull()) {
                    return true;
                }
                Enum.valueOf(this.typeEnum, value.toString());
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        @Override
        public Memory apply(Environment env, Memory value, boolean nullable, boolean strict) {
            return null;
        }
    }

    public static class NativeClass
    extends TypeChecker {
        protected Class<?> typeNativeClass;

        public NativeClass(Class<?> typeNativeClass) {
            this.typeNativeClass = typeNativeClass;
        }

        @Override
        public String getSignature() {
            return ReflectionUtils.getClassName(this.typeNativeClass);
        }

        @Override
        public String getHumanString() {
            return "an instance of " + ReflectionUtils.getClassName(this.typeNativeClass);
        }

        @Override
        public boolean check(Environment env, Memory value, boolean nullable, String staticClassName) {
            if (nullable && value.isNull()) {
                return true;
            }
            if (value.isObject()) {
                IObject object = value.toObject(IObject.class);
                if (object instanceof BaseWrapper) {
                    return this.typeNativeClass.isAssignableFrom(((BaseWrapper)object).getWrappedObject().getClass());
                }
                return false;
            }
            return false;
        }

        @Override
        public Memory apply(Environment env, Memory value, boolean nullable, boolean strict) {
            return null;
        }
    }

    public static class ClassName
    extends TypeChecker {
        protected String typeClass;
        protected String typeClassLower;

        public ClassName(String typeClass) {
            this.typeClass = typeClass;
            this.typeClassLower = typeClass.toLowerCase();
        }

        public String getTypeClass() {
            return this.typeClass;
        }

        public String getTypeClassLower() {
            return this.typeClassLower;
        }

        @Override
        public String getSignature() {
            return this.typeClass;
        }

        @Override
        public String getHumanString() {
            return "an instance of " + this.getTypeClass();
        }

        @Override
        public boolean check(Environment env, Memory value, boolean nullable, String staticClassName) {
            if (nullable && value.isNull()) {
                return true;
            }
            if (!value.isObject()) {
                return false;
            }
            ObjectMemory object = value.toValue(ObjectMemory.class);
            ClassEntity oEntity = object.getReflection();
            return oEntity.isInstanceOfLower(this.typeClassLower);
        }

        @Override
        public Memory apply(Environment env, Memory value, boolean nullable, boolean strict) {
            return null;
        }
    }

    public static class Simple
    extends TypeChecker {
        protected HintType type;

        public Simple(HintType type) {
            this.type = type;
        }

        public HintType getType() {
            return this.type;
        }

        @Override
        public String getSignature() {
            return this.type.toString();
        }

        @Override
        public String getHumanString() {
            return "the type " + this.type.toString();
        }

        @Override
        public boolean isBuiltin() {
            return this.type != HintType.SELF;
        }

        @Override
        public Memory apply(Environment env, Memory value, boolean nullable, boolean strict) {
            if (nullable && value.isNull()) {
                return value;
            }
            if (strict) {
                switch (this.type) {
                    case DOUBLE: {
                        if (!value.isNumber()) break;
                        return DoubleMemory.valueOf(value.toDouble());
                    }
                }
                return null;
            }
            switch (this.type) {
                case INT: {
                    return LongMemory.valueOf(value.toLong());
                }
                case STRING: {
                    return StringMemory.valueOf(value.toString());
                }
                case BOOLEAN: {
                    return TrueMemory.valueOf(value.toBoolean());
                }
                case DOUBLE: {
                    return DoubleMemory.valueOf(value.toDouble());
                }
            }
            return null;
        }

        @Override
        public boolean check(Environment env, Memory value, boolean nullable, String staticClassName) {
            if (this.type == HintType.VOID) {
                return true;
            }
            if (nullable && value.isNull()) {
                return true;
            }
            switch (this.type) {
                case OBJECT: {
                    return value.isObject();
                }
                case NUMBER: {
                    return value.isNumber();
                }
                case DOUBLE: {
                    return value.getRealType() == Memory.Type.DOUBLE;
                }
                case INT: {
                    return value.getRealType() == Memory.Type.INT;
                }
                case STRING: {
                    return value.isString();
                }
                case BOOLEAN: {
                    return value.getRealType() == Memory.Type.BOOL;
                }
                case ARRAY: {
                    return value.isArray();
                }
                case TRAVERSABLE: {
                    return value.isTraversable();
                }
                case ITERABLE: {
                    return value.isTraversable();
                }
                case CALLABLE: {
                    Invoker invoker = Invoker.valueOf(env, null, value);
                    return invoker != null && invoker.canAccess(env) == 0;
                }
                case SELF: {
                    if (!value.isObject()) {
                        return false;
                    }
                    if (staticClassName == null) {
                        Memory memory = env.__getMacroClass();
                        String string = staticClassName = memory.isNull() ? null : memory.toString();
                    }
                    if (staticClassName != null) {
                        return value.toValue(ObjectMemory.class).getReflection().isInstanceOf(staticClassName);
                    }
                    return true;
                }
            }
            return true;
        }
    }
}

