/*
 * Decompiled with CFR 0.152.
 */
package php.runtime;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import php.runtime.OperatorUtils;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseWrapper;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.lang.StdClass;
import php.runtime.lang.exception.BaseArithmeticError;
import php.runtime.lang.exception.BaseDivisionByZeroError;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.FalseMemory;
import php.runtime.memory.KeyValueMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.NullMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.memory.helper.UndefinedMemory;
import php.runtime.memory.helper.VariadicMemory;
import php.runtime.memory.support.MemoryOperation;
import php.runtime.reflection.support.ReflectionUtils;

public abstract class Memory
implements Comparable<Memory> {
    public final Type type;
    public static final Memory NULL = NullMemory.INSTANCE;
    public static final Memory UNDEFINED = UndefinedMemory.INSTANCE;
    public static final Memory FALSE = FalseMemory.INSTANCE;
    public static final Memory TRUE = TrueMemory.INSTANCE;
    public static final Memory CONST_INT_0 = new LongMemory(0L);
    public static final Memory CONST_INT_M1 = new LongMemory(-1L);
    public static final Memory CONST_INT_1 = new LongMemory(1L);
    public static final Memory CONST_INT_2 = new LongMemory(2L);
    public static final Memory CONST_INT_3 = new LongMemory(3L);
    public static final Memory CONST_INT_4 = new LongMemory(4L);
    public static final Memory CONST_INT_5 = new LongMemory(5L);
    public static final Memory CONST_DOUBLE_0 = new DoubleMemory(0.0);
    public static final Memory CONST_DOUBLE_1 = new DoubleMemory(1.0);
    public static final Memory CONST_DOUBLE_NAN = new DoubleMemory(Double.NaN);
    public static final Memory CONST_EMPTY_STRING = new StringMemory("");

    protected Memory(Type type) {
        this.type = type;
    }

    public boolean isNull() {
        return this.type == Type.NULL;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public boolean isUndefined() {
        return this.toValue() == UNDEFINED;
    }

    public boolean isShortcut() {
        return false;
    }

    public abstract long toLong();

    public int toInteger() {
        return (int)this.toLong();
    }

    public abstract double toDouble();

    public abstract boolean toBoolean();

    public abstract Memory toNumeric();

    public abstract String toString();

    public Memory toUnset() {
        return NULL;
    }

    public String toBinaryString() {
        return this.toString();
    }

    public Memory toBinary() {
        return new BinaryMemory(this.toString());
    }

    public float toFloat() {
        return (float)this.toDouble();
    }

    public Memory toArray() {
        ArrayMemory result = new ArrayMemory();
        result.add(this.toImmutable());
        return result.toConstant();
    }

    public Memory toObject(Environment env) {
        StdClass stdClass = new StdClass(env);
        stdClass.getProperties().refOfIndex("scalar").assign(this.toImmutable());
        return new ObjectMemory(stdClass);
    }

    public <T extends IObject> T toObject(Class<T> clazz) {
        try {
            return (T)((IObject)clazz.cast(this.toValue(ObjectMemory.class).value));
        }
        catch (ClassCastException e) {
            if (!(this instanceof ObjectMemory)) {
                throw new ClassCastException("Cannot convert '" + this.toString() + "' to an instance of " + ReflectionUtils.getClassName(clazz) + " class");
            }
            throw new ClassCastException("Cannot convert instance of " + this.toValue(ObjectMemory.class).getReflection().getName() + " class to an instance of " + ReflectionUtils.getClassName(clazz));
        }
    }

    public <T extends Enum> T toEnum(Class<T> clazz) {
        return Enum.valueOf(clazz, this.toString());
    }

    public Invoker toInvoker(Environment env) {
        Invoker invoker = Invoker.valueOf(env, null, this);
        if (invoker != null) {
            invoker.setTrace(env.trace());
            return invoker;
        }
        return null;
    }

    public Memory clone(Environment env, TraceInfo trace) throws Throwable {
        env.error(trace, "__clone method called on non-object", new Object[0]);
        return NULL;
    }

    public Type getRealType() {
        return this.type;
    }

    public char toChar() {
        switch (this.type) {
            case STRING: {
                String tmp = this.toString();
                if (tmp.isEmpty()) {
                    return '\u0000';
                }
                return tmp.charAt(0);
            }
        }
        return (char)this.toLong();
    }

    public int getPointer(boolean absolute) {
        return super.hashCode();
    }

    public int getPointer() {
        return super.hashCode();
    }

    public Memory newKeyValue(Memory memory) {
        return new KeyValueMemory(this.toValue(), memory);
    }

    public Memory newKeyValue(long memory) {
        return new KeyValueMemory(this.toValue(), LongMemory.valueOf(memory));
    }

    public Memory newKeyValue(double memory) {
        return new KeyValueMemory(this.toValue(), (Memory)new DoubleMemory(memory));
    }

    public Memory newKeyValue(boolean memory) {
        return new KeyValueMemory(this.toValue(), memory ? TRUE : FALSE);
    }

    public Memory newKeyValue(String memory) {
        return new KeyValueMemory(this.toValue(), (Memory)new StringMemory(memory));
    }

    public Memory newKeyValueRight(Memory memory) {
        return new KeyValueMemory(memory, this.toValue());
    }

    public Memory newKeyValueRight(long memory) {
        return new KeyValueMemory(LongMemory.valueOf(memory), this.toValue());
    }

    public Memory newKeyValueRight(double memory) {
        return new KeyValueMemory(new DoubleMemory(memory), this.toValue());
    }

    public Memory newKeyValueRight(boolean memory) {
        return new KeyValueMemory(memory ? TRUE : FALSE, this.toValue());
    }

    public Memory newKeyValueRight(String memory) {
        return new KeyValueMemory(new StringMemory(memory), this.toValue());
    }

    public boolean isObject() {
        return this.type == Type.OBJECT;
    }

    public boolean isClosure() {
        return false;
    }

    public boolean isResource() {
        return false;
    }

    public boolean isArray() {
        return this.type == Type.ARRAY;
    }

    public boolean isTraversable() {
        return this.isArray() || this.instanceOf("Traversable", "traversable");
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isNumber() {
        return this.type == Type.INT || this.type == Type.DOUBLE;
    }

    public boolean isReference() {
        return false;
    }

    public final Memory valueOfIndex(Memory index) {
        return this.valueOfIndex(null, index);
    }

    public Memory valueOfIndex(TraceInfo trace, Memory index) {
        return NULL;
    }

    public Memory valueOfIndex(TraceInfo trace, long index) {
        return NULL;
    }

    public final Memory valueOfIndex(long index) {
        return this.valueOfIndex((TraceInfo)null, index);
    }

    public Memory valueOfIndex(TraceInfo trace, double index) {
        return NULL;
    }

    public final Memory valueOfIndex(double index) {
        return this.valueOfIndex(null, index);
    }

    public Memory valueOfIndex(TraceInfo trace, String index) {
        return NULL;
    }

    public final Memory valueOfIndex(String index) {
        return this.valueOfIndex(null, index);
    }

    public Memory valueOfIndex(TraceInfo trace, boolean index) {
        return NULL;
    }

    public final Memory valueOfIndex(boolean index) {
        return this.valueOfIndex(null, index);
    }

    public final Memory refOfIndex(Memory index) {
        return this.refOfIndex(null, index);
    }

    public Memory refOfIndex(TraceInfo trace, Memory index) {
        return NULL;
    }

    public Memory refOfIndexAsShortcut(TraceInfo trace, Memory index) {
        return this.refOfIndex(trace, index);
    }

    public Memory refOfIndex(TraceInfo trace, long index) {
        return NULL;
    }

    public final Memory refOfIndex(long index) {
        return this.refOfIndex((TraceInfo)null, index);
    }

    public Memory refOfIndex(TraceInfo trace, double index) {
        return NULL;
    }

    public final Memory refOfIndex(double index) {
        return this.refOfIndex(null, index);
    }

    public Memory refOfIndex(TraceInfo trace, String index) {
        return NULL;
    }

    public final Memory refOfIndex(String index) {
        return this.refOfIndex(null, index);
    }

    public Memory refOfIndex(TraceInfo trace, boolean index) {
        return NULL;
    }

    public final Memory refOfIndex(boolean index) {
        return this.refOfIndex(null, index);
    }

    public Memory refOfPush(TraceInfo trace) {
        return new ReferenceMemory();
    }

    public final Memory refOfPush() {
        return this.refOfPush(null);
    }

    public void unsetOfIndex(TraceInfo trace, Memory index) {
    }

    public Memory issetOfIndex(TraceInfo trace, Memory index) {
        return NULL;
    }

    public Memory emptyOfIndex(TraceInfo trace, Memory index) {
        return this.issetOfIndex(trace, index);
    }

    public abstract Memory inc();

    public abstract Memory dec();

    public abstract Memory negative();

    public String concat(Memory memory) {
        return this.toString() + memory.toString();
    }

    public String concat(long value) {
        return this.toString() + value;
    }

    public String concat(double value) {
        return this.toString() + new DoubleMemory(value).toString();
    }

    public String concat(boolean value) {
        return this.toString() + Memory.boolToString(value);
    }

    public String concat(String value) {
        return this.toString() + value;
    }

    public abstract Memory plus(Memory var1);

    public Memory plus(long value) {
        return new LongMemory(this.toLong() + value);
    }

    public Memory plus(double value) {
        return new DoubleMemory(this.toDouble() + value);
    }

    public Memory plus(boolean value) {
        return new LongMemory(this.toLong() + (long)(value ? 1 : 0));
    }

    public Memory plus(String value) {
        return this.plus(StringMemory.toNumeric(value));
    }

    public abstract Memory minus(Memory var1);

    public Memory minus(long value) {
        return new LongMemory(this.toLong() - value);
    }

    public Memory minus(double value) {
        return new DoubleMemory(this.toDouble() - value);
    }

    public Memory minus(boolean value) {
        return new LongMemory(this.toLong() - (long)(value ? 1 : 0));
    }

    public Memory minus(String value) {
        return this.minus(StringMemory.toNumeric(value));
    }

    public abstract Memory mul(Memory var1);

    public Memory mul(long value) {
        return new LongMemory(this.toLong() * value);
    }

    public Memory mul(double value) {
        return new DoubleMemory(this.toDouble() * value);
    }

    public Memory mul(boolean value) {
        return LongMemory.valueOf(this.toLong() * (long)(value ? 1 : 0));
    }

    public Memory mul(String value) {
        return this.mul(StringMemory.toNumeric(value));
    }

    public abstract Memory pow(Memory var1);

    public Memory pow(long value) {
        Memory real = this.toNumeric();
        if (real instanceof LongMemory) {
            double result = Math.pow(real.toLong(), value);
            if (result > 9.223372036854776E18) {
                return new DoubleMemory(result);
            }
            return new LongMemory((long)result);
        }
        return new DoubleMemory(Math.pow(real.toDouble(), value));
    }

    public Memory pow(double value) {
        return new DoubleMemory(Math.pow(this.toDouble(), value));
    }

    public Memory pow(boolean value) {
        Memory real = this.toNumeric();
        if (real instanceof LongMemory) {
            return value ? real.toImmutable() : CONST_INT_1;
        }
        return value ? real.toImmutable() : CONST_DOUBLE_1;
    }

    public Memory pow(String value) {
        return this.pow(StringMemory.toNumeric(value));
    }

    public abstract Memory div(Memory var1);

    public Memory div(long value) {
        if (value == 0L) {
            return FALSE;
        }
        return new DoubleMemory(this.toDouble() / (double)value);
    }

    public Memory div(double value) {
        if (value == 0.0) {
            return FALSE;
        }
        return new DoubleMemory(this.toDouble() / value);
    }

    public Memory div(boolean value) {
        if (!value) {
            return FALSE;
        }
        return LongMemory.valueOf(this.toLong());
    }

    public Memory div(String value) {
        return this.div(StringMemory.toNumeric(value));
    }

    protected static Memory _divByZero() {
        return UNDEFINED;
    }

    public Memory modCheckResult(Environment env, TraceInfo trace) {
        if (this == UNDEFINED) {
            env.exception(trace, BaseDivisionByZeroError.class, "Modulo by zero", new Object[0]);
        }
        return this;
    }

    public Memory mod(Memory memory) {
        long t = memory.toLong();
        if (t == 0L) {
            return Memory._divByZero();
        }
        return LongMemory.valueOf(this.toLong() % t);
    }

    public Memory mod(long value) {
        if (value == 0L) {
            return Memory._divByZero();
        }
        return LongMemory.valueOf(this.toLong() % value);
    }

    public Memory mod(double value) {
        return this.mod((long)value);
    }

    public Memory mod(boolean value) {
        if (!value) {
            return Memory._divByZero();
        }
        return LongMemory.valueOf(this.toLong() % 1L);
    }

    public Memory mod(String value) {
        return this.mod(StringMemory.toNumeric(value, true, CONST_INT_0));
    }

    public boolean not() {
        return !this.toBoolean();
    }

    private static boolean _xor(boolean ... args) {
        boolean r = false;
        for (boolean b : args) {
            r ^= b;
        }
        return r;
    }

    public boolean xor(Memory value) {
        return Memory._xor(this.toBoolean(), value.toBoolean());
    }

    public boolean xor(long value) {
        return Memory._xor(this.toBoolean(), value != 0L);
    }

    public boolean xor(double value) {
        return Memory._xor(this.toBoolean(), OperatorUtils.toBoolean(value));
    }

    public boolean xor(boolean value) {
        return Memory._xor(this.toBoolean(), value);
    }

    public boolean xor(String value) {
        return Memory._xor(this.toBoolean(), OperatorUtils.toBoolean(value));
    }

    public long spaceshipCompare(Memory value) {
        return this.equal(value) ? 0L : (this.greater(value) ? 1L : -1L);
    }

    public long spaceshipCompare(long value) {
        return this.equal(value) ? 0L : (this.greater(value) ? 1L : -1L);
    }

    public long spaceshipCompare(double value) {
        return this.equal(value) ? 0L : (this.greater(value) ? 1L : -1L);
    }

    public long spaceshipCompare(boolean value) {
        return this.equal(value) ? 0L : (this.greater(value) ? 1L : -1L);
    }

    public long spaceshipCompare(String value) {
        return this.equal(value) ? 0L : (this.greater(value) ? 1L : -1L);
    }

    public abstract boolean equal(Memory var1);

    public boolean equal(long value) {
        return this.toLong() == value;
    }

    public boolean equal(double value) {
        return DoubleMemory.almostEqual(this.toDouble(), value);
    }

    public boolean equal(boolean value) {
        return this.toBoolean() == value;
    }

    public boolean equal(String value) {
        return this.equal(StringMemory.toNumeric(value));
    }

    public abstract boolean identical(Memory var1);

    public boolean identical(long value) {
        return this.type == Type.INT && this.toLong() == value;
    }

    public boolean identical(double value) {
        return this.type == Type.DOUBLE && DoubleMemory.almostEqual(this.toDouble(), value);
    }

    public boolean identical(boolean value) {
        return this.type == Type.BOOL && value ? this.toImmutable() == TRUE : this.toImmutable() == FALSE;
    }

    public boolean identical(String value) {
        return this.type == Type.STRING && this.toString().equals(value);
    }

    public abstract boolean notEqual(Memory var1);

    public boolean notEqual(long value) {
        return this.toLong() != value;
    }

    public boolean notEqual(double value) {
        return this.toDouble() != value;
    }

    public boolean notEqual(boolean value) {
        return this.toBoolean() != value;
    }

    public boolean notEqual(String value) {
        return !this.toString().equals(value);
    }

    public boolean notIdentical(Memory memory) {
        return !this.identical(memory);
    }

    public boolean notIdentical(long memory) {
        return !this.identical(memory);
    }

    public boolean notIdentical(double memory) {
        return !this.identical(memory);
    }

    public boolean notIdentical(boolean memory) {
        return !this.identical(memory);
    }

    public boolean notIdentical(String memory) {
        return !this.identical(memory);
    }

    public abstract boolean smaller(Memory var1);

    public boolean smaller(long value) {
        return this.toDouble() < (double)value;
    }

    public boolean smaller(double value) {
        return this.toDouble() < value;
    }

    public boolean smaller(boolean value) {
        return this.toDouble() < (double)(value ? 1 : 0);
    }

    public boolean smaller(String value) {
        return this.smaller(StringMemory.toNumeric(value));
    }

    public abstract boolean smallerEq(Memory var1);

    public boolean smallerEq(long value) {
        return this.toDouble() <= (double)value;
    }

    public boolean smallerEq(double value) {
        return this.toDouble() <= value;
    }

    public boolean smallerEq(boolean value) {
        return this.toDouble() <= (double)(value ? 1 : 0);
    }

    public boolean smallerEq(String value) {
        return this.smallerEq(StringMemory.toNumeric(value));
    }

    public abstract boolean greater(Memory var1);

    public boolean greater(long value) {
        return this.toDouble() > (double)value;
    }

    public boolean greater(double value) {
        return this.toDouble() > value;
    }

    public boolean greater(boolean value) {
        return this.toDouble() > (double)(value ? 1 : 0);
    }

    public boolean greater(String value) {
        return this.smaller(StringMemory.toNumeric(value));
    }

    public abstract boolean greaterEq(Memory var1);

    public boolean greaterEq(long value) {
        return this.toDouble() >= (double)value;
    }

    public boolean greaterEq(double value) {
        return this.toDouble() >= value;
    }

    public boolean greaterEq(boolean value) {
        return this.toDouble() >= (double)(value ? 1 : 0);
    }

    public boolean greaterEq(String value) {
        return this.greaterEq(StringMemory.toNumeric(value));
    }

    public Memory bitAnd(Memory memory) {
        return LongMemory.valueOf(this.toLong() & memory.toLong());
    }

    public Memory bitAnd(long memory) {
        return LongMemory.valueOf(this.toLong() & memory);
    }

    public Memory bitAnd(double memory) {
        return LongMemory.valueOf(this.toLong() & (long)memory);
    }

    public Memory bitAnd(boolean memory) {
        return LongMemory.valueOf(this.toLong() & (long)(memory ? 1 : 0));
    }

    public Memory bitAnd(String memory) {
        return LongMemory.valueOf(this.toLong() & StringMemory.toNumeric(memory).toLong());
    }

    public Memory bitOr(Memory memory) {
        return LongMemory.valueOf(this.toLong() | memory.toLong());
    }

    public Memory bitOr(long memory) {
        return LongMemory.valueOf(this.toLong() | memory);
    }

    public Memory bitOr(double memory) {
        return LongMemory.valueOf(this.toLong() | (long)memory);
    }

    public Memory bitOr(boolean memory) {
        return LongMemory.valueOf(this.toLong() | (long)(memory ? 1 : 0));
    }

    public Memory bitOr(String memory) {
        return LongMemory.valueOf(this.toLong() | StringMemory.toNumeric(memory).toLong());
    }

    public Memory bitXor(Memory memory) {
        return LongMemory.valueOf(this.toLong() ^ memory.toLong());
    }

    public Memory bitXor(long memory) {
        return LongMemory.valueOf(this.toLong() ^ memory);
    }

    public Memory bitXor(double memory) {
        return LongMemory.valueOf(this.toLong() ^ (long)memory);
    }

    public Memory bitXor(boolean memory) {
        return LongMemory.valueOf(this.toLong() ^ (long)(memory ? 1 : 0));
    }

    public Memory bitXor(String memory) {
        return LongMemory.valueOf(this.toLong() ^ StringMemory.toNumeric(memory).toLong());
    }

    public Memory bitNot() {
        return LongMemory.valueOf(this.toLong() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    protected static Memory _negativeShift() {
        return UNDEFINED;
    }

    public Memory bitwiseCheckResult(Environment env, TraceInfo trace) {
        if (this == UNDEFINED) {
            env.exception(trace, BaseArithmeticError.class, "Bit shift by negative number", new Object[0]);
        }
        return this;
    }

    public Memory bitShr(Memory memory) {
        long l = memory.toLong();
        return l < 0L ? Memory._negativeShift() : LongMemory.valueOf(this.toLong() >> (int)l);
    }

    public Memory bitShr(long memory) {
        return memory < 0L ? Memory._negativeShift() : LongMemory.valueOf(this.toLong() >> (int)memory);
    }

    public Memory bitShr(double memory) {
        return memory < 0.0 ? Memory._negativeShift() : LongMemory.valueOf(this.toLong() >> (int)memory);
    }

    public Memory bitShr(boolean memory) {
        return LongMemory.valueOf(this.toLong() >> (memory ? 1 : 0));
    }

    public Memory bitShr(String memory) {
        long l = StringMemory.toNumeric(memory).toLong();
        return l < 0L ? Memory._negativeShift() : LongMemory.valueOf(this.toLong() >> (int)l);
    }

    public Memory bitShl(Memory memory) {
        long l = memory.toLong();
        return l < 0L ? Memory._negativeShift() : LongMemory.valueOf(this.toLong() << (int)l);
    }

    public Memory bitShl(long memory) {
        return memory < 0L ? Memory._negativeShift() : LongMemory.valueOf(this.toLong() << (int)memory);
    }

    public Memory bitShl(double memory) {
        return memory < 0.0 ? Memory._negativeShift() : LongMemory.valueOf(this.toLong() << (int)memory);
    }

    public Memory bitShl(boolean memory) {
        return LongMemory.valueOf(this.toLong() << (memory ? 1 : 0));
    }

    public Memory bitShl(String memory) {
        long l = StringMemory.toNumeric(memory).toLong();
        return l < 0L ? FALSE : LongMemory.valueOf(this.toLong() << (int)l);
    }

    public Memory assign(Memory memory) {
        throw new RuntimeException("Invalid assign `memory` to " + (Object)((Object)this.type));
    }

    public Memory assign(long value) {
        throw new RuntimeException("Invalid assign `long` to " + (Object)((Object)this.type));
    }

    public Memory assign(double value) {
        throw new RuntimeException("Invalid assign `double` to " + (Object)((Object)this.type));
    }

    public Memory assign(boolean value) {
        throw new RuntimeException("Invalid assign `bool` to " + (Object)((Object)this.type));
    }

    public Memory assign(String value) {
        throw new RuntimeException("Invalid assign `string` to " + (Object)((Object)this.type));
    }

    public Memory assignRef(Memory memory) {
        throw new RuntimeException("Invalid assignRef `memory` to " + (Object)((Object)this.type));
    }

    public Memory assignRight(Memory memory) {
        return memory.assign(this);
    }

    public Memory assignRefRight(Memory memory) {
        return memory.assignRef(this);
    }

    public Memory assign(IObject object) {
        return this.assign(new ObjectMemory(object));
    }

    public Memory assignConcat(Memory memory) {
        return this.assign(this.concat(memory));
    }

    public Memory assignConcat(long memory) {
        return this.assign(this.concat(memory));
    }

    public Memory assignConcat(double memory) {
        return this.assign(this.concat(memory));
    }

    public Memory assignConcat(boolean memory) {
        return this.assign(this.concat(memory));
    }

    public Memory assignConcat(String memory) {
        return this.assign(this.concat(memory));
    }

    public Memory assignConcatRight(Memory memory) {
        return memory.assign(memory.concat(this));
    }

    public Memory assignPlus(Memory memory) {
        return this.assign(this.plus(memory));
    }

    public Memory assignPlus(long memory) {
        return this.assign(this.plus(memory));
    }

    public Memory assignPlus(double memory) {
        return this.assign(this.plus(memory));
    }

    public Memory assignPlus(boolean memory) {
        return this.assign(this.plus(memory));
    }

    public Memory assignPlus(String memory) {
        return this.assign(this.plus(memory));
    }

    public Memory assignPlusRight(Memory memory) {
        return memory.assign(memory.plus(this));
    }

    public Memory assignMinus(Memory memory) {
        return this.assign(this.minus(memory));
    }

    public Memory assignMinus(long memory) {
        return this.assign(this.minus(memory));
    }

    public Memory assignMinus(double memory) {
        return this.assign(this.minus(memory));
    }

    public Memory assignMinus(boolean memory) {
        return this.assign(this.minus(memory));
    }

    public Memory assignMinus(String memory) {
        return this.assign(this.minus(memory));
    }

    public Memory assignMinusRight(Memory memory) {
        return memory.assign(memory.minus(this));
    }

    public Memory assignMul(Memory memory) {
        return this.assign(this.mul(memory));
    }

    public Memory assignMul(long memory) {
        return this.assign(this.mul(memory));
    }

    public Memory assignMul(double memory) {
        return this.assign(this.mul(memory));
    }

    public Memory assignMul(boolean memory) {
        return this.assign(this.mul(memory));
    }

    public Memory assignMul(String memory) {
        return this.assign(this.mul(memory));
    }

    public Memory assignMulRight(Memory memory) {
        return memory.assign(memory.mul(this));
    }

    public Memory assignPow(Memory memory) {
        return this.assign(this.pow(memory));
    }

    public Memory assignPow(long memory) {
        return this.assign(this.pow(memory));
    }

    public Memory assignPow(double memory) {
        return this.assign(this.pow(memory));
    }

    public Memory assignPow(boolean memory) {
        return this.assign(this.pow(memory));
    }

    public Memory assignPow(String memory) {
        return this.assign(this.pow(memory));
    }

    public Memory assignPowRight(Memory memory) {
        return memory.assign(memory.pow(this));
    }

    public Memory assignDiv(Memory memory) {
        return this.assign(this.div(memory));
    }

    public Memory assignDiv(long memory) {
        return this.assign(this.div(memory));
    }

    public Memory assignDiv(double memory) {
        return this.assign(this.div(memory));
    }

    public Memory assignDiv(boolean memory) {
        return this.assign(this.div(memory));
    }

    public Memory assignDiv(String memory) {
        return this.assign(this.div(memory));
    }

    public Memory assignDivRight(Memory memory) {
        return memory.assign(memory.div(this));
    }

    public Memory assignMod(Memory memory) {
        return this.assign(this.mod(memory));
    }

    public Memory assignMod(long memory) {
        return this.assign(this.mod(memory));
    }

    public Memory assignMod(double memory) {
        return this.assign(this.mod(memory));
    }

    public Memory assignMod(boolean memory) {
        return this.assign(this.mod(memory));
    }

    public Memory assignMod(String memory) {
        return this.assign(this.mod(memory));
    }

    public Memory assignModRight(Memory memory) {
        return memory.assign(memory.mod(this));
    }

    public Memory assignBitShr(Memory memory) {
        return this.assign(this.bitShr(memory));
    }

    public Memory assignBitShr(long memory) {
        return this.assign(this.bitShr(memory));
    }

    public Memory assignBitShr(double memory) {
        return this.assign(this.bitShr(memory));
    }

    public Memory assignBitShr(boolean memory) {
        return this.assign(this.bitShr(memory));
    }

    public Memory assignBitShr(String memory) {
        return this.assign(this.bitShr(memory));
    }

    public Memory assignBitShrRight(Memory memory) {
        return memory.assign(memory.bitShr(this));
    }

    public Memory assignBitShl(Memory memory) {
        return this.assign(this.bitShl(memory));
    }

    public Memory assignBitShl(long memory) {
        return this.assign(this.bitShl(memory));
    }

    public Memory assignBitShl(double memory) {
        return this.assign(this.bitShl(memory));
    }

    public Memory assignBitShl(boolean memory) {
        return this.assign(this.bitShl(memory));
    }

    public Memory assignBitShl(String memory) {
        return this.assign(this.bitShl(memory));
    }

    public Memory assignBitShlRight(Memory memory) {
        return memory.assign(memory.bitShl(this));
    }

    public Memory assignBitAnd(Memory memory) {
        return this.assign(this.bitAnd(memory));
    }

    public Memory assignBitAnd(long memory) {
        return this.assign(this.bitAnd(memory));
    }

    public Memory assignBitAnd(double memory) {
        return this.assign(this.bitAnd(memory));
    }

    public Memory assignBitAnd(boolean memory) {
        return this.assign(this.bitAnd(memory));
    }

    public Memory assignBitAnd(String memory) {
        return this.assign(this.bitAnd(memory));
    }

    public Memory assignBitAndRight(Memory memory) {
        return memory.assign(memory.bitAnd(this));
    }

    public Memory assignBitOr(Memory memory) {
        return this.assign(this.bitOr(memory));
    }

    public Memory assignBitOr(long memory) {
        return this.assign(this.bitOr(memory));
    }

    public Memory assignBitOr(double memory) {
        return this.assign(this.bitOr(memory));
    }

    public Memory assignBitOr(boolean memory) {
        return this.assign(this.bitOr(memory));
    }

    public Memory assignBitOr(String memory) {
        return this.assign(this.bitOr(memory));
    }

    public Memory assignBitOrRight(Memory memory) {
        return memory.assign(memory.bitOr(this));
    }

    public Memory assignBitXor(Memory memory) {
        return this.assign(this.bitXor(memory));
    }

    public Memory assignBitXor(long memory) {
        return this.assign(this.bitXor(memory));
    }

    public Memory assignBitXor(double memory) {
        return this.assign(this.bitXor(memory));
    }

    public Memory assignBitXor(boolean memory) {
        return this.assign(this.bitXor(memory));
    }

    public Memory assignBitXor(String memory) {
        return this.assign(this.bitXor(memory));
    }

    public Memory assignBitXorRight(Memory memory) {
        return memory.assign(memory.bitXor(this));
    }

    public void unset() {
    }

    public void manualUnset(Environment env) {
    }

    public Memory toImmutable() {
        return this;
    }

    public Memory toImmutable(Environment env, TraceInfo trace) {
        return this.toImmutable();
    }

    public <T extends Memory> T toValue(Class<T> clazz) {
        return (T)this;
    }

    public Memory toValue() {
        return this;
    }

    public boolean isImmutable() {
        return true;
    }

    public long spaceshipCompareRight(Memory value) {
        return this.equal(value) ? 0L : (this.greater(value) ? -1L : 1L);
    }

    public long spaceshipCompareRight(long value) {
        return this.equal(value) ? 0L : (this.greater(value) ? -1L : 1L);
    }

    public long spaceshipCompareRight(double value) {
        return this.equal(value) ? 0L : (this.greater(value) ? -1L : 1L);
    }

    public long spaceshipCompareRight(boolean value) {
        return this.equal(value) ? 0L : (this.greater(value) ? -1L : 1L);
    }

    public long spaceshipCompareRight(String value) {
        return this.equal(value) ? 0L : (this.greater(value) ? -1L : 1L);
    }

    public Memory minusRight(Memory value) {
        return value.minus(this);
    }

    public Memory minusRight(long value) {
        return LongMemory.valueOf(value).minus(this);
    }

    public Memory minusRight(double value) {
        return new DoubleMemory(value).minus(this);
    }

    public Memory minusRight(boolean value) {
        return LongMemory.valueOf(value ? 1 : 0).minus(this);
    }

    public Memory minusRight(String value) {
        return StringMemory.toNumeric(value).minus(this);
    }

    public Memory divRight(Memory value) {
        return value.div(this);
    }

    public Memory divRight(long value) {
        return LongMemory.valueOf(value).div(this);
    }

    public Memory divRight(double value) {
        return new DoubleMemory(value).div(this);
    }

    public Memory divRight(boolean value) {
        if (!value) {
            return CONST_INT_0;
        }
        return TRUE.div(this);
    }

    public Memory divRight(String value) {
        return StringMemory.toNumeric(value).div(this);
    }

    public Memory modRight(Memory value) {
        return value.mod(this);
    }

    public Memory modRight(long value) {
        return LongMemory.valueOf(value).mod(this);
    }

    public Memory modRight(double value) {
        return new DoubleMemory(value).mod(this);
    }

    public Memory modRight(boolean value) {
        return LongMemory.valueOf(value ? 1 : 0).mod(this);
    }

    public Memory modRight(String value) {
        return StringMemory.toNumeric(value).mod(this);
    }

    public Memory powRight(Memory value) {
        return value.pow(this);
    }

    public Memory powRight(long value) {
        return LongMemory.valueOf(value).pow(this);
    }

    public Memory powRight(double value) {
        return new DoubleMemory(value).pow(this);
    }

    public Memory powRight(boolean value) {
        return LongMemory.valueOf(value ? 1 : 0).pow(this);
    }

    public Memory powRight(String value) {
        return StringMemory.toNumeric(value).pow(this);
    }

    public String concatRight(Memory value) {
        return value.concat(this);
    }

    public String concatRight(long value) {
        return value + this.toString();
    }

    public String concatRight(double value) {
        return value + this.toString();
    }

    public String concatRight(boolean value) {
        return Memory.boolToString(value) + this.toString();
    }

    public String concatRight(String value) {
        return value + this.toString();
    }

    public boolean smallerRight(Memory value) {
        return value.smaller(this);
    }

    public boolean smallerRight(long value) {
        return this.greaterEq(value);
    }

    public boolean smallerRight(double value) {
        return this.greaterEq(value);
    }

    public boolean smallerRight(boolean value) {
        return this.greaterEq(value);
    }

    public boolean smallerRight(String value) {
        return this.greaterEq(value);
    }

    public boolean smallerEqRight(Memory value) {
        return value.smallerEq(this);
    }

    public boolean smallerEqRight(long value) {
        return this.greater(value);
    }

    public boolean smallerEqRight(double value) {
        return this.greater(value);
    }

    public boolean smallerEqRight(boolean value) {
        return this.greater(value);
    }

    public boolean smallerEqRight(String value) {
        return this.greater(value);
    }

    public boolean greaterRight(Memory value) {
        return value.greater(this);
    }

    public boolean greaterRight(long value) {
        return this.smallerEq(value);
    }

    public boolean greaterRight(double value) {
        return this.smallerEq(value);
    }

    public boolean greaterRight(boolean value) {
        return this.smallerEq(value);
    }

    public boolean greaterRight(String value) {
        return this.smallerEq(value);
    }

    public boolean greaterEqRight(Memory value) {
        return value.greaterEq(this);
    }

    public boolean greaterEqRight(long value) {
        return this.smaller(value);
    }

    public boolean greaterEqRight(double value) {
        return this.smaller(value);
    }

    public boolean greaterEqRight(boolean value) {
        return this.smaller(value);
    }

    public boolean greaterEqRight(String value) {
        return this.smaller(value);
    }

    public Memory bitShrRight(Memory value) {
        return value.bitShr(this);
    }

    public Memory bitShrRight(long value) {
        long l = this.toLong();
        return l < 0L ? Memory._negativeShift() : LongMemory.valueOf(value >> (int)l);
    }

    public Memory bitShrRight(double value) {
        long l = this.toLong();
        return l < 0L ? Memory._negativeShift() : LongMemory.valueOf((long)value >> (int)l);
    }

    public Memory bitShrRight(boolean value) {
        return LongMemory.valueOf((value ? 1 : 0) >> (int)this.toLong());
    }

    public Memory bitShrRight(String value) {
        return StringMemory.toNumeric(value).bitShr(this);
    }

    public Memory bitShlRight(Memory value) {
        return value.bitShl(this);
    }

    public Memory bitShlRight(long value) {
        long l = this.toLong();
        return l < 0L ? Memory._negativeShift() : LongMemory.valueOf(value << (int)l);
    }

    public Memory bitShlRight(double value) {
        long l = this.toLong();
        return l < 0L ? Memory._negativeShift() : LongMemory.valueOf((long)value << (int)l);
    }

    public Memory bitShlRight(boolean value) {
        return LongMemory.valueOf((value ? 1 : 0) << (int)this.toLong());
    }

    public Memory bitShlRight(String value) {
        return StringMemory.toNumeric(value).bitShl(this);
    }

    public Memory unpack() {
        return new VariadicMemory(this);
    }

    public static Memory assignRight(Memory value, Memory memory) {
        return memory.assign(value);
    }

    public static Memory assignRight(long value, Memory memory) {
        return memory.assign(value);
    }

    public static Memory assignRight(double value, Memory memory) {
        return memory.assign(value);
    }

    public static Memory assignRight(boolean value, Memory memory) {
        return memory.assign(value);
    }

    public static Memory assignRight(String value, Memory memory) {
        return memory.assign(value);
    }

    public static Memory assignRefRight(Memory value, Memory memory) {
        return memory.assignRef(value);
    }

    public static Memory assignConcatRight(Memory value, Memory memory) {
        return memory.assignConcat(value);
    }

    public static Memory assignConcatRight(long value, Memory memory) {
        return memory.assignConcat(value);
    }

    public static Memory assignConcatRight(double value, Memory memory) {
        return memory.assignConcat(value);
    }

    public static Memory assignConcatRight(boolean value, Memory memory) {
        return memory.assignConcat(value);
    }

    public static Memory assignConcatRight(String value, Memory memory) {
        return memory.assignConcat(value);
    }

    public static Memory assignPlusRight(Memory value, Memory memory) {
        return memory.assignPlus(value);
    }

    public static Memory assignPlusRight(long value, Memory memory) {
        return memory.assignPlus(value);
    }

    public static Memory assignPlusRight(double value, Memory memory) {
        return memory.assignPlus(value);
    }

    public static Memory assignPlusRight(boolean value, Memory memory) {
        return memory.assignPlus(value);
    }

    public static Memory assignPlusRight(String value, Memory memory) {
        return memory.assignPlus(value);
    }

    public static Memory assignMinusRight(Memory value, Memory memory) {
        return memory.assignMinus(value);
    }

    public static Memory assignMinusRight(long value, Memory memory) {
        return memory.assignMinus(value);
    }

    public static Memory assignMinusRight(double value, Memory memory) {
        return memory.assignMinus(value);
    }

    public static Memory assignMinusRight(boolean value, Memory memory) {
        return memory.assignMinus(value);
    }

    public static Memory assignMinusRight(String value, Memory memory) {
        return memory.assignMinus(value);
    }

    public static Memory assignMulRight(Memory value, Memory memory) {
        return memory.assignMul(value);
    }

    public static Memory assignMulRight(long value, Memory memory) {
        return memory.assignMul(value);
    }

    public static Memory assignMulRight(double value, Memory memory) {
        return memory.assignMul(value);
    }

    public static Memory assignMulRight(boolean value, Memory memory) {
        return memory.assignMul(value);
    }

    public static Memory assignMulRight(String value, Memory memory) {
        return memory.assignMul(value);
    }

    public static Memory assignPowRight(Memory value, Memory memory) {
        return memory.assignPow(value);
    }

    public static Memory assignPowRight(long value, Memory memory) {
        return memory.assignPow(value);
    }

    public static Memory assignPowRight(double value, Memory memory) {
        return memory.assignPow(value);
    }

    public static Memory assignPowRight(boolean value, Memory memory) {
        return memory.assignPow(value);
    }

    public static Memory assignPowRight(String value, Memory memory) {
        return memory.assignPow(value);
    }

    public static Memory assignDivRight(Memory value, Memory memory) {
        return memory.assignDiv(value);
    }

    public static Memory assignDivRight(long value, Memory memory) {
        return memory.assignDiv(value);
    }

    public static Memory assignDivRight(double value, Memory memory) {
        return memory.assignDiv(value);
    }

    public static Memory assignDivRight(boolean value, Memory memory) {
        return memory.assignDiv(value);
    }

    public static Memory assignDivRight(String value, Memory memory) {
        return memory.assignDiv(value);
    }

    public static Memory assignModRight(Memory value, Memory memory) {
        return memory.assignMod(value);
    }

    public static Memory assignModRight(long value, Memory memory) {
        return memory.assignMod(value);
    }

    public static Memory assignModRight(double value, Memory memory) {
        return memory.assignMod(value);
    }

    public static Memory assignModRight(boolean value, Memory memory) {
        return memory.assignMod(value);
    }

    public static Memory assignModRight(String value, Memory memory) {
        return memory.assignMod(value);
    }

    public static Memory assignBitShrRight(Memory value, Memory memory) {
        return memory.assignBitShr(value);
    }

    public static Memory assignBitShrRight(long value, Memory memory) {
        return memory.assignBitShr(value);
    }

    public static Memory assignBitShrRight(double value, Memory memory) {
        return memory.assignBitShr(value);
    }

    public static Memory assignBitShrRight(boolean value, Memory memory) {
        return memory.assignBitShr(value);
    }

    public static Memory assignBitShrRight(String value, Memory memory) {
        return memory.assignBitShr(value);
    }

    public static Memory assignBitShlRight(Memory value, Memory memory) {
        return memory.assignBitShl(value);
    }

    public static Memory assignBitShlRight(long value, Memory memory) {
        return memory.assignBitShl(value);
    }

    public static Memory assignBitShlRight(double value, Memory memory) {
        return memory.assignBitShl(value);
    }

    public static Memory assignBitShlRight(boolean value, Memory memory) {
        return memory.assignBitShl(value);
    }

    public static Memory assignBitShlRight(String value, Memory memory) {
        return memory.assignBitShl(value);
    }

    public static Memory assignBitAndRight(Memory value, Memory memory) {
        return memory.assignBitAnd(value);
    }

    public static Memory assignBitAndRight(long value, Memory memory) {
        return memory.assignBitAnd(value);
    }

    public static Memory assignBitAndRight(double value, Memory memory) {
        return memory.assignBitAnd(value);
    }

    public static Memory assignBitAndRight(boolean value, Memory memory) {
        return memory.assignBitAnd(value);
    }

    public static Memory assignBitAndRight(String value, Memory memory) {
        return memory.assignBitAnd(value);
    }

    public static Memory assignBitOrRight(Memory value, Memory memory) {
        return memory.assignBitOr(value);
    }

    public static Memory assignBitOrRight(long value, Memory memory) {
        return memory.assignBitOr(value);
    }

    public static Memory assignBitOrRight(double value, Memory memory) {
        return memory.assignBitOr(value);
    }

    public static Memory assignBitOrRight(boolean value, Memory memory) {
        return memory.assignBitOr(value);
    }

    public static Memory assignBitOrRight(String value, Memory memory) {
        return memory.assignBitOr(value);
    }

    public static Memory assignBitXorRight(Memory value, Memory memory) {
        return memory.assignBitXor(value);
    }

    public static Memory assignBitXorRight(long value, Memory memory) {
        return memory.assignBitXor(value);
    }

    public static Memory assignBitXorRight(double value, Memory memory) {
        return memory.assignBitXor(value);
    }

    public static Memory assignBitXorRight(boolean value, Memory memory) {
        return memory.assignBitXor(value);
    }

    public static Memory assignBitXorRight(String value, Memory memory) {
        return memory.assignBitXor(value);
    }

    public static Object unwrap(Environment env, Memory memory) {
        if (memory.isObject()) {
            IObject iObject = memory.toValue(ObjectMemory.class).value;
            if (iObject instanceof BaseWrapper) {
                return ((BaseWrapper)iObject).getWrappedObject();
            }
            return iObject;
        }
        switch (memory.getRealType()) {
            case BOOL: {
                return memory.toBoolean();
            }
            case INT: {
                return memory.toLong();
            }
            case DOUBLE: {
                return memory.toDouble();
            }
            case STRING: {
                return memory.toString();
            }
            case NULL: {
                return null;
            }
            case ARRAY: {
                return memory.toValue(ArrayMemory.class);
            }
        }
        return memory;
    }

    public static Memory wrap(Environment env, Object o) {
        if (o == null) {
            return NULL;
        }
        MemoryOperation operation = MemoryOperation.get(o.getClass(), null);
        if (operation != null) {
            return operation.unconvertNoThow(env, env == null ? TraceInfo.UNKNOWN : env.trace(), o);
        }
        return NULL;
    }

    public static String boolToString(boolean value) {
        return value ? "1" : "";
    }

    public abstract byte[] getBinaryBytes(Charset var1);

    @Deprecated
    public final byte[] getBinaryBytes() {
        return this.getBinaryBytes(Charset.defaultCharset());
    }

    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return null;
    }

    public final ForeachIterator getNewIterator(Environment env) {
        return this.getNewIterator(env, false, false);
    }

    public boolean instanceOf(String className, String lowerClassName) {
        return false;
    }

    public boolean instanceOf(Class<? extends IObject> clazz) {
        return this.instanceOf(ReflectionUtils.getClassName(clazz));
    }

    public boolean instanceOf(String name) {
        return false;
    }

    @Override
    public int compareTo(Memory o) {
        if (this.greater(o)) {
            return 1;
        }
        if (this.smaller(o)) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Memory memory = (Memory)o;
        return this.equal(memory);
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static enum Type {
        NULL(null),
        BOOL(Boolean.TYPE),
        INT(Long.TYPE),
        DOUBLE(Double.TYPE),
        STRING(String.class),
        ARRAY(ArrayMemory.class),
        OBJECT(ObjectMemory.class),
        REFERENCE(Memory.class),
        KEY_VALUE(KeyValueMemory.class);

        private final Class<?> clazz;
        private static final Map<Class<?>, Type> map;
        protected static final Map<String, Type> TYPE_MAP;

        private Type(Class<?> aClass) {
            this.clazz = aClass;
        }

        public Class toClass() {
            return this.clazz;
        }

        public static Type valueOf(Class clazz) {
            Type type = map.get(clazz);
            if (type == null) {
                return REFERENCE;
            }
            return type;
        }

        public String toString() {
            switch (this) {
                case ARRAY: {
                    return "array";
                }
                case BOOL: {
                    return "boolean";
                }
                case DOUBLE: {
                    return "float";
                }
                case INT: {
                    return "integer";
                }
                case NULL: {
                    return "NULL";
                }
                case OBJECT: {
                    return "object";
                }
                case STRING: {
                    return "string";
                }
            }
            return "unknown";
        }

        public static Type of(String code) {
            return TYPE_MAP.get(code.toLowerCase());
        }

        static {
            map = new HashMap();
            for (Type type : Type.values()) {
                map.put(type.clazz, type);
            }
            TYPE_MAP = new HashMap<String, Type>(){
                {
                    this.put("array", ARRAY);
                    this.put("bool", BOOL);
                    this.put("boolean", BOOL);
                    this.put("double", DOUBLE);
                    this.put("float", DOUBLE);
                    this.put("int", INT);
                    this.put("integer", INT);
                    this.put("long", INT);
                    this.put("null", NULL);
                    this.put("string", STRING);
                    this.put("object", OBJECT);
                }
            };
        }
    }
}

