/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.stream;

import java.util.Arrays;

public class MemoryStream {
    protected int position;
    protected int length;
    protected byte[] data;

    public MemoryStream(byte[] data) {
        this.data = data;
        this.length = data.length;
    }

    public MemoryStream() {
        this.data = new byte[0];
        this.length = 0;
    }

    public void write(byte[] buff, int offset, int length) {
        if (this.position == this.length) {
            this.length += length - offset;
            byte[] tmp = new byte[this.length];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            System.arraycopy(buff, 0, tmp, this.data.length, tmp.length - this.data.length);
            this.data = tmp;
        } else {
            int newLen = this.position + length - offset;
            if (newLen > this.length) {
                this.length = newLen;
                byte[] tmp = new byte[this.length];
                System.arraycopy(this.data, 0, tmp, 0, this.position);
                System.arraycopy(buff, 0, tmp, this.position, tmp.length - this.position);
                this.data = tmp;
            } else {
                int j = 0;
                int i = this.position;
                while (i < this.position + length - offset) {
                    this.data[i] = buff[j];
                    ++i;
                    ++j;
                }
            }
        }
        this.position += length - offset;
    }

    public void write(byte[] buff) {
        this.write(buff, 0, buff.length);
    }

    public byte[] read(int length) {
        if (length < 0) {
            return null;
        }
        int to = this.position + length;
        if (to > this.length) {
            to = this.length;
        }
        if (this.position == to) {
            return null;
        }
        byte[] result = Arrays.copyOfRange(this.data, this.position, to);
        this.position = to;
        return result;
    }

    public byte[] readFully() {
        return this.read(this.length - this.position);
    }

    public boolean seek(int position) {
        if (position < 0 || position >= this.length) {
            return false;
        }
        this.position = position;
        return true;
    }

    public boolean eof() {
        return this.position >= this.length;
    }

    public void close() {
    }
}

