/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.MemoryStream;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.core.classes.stream.WrapIOException;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.LongMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\io\\MiscStream")
public class MiscStream
extends Stream {
    protected boolean canRead = true;
    protected int position = 0;
    protected boolean eof = true;
    protected MemoryStream memoryStream;
    protected InputStream inputStream;
    protected OutputStream outputStream;

    public MiscStream(Environment env, InputStream inputStream) {
        super(env);
        this.inputStream = inputStream;
    }

    public MiscStream(Environment env, OutputStream outputStream) {
        super(env);
        this.outputStream = outputStream;
    }

    public MiscStream(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    private void throwCannotRead(Environment env) {
        env.exception(WrapIOException.class, "Cannot read stream", new Object[0]);
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="path"), @Reflection.Arg(value="mode", optional=@Reflection.Optional(value="r"))})
    public Memory __construct(Environment env, Memory ... args) throws IOException {
        super.__construct(env, args);
        String path = this.getPath();
        if ("memory".equals(path)) {
            this.memoryStream = new MemoryStream();
        } else if ("stdout".endsWith(path)) {
            this.outputStream = System.out;
        } else if ("stdin".equals(path)) {
            this.inputStream = System.in;
        } else if ("stderr".equals(path)) {
            this.outputStream = System.err;
        } else {
            env.exception(WrapIOException.class, "Unknown type stream - %s", path);
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="value"), @Reflection.Arg(value="length", optional=@Reflection.Optional(value="NULL"))})
    public Memory write(Environment env, Memory ... args) throws IOException {
        int len = args[1].toInteger();
        byte[] bytes = args[0].getBinaryBytes(env.getDefaultCharset());
        this.eof = false;
        int n = len = len == 0 || len > bytes.length ? bytes.length : len;
        if (this.memoryStream != null) {
            this.memoryStream.write(bytes, 0, len);
            return LongMemory.valueOf(len);
        }
        if (this.outputStream != null) {
            this.outputStream.write(bytes, 0, len);
            this.position += len;
            this.inputStream = null;
            return LongMemory.valueOf(len);
        }
        if (this.inputStream != null) {
            env.exception(WrapIOException.class, "Cannot write to input stream", new Object[0]);
            return Memory.CONST_INT_0;
        }
        return Memory.CONST_INT_0;
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="length")})
    public Memory read(Environment env, Memory ... args) throws IOException {
        int len;
        if (!this.canRead) {
            this.throwCannotRead(env);
        }
        if ((len = args[0].toInteger()) <= 0) {
            return Memory.FALSE;
        }
        if (this.memoryStream != null) {
            byte[] result = this.memoryStream.read(len);
            if (result == null) {
                return Memory.FALSE;
            }
            return new BinaryMemory(result);
        }
        if (this.inputStream != null) {
            byte[] buf = new byte[len];
            int read = this.inputStream.read(buf);
            boolean bl = this.eof = read == -1;
            if (read == -1) {
                return Memory.FALSE;
            }
            this.position += read;
            return new BinaryMemory(Arrays.copyOf(buf, read));
        }
        throw new IOException("Cannot read from output stream");
    }

    @Override
    @Reflection.Signature
    public Memory readFully(Environment env, Memory ... args) throws IOException {
        if (this.memoryStream != null) {
            byte[] result = this.memoryStream.readFully();
            if (result != null) {
                return new BinaryMemory(result);
            }
            return Memory.FALSE;
        }
        if (this.inputStream != null) {
            int len;
            byte[] buff = new byte[1024];
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            while ((len = this.inputStream.read(buff)) > 0) {
                tmp.write(buff, 0, len);
            }
            return new BinaryMemory(tmp.toByteArray());
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory eof(Environment env, Memory ... args) {
        if (this.memoryStream != null) {
            return this.memoryStream.eof() ? Memory.TRUE : Memory.FALSE;
        }
        return this.eof ? Memory.TRUE : Memory.FALSE;
    }

    @Override
    @Reflection.Signature
    public Memory close(Environment env, Memory ... args) throws IOException {
        if (this.memoryStream != null) {
            this.memoryStream.close();
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        } else if (this.outputStream != null) {
            this.outputStream.close();
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory getPosition(Environment env, Memory ... args) {
        if (this.memoryStream != null) {
            return LongMemory.valueOf(this.position);
        }
        return LongMemory.valueOf(this.position);
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="position")})
    public Memory seek(Environment env, Memory ... args) {
        if (this.memoryStream != null) {
            if (!this.memoryStream.seek(args[0].toInteger())) {
                env.exception(WrapIOException.class, "Cannot seek to %s", args[0].toInteger());
            }
            this.position = args[0].toInteger();
        } else {
            env.exception(WrapIOException.class, "Cannot seek in input/output stream", new Object[0]);
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory length(Environment env, Memory ... args) {
        if (this.memoryStream != null) {
            return LongMemory.valueOf(this.memoryStream.length);
        }
        env.exception(WrapIOException.class, "Unsupported method for this type stream", new Object[0]);
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory flush(Environment env, Memory ... args) throws IOException {
        if (this.outputStream == null) {
            env.exception(WrapIOException.class, "Only output stream support flush()", new Object[0]);
        } else {
            this.outputStream.flush();
        }
        return Memory.NULL;
    }
}

