/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import java.nio.charset.Charset;
import php.runtime.Memory;
import php.runtime.OperatorUtils;
import php.runtime.env.TraceInfo;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;

public class StringMemory
extends Memory {
    String value = "";
    protected static final StringMemory[] CACHED_CHARS = new StringMemory[65534];

    public StringMemory(String value) {
        super(Memory.Type.STRING);
        this.value = value == null ? "" : value;
    }

    public StringMemory(char ch) {
        this(String.valueOf(ch));
    }

    public static Memory valueOf(String value) {
        if (value == null) {
            return NULL;
        }
        if (value.isEmpty()) {
            return Memory.CONST_EMPTY_STRING;
        }
        if (value.length() == 1) {
            return StringMemory.getChar(value.charAt(0));
        }
        return new StringMemory(value);
    }

    public static Memory valueOf(char ch) {
        return StringMemory.getChar(ch);
    }

    @Override
    public long toLong() {
        return this.toLongNumeric().toLong();
    }

    @Override
    public double toDouble() {
        return this.toNumeric().toDouble();
    }

    @Override
    public boolean toBoolean() {
        String value = this.toString();
        return value != null && !value.isEmpty() && !value.equals("0");
    }

    @Override
    public String toString() {
        return this.value;
    }

    public static Memory toLong(String value) {
        return StringMemory.toLong(value, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Memory toLong(String value, boolean bigNumbers) {
        int i;
        int len = value.length();
        if (len == 0) {
            return null;
        }
        int start = i = 0;
        boolean neg = false;
        while (i < len) {
            char ch = value.charAt(i);
            if ('9' < ch || ch < '0') {
                if (ch != '-') return null;
                if (i != start) return null;
                neg = true;
            } else {
                neg = false;
            }
            ++i;
        }
        if (neg) {
            return null;
        }
        try {
            return LongMemory.valueOf(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            if (!bigNumbers) return null;
            Memory memory = StringMemory.valueOf(value);
            return memory;
        }
    }

    public static Memory toNumeric(String value) {
        return StringMemory.toNumeric(value, false, CONST_INT_0);
    }

    public Memory toLongNumeric() {
        return StringMemory.toNumeric(this.value, true, CONST_INT_0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Memory toNumeric(String value, boolean onlyInt, Memory def) {
        char ch;
        int i;
        int len = value.length();
        boolean real = false;
        for (i = 0; i < len && (ch = value.charAt(i)) <= ' '; ++i) {
        }
        int start = i;
        boolean canSign = true;
        boolean e_char = false;
        if (start == len) {
            return def;
        }
        while (i < len) {
            block20: {
                block21: {
                    char ch2;
                    block22: {
                        ch2 = value.charAt(i);
                        if ('9' >= ch2 && ch2 >= '0') break block21;
                        if (!canSign || ch2 != '-' && ch2 != '+') break block22;
                        canSign = false;
                        if (start == i && ch2 == '+') {
                            ++start;
                        }
                        break block20;
                    }
                    if (!(e_char || i == start || ch2 != 'e' && ch2 != 'E' || value.charAt(i - 1) == '.')) {
                        if (onlyInt) break;
                        e_char = true;
                        real = true;
                        canSign = true;
                        break block20;
                    } else {
                        canSign = false;
                        if (ch2 == '.') {
                            if (real || onlyInt) break;
                            real = true;
                            break block20;
                        } else {
                            if (i != start && value.charAt(i - 1) != '-' && value.charAt(i - 1) != '+') break;
                            return def;
                        }
                    }
                }
                canSign = false;
            }
            ++i;
        }
        if (real) {
            if (len == 1 || len == 0) {
                return def;
            }
            try {
                if (len == i && start == 0) {
                    return new DoubleMemory(Double.parseDouble(value));
                }
                return new DoubleMemory(Double.parseDouble(value.substring(start, i)));
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        if (len == 0) {
            return def;
        }
        try {
            if (len == i && start == 0) {
                return LongMemory.valueOf(Long.parseLong(value));
            }
            return LongMemory.valueOf(Long.parseLong(value.substring(start, i)));
        }
        catch (NumberFormatException e) {
            try {
                if (len == i && start == 0) {
                    return new DoubleMemory(Double.parseDouble(value));
                }
                return new DoubleMemory(Double.parseDouble(value.substring(start, i)));
            }
            catch (NumberFormatException e2) {
                return def;
            }
        }
    }

    @Override
    public Memory toNumeric() {
        return StringMemory.toNumeric(this.value);
    }

    @Override
    public Memory inc() {
        String str = this.toString();
        if (str.isEmpty()) {
            return CONST_INT_1;
        }
        char ch = str.charAt(str.length() - 1);
        Memory ret = StringMemory.toNumeric(str, false, null);
        if (ret == null || !Character.isDigit(ch)) {
            int i;
            StringBuilder sb = new StringBuilder();
            int length = str.length();
            int type = -1;
            for (i = length - 1; i >= -1; --i) {
                if (i < 0) {
                    switch (type) {
                        case 0: {
                            sb.append('0');
                            break;
                        }
                        case 1: {
                            sb.append('a');
                            break;
                        }
                        case 2: {
                            sb.append('A');
                        }
                    }
                    break;
                }
                ch = str.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    type = 0;
                } else if (ch >= 'a' && ch <= 'z') {
                    type = 1;
                } else if (ch >= 'A' && ch <= 'Z') {
                    type = 2;
                } else {
                    ++i;
                    break;
                }
                ch = (char)(ch + '\u0001');
                boolean next = false;
                switch (type) {
                    case 0: {
                        if (ch <= '9') break;
                        ch = '0';
                        next = true;
                        break;
                    }
                    case 1: {
                        if (ch <= 'z') break;
                        ch = 'a';
                        next = true;
                        break;
                    }
                    case 2: {
                        if (ch <= 'Z') break;
                        ch = 'A';
                        next = true;
                    }
                }
                if (type > -1) {
                    sb.insert(0, ch);
                }
                if (!next) break;
            }
            if (i > 0) {
                sb.insert(0, str.substring(0, i));
            }
            return new StringMemory(sb.toString());
        }
        return ret.inc();
    }

    @Override
    public Memory dec() {
        String str = this.toString();
        Memory ret = StringMemory.toNumeric(str, false, null);
        if (ret == null || str.isEmpty() || !Character.isDigit(str.charAt(str.length() - 1))) {
            return this;
        }
        return ret.dec();
    }

    @Override
    public Memory negative() {
        return this.toNumeric().negative();
    }

    @Override
    public Memory plus(Memory memory) {
        return this.toNumeric().plus(memory);
    }

    @Override
    public Memory minus(Memory memory) {
        return this.toNumeric().minus(memory);
    }

    @Override
    public Memory mul(Memory memory) {
        return this.toNumeric().mul(memory);
    }

    @Override
    public Memory pow(Memory memory) {
        return this.toNumeric().pow(memory);
    }

    @Override
    public Memory div(Memory memory) {
        return this.toNumeric().div(memory);
    }

    @Override
    public Memory div(long value) {
        return this.toNumeric().div(value);
    }

    @Override
    public Memory div(boolean value) {
        return this.div(value ? 1L : 0L);
    }

    @Override
    public Memory div(double value) {
        return this.toNumeric().div(value);
    }

    @Override
    public Memory div(String value) {
        return this.toNumeric().div(value);
    }

    @Override
    public boolean identical(Memory memory) {
        return memory.getRealType() == Memory.Type.STRING && this.toString().equals(memory.toString());
    }

    @Override
    public boolean equal(Memory memory) {
        switch (memory.type) {
            case NULL: {
                return this.toString().equals("");
            }
            case DOUBLE: 
            case INT: {
                return this.toNumeric().equal(memory);
            }
            case STRING: {
                return this.toString().equals(memory.toString());
            }
            case OBJECT: 
            case ARRAY: {
                return false;
            }
            case BOOL: {
                return memory.equal(this.value);
            }
        }
        return this.equal(memory.toValue());
    }

    @Override
    public boolean equal(long value) {
        return this.toNumeric().equal(value);
    }

    @Override
    public boolean equal(double value) {
        return this.toNumeric().equal(value);
    }

    @Override
    public boolean equal(String value) {
        return this.toString().equals(value);
    }

    @Override
    public boolean notEqual(Memory memory) {
        return !this.equal(memory);
    }

    @Override
    public Memory minus(long value) {
        return this.toNumeric().minus(value);
    }

    @Override
    public String concat(Memory memory) {
        switch (memory.type) {
            case STRING: {
                return this.toString().concat(memory.toString());
            }
            case REFERENCE: {
                return this.concat(memory.toValue());
            }
        }
        return this.toString() + memory.toString();
    }

    @Override
    public boolean smaller(Memory memory) {
        switch (memory.type) {
            case STRING: {
                return this.toString().compareTo(memory.toString()) < 0;
            }
            case REFERENCE: {
                return this.smaller(memory.toValue());
            }
        }
        return this.toNumeric().smaller(memory);
    }

    @Override
    public boolean smaller(String value) {
        return this.toString().compareTo(value) < 0;
    }

    @Override
    public boolean smallerEq(Memory memory) {
        switch (memory.type) {
            case STRING: {
                return this.toString().compareTo(memory.toString()) <= 0;
            }
            case REFERENCE: {
                return this.smaller(memory.toValue());
            }
        }
        return this.toNumeric().smallerEq(memory);
    }

    @Override
    public boolean smallerEq(String value) {
        return this.toString().compareTo(value) <= 0;
    }

    @Override
    public boolean greater(Memory memory) {
        switch (memory.type) {
            case STRING: {
                return this.toString().compareTo(memory.toString()) > 0;
            }
            case REFERENCE: {
                return this.greater(memory.toValue());
            }
        }
        return this.toNumeric().greater(memory);
    }

    @Override
    public boolean greater(String value) {
        return this.toString().compareTo(value) > 0;
    }

    @Override
    public boolean greaterEq(Memory memory) {
        switch (memory.type) {
            case STRING: {
                return this.toString().compareTo(memory.toString()) >= 0;
            }
            case REFERENCE: {
                return this.greaterEq(memory.toValue());
            }
        }
        return this.toNumeric().greaterEq(memory);
    }

    @Override
    public boolean greaterEq(String value) {
        return this.toString().compareTo(value) >= 0;
    }

    @Override
    public String concat(String value) {
        return this.toString().concat(value);
    }

    @Override
    public Memory bitAnd(Memory memory) {
        if (memory.isString()) {
            return OperatorUtils.binaryAnd(this, memory);
        }
        return super.bitAnd(memory);
    }

    @Override
    public Memory bitAnd(String memory) {
        return OperatorUtils.binaryAnd(this, new StringMemory(memory));
    }

    @Override
    public Memory bitOr(Memory memory) {
        if (memory.isString()) {
            return OperatorUtils.binaryOr(this, memory);
        }
        return super.bitOr(memory);
    }

    @Override
    public Memory bitOr(String memory) {
        return OperatorUtils.binaryOr(this, new StringMemory(memory));
    }

    @Override
    public Memory bitXor(Memory memory) {
        if (memory.isString()) {
            return OperatorUtils.binaryXor(this, memory);
        }
        return super.bitXor(memory);
    }

    @Override
    public Memory bitXor(String memory) {
        return OperatorUtils.binaryXor(this, new StringMemory(memory));
    }

    @Override
    public Memory bitNot() {
        return OperatorUtils.binaryNot(this);
    }

    @Override
    public Memory bitShr(Memory memory) {
        return this.toLongNumeric().bitShr(memory);
    }

    @Override
    public Memory bitShr(String memory) {
        return this.toLongNumeric().bitShr(memory);
    }

    @Override
    public Memory bitShl(Memory memory) {
        return this.toLongNumeric().bitShl(memory);
    }

    @Override
    public Memory bitShl(String memory) {
        return this.toLongNumeric().bitShl(memory);
    }

    @Override
    public Memory bitShrRight(String value) {
        return StringMemory.toNumeric(value, true, CONST_INT_0).bitShr(this);
    }

    @Override
    public Memory bitShlRight(String value) {
        return StringMemory.toNumeric(value, true, CONST_INT_0).bitShl(this);
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, Memory index) {
        int _index = -1;
        switch (index.type) {
            case STRING: {
                Memory tmp = StringMemory.toLong(index.toString());
                if (tmp == null) break;
                _index = tmp.toInteger();
                break;
            }
            case REFERENCE: {
                return this.valueOfIndex(index.toValue());
            }
            default: {
                _index = index.toInteger();
            }
        }
        if (_index < this.toString().length() && _index >= 0) {
            return StringMemory.getChar(this.value.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, long index) {
        int _index = (int)index;
        String string = this.toString();
        if (_index >= 0 && _index < string.length()) {
            return StringMemory.getChar(string.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, double index) {
        int _index = (int)index;
        String string = this.toString();
        if (_index >= 0 && _index < string.length()) {
            return StringMemory.getChar(string.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, boolean index) {
        int _index = index ? 1 : 0;
        String string = this.toString();
        if (_index >= 0 && _index < string.length()) {
            return StringMemory.getChar(string.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, String index) {
        int _index = -1;
        Memory tmp = StringMemory.toLong(index);
        if (tmp != null) {
            _index = tmp.toInteger();
        }
        String string = this.toString();
        if (_index >= 0 && _index < string.length()) {
            return StringMemory.getChar(string.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public byte[] getBinaryBytes(Charset charset) {
        return this.toString().getBytes(charset);
    }

    @Override
    public boolean identical(long value) {
        return false;
    }

    @Override
    public boolean identical(double value) {
        return false;
    }

    @Override
    public boolean identical(boolean value) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringMemory that = (StringMemory)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    @Override
    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    protected static StringMemory getChar(char ch) {
        char i = ch;
        if (i >= CACHED_CHARS.length) {
            return new StringMemory(ch);
        }
        StringMemory memory = CACHED_CHARS[i];
        if (memory == null) {
            memory = StringMemory.CACHED_CHARS[i] = new StringMemory(ch);
        }
        return memory;
    }
}

