/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.support;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.common.Pair;
import php.runtime.common.collections.IterableMap;
import php.runtime.common.collections.MapIterator;
import php.runtime.common.collections.OrderedIterator;
import php.runtime.common.collections.OrderedMap;
import php.runtime.common.collections.OrderedMapIterator;
import php.runtime.common.collections.ResettableIterator;
import php.runtime.common.collections.iterators.EmptyIterator;
import php.runtime.common.collections.iterators.EmptyMapIterator;
import php.runtime.common.collections.iterators.EmptyOrderedMapIterator;
import php.runtime.common.collections.iterators.UnmodifiableIterator;
import php.runtime.common.collections.iterators.UnmodifiableListIterator;
import php.runtime.common.collections.list.UnmodifiableList;
import php.runtime.memory.support.ArrayMapEntryMemory;

public class ArrayMemoryMap
extends AbstractMap<Object, Memory>
implements IterableMap<Object, Memory>,
OrderedMap<Object, Memory>,
Serializable {
    private static final long serialVersionUID = 9077238323521161066L;
    protected static final String NO_NEXT_ENTRY = "No next() entry in the iteration";
    protected static final String NO_PREVIOUS_ENTRY = "No previous() entry in the iteration";
    protected static final String REMOVE_INVALID = "remove() can only be called once after next()";
    protected static final String GETKEY_INVALID = "getKey() can only be called after next() and before remove()";
    protected static final String GETVALUE_INVALID = "getValue() can only be called after next() and before remove()";
    protected static final String SETVALUE_INVALID = "setValue() can only be called after next() and before remove()";
    protected static final int DEFAULT_CAPACITY = 11;
    protected static final int DEFAULT_THRESHOLD = 8;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static final Object NULL = new Object();
    protected transient float loadFactor;
    protected transient int size;
    protected transient ArrayMapEntryMemory[] data;
    protected transient int threshold;
    protected transient int modCount;
    protected transient EntrySet entrySet;
    protected transient KeySet keySet;
    protected transient Values values;
    protected transient ArrayMapEntryMemory header;

    public ArrayMemoryMap() {
        this(11, 0.75f, 8);
    }

    protected ArrayMemoryMap(int initialCapacity, float loadFactor, int threshold) {
        this.loadFactor = loadFactor;
        this.data = new ArrayMapEntryMemory[initialCapacity];
        this.threshold = threshold;
        this.init();
    }

    public ArrayMemoryMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ArrayMemoryMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor must be greater than 0");
        }
        this.loadFactor = loadFactor;
        this.threshold = this.calculateThreshold(initialCapacity, loadFactor);
        initialCapacity = this.calculateNewCapacity(initialCapacity);
        this.data = new ArrayMapEntryMemory[initialCapacity];
        this.init();
    }

    public ArrayMemoryMap(ArrayMemoryMap map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    protected void init() {
        this.header.before = this.header.after = (this.header = new ArrayMapEntryMemory(null, -1, null, null));
    }

    public Object get(int index) {
        return this.getEntry(index).getKey();
    }

    public Memory getValue(int index) {
        return this.getEntry(index).getValue();
    }

    public int indexOf(Object key) {
        int i = 0;
        ArrayMapEntryMemory entry = this.header.after;
        while (entry != this.header) {
            if (this.isEqualKey(key, entry.getKey())) {
                return i;
            }
            entry = entry.after;
            ++i;
        }
        return -1;
    }

    public Memory remove(int index) {
        return this.remove(this.get(index));
    }

    public List<Object> asList() {
        return new LinkedMapList(this);
    }

    @Override
    public Memory get(Object key) {
        int hashCode = this.hash(key == null ? NULL : key);
        ArrayMapEntryMemory entry = this.data[this.hashIndex(hashCode, this.data.length)];
        while (entry != null) {
            if (entry.hashCode == hashCode && this.isEqualKey(key, entry.getKey())) {
                return entry.getValue();
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        int hashCode = this.hash(key == null ? NULL : key);
        ArrayMapEntryMemory entry = this.data[this.hashIndex(hashCode, this.data.length)];
        while (entry != null) {
            if (entry.hashCode == hashCode && this.isEqualKey(key, entry.getKey())) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            ArrayMapEntryMemory entry = this.header.after;
            while (entry != this.header) {
                if (entry.getValue() == null) {
                    return true;
                }
                entry = entry.after;
            }
        } else {
            ArrayMapEntryMemory entry = this.header.after;
            while (entry != this.header) {
                if (this.isEqualValue(value, entry.getValue())) {
                    return true;
                }
                entry = entry.after;
            }
        }
        return false;
    }

    @Override
    public Memory put(Object key, Memory value) {
        return this.putWithEntry(key, value).getA();
    }

    public Pair<Memory, ArrayMapEntryMemory> putWithEntry(Object key, Memory value) {
        int hashCode = this.hash(key == null ? NULL : key);
        int index = this.hashIndex(hashCode, this.data.length);
        ArrayMapEntryMemory entry = this.data[index];
        while (entry != null) {
            if (entry.hashCode == hashCode && this.isEqualKey(key, entry.getKey())) {
                Object oldValue = entry.getValue();
                this.updateEntry(entry, value);
                return new Pair<Object, ArrayMapEntryMemory>(oldValue, entry);
            }
            entry = entry.next;
        }
        entry = this.addMapping(index, hashCode, key, value);
        return new Pair<Object, ArrayMapEntryMemory>(null, entry);
    }

    public void putAll(ArrayMemoryMap map) {
        int mapSize = map.size();
        if (mapSize == 0) {
            return;
        }
        int newSize = (int)((float)(this.size + mapSize) / this.loadFactor + 1.0f);
        this.ensureCapacity(this.calculateNewCapacity(newSize));
        for (ArrayMapEntryMemory arrayMapEntryMemory : map.entrySet()) {
            this.put(arrayMapEntryMemory.getKey(), (Memory)arrayMapEntryMemory.getValue());
        }
    }

    @Override
    public Memory remove(Object key) {
        int hashCode = this.hash(key == null ? NULL : key);
        int index = this.hashIndex(hashCode, this.data.length);
        ArrayMapEntryMemory entry = this.data[index];
        ArrayMapEntryMemory previous = null;
        while (entry != null) {
            if (entry.hashCode == hashCode && this.isEqualKey(key, entry.getKey())) {
                Object oldValue = entry.getValue();
                this.removeMapping(entry, index, previous);
                return oldValue;
            }
            previous = entry;
            entry = entry.next;
        }
        return null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        ArrayMapEntryMemory[] data = this.data;
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = null;
        }
        this.size = 0;
        this.header.before = this.header.after = this.header;
    }

    @Override
    public Object firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return this.header.after.getKey();
    }

    @Override
    public Object lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return this.header.before.getKey();
    }

    @Override
    public Object nextKey(Object key) {
        ArrayMapEntryMemory entry = this.getEntry(key);
        return entry == null || entry.after == this.header ? null : entry.after.getKey();
    }

    @Override
    public Object previousKey(Object key) {
        ArrayMapEntryMemory entry = this.getEntry(key);
        return entry == null || entry.before == this.header ? null : entry.before.getKey();
    }

    protected int hash(Object key) {
        return key.hashCode();
    }

    protected boolean isEqualKey(Object key1, Object key2) {
        return key1 == key2 || key1 != null && key1.equals(key2);
    }

    protected boolean isEqualValue(Object value1, Object value2) {
        return value1 == value2 || value1.equals(value2);
    }

    protected int hashIndex(int hashCode, int dataSize) {
        return hashCode & dataSize - 1;
    }

    public ArrayMapEntryMemory getEntry(Object key) {
        int hashCode = this.hash(key == null ? NULL : key);
        ArrayMapEntryMemory entry = this.data[this.hashIndex(hashCode, this.data.length)];
        while (entry != null) {
            if (entry.hashCode == hashCode && this.isEqualKey(key, entry.getKey())) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    protected ArrayMapEntryMemory getEntry(int index) {
        ArrayMapEntryMemory entry;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " is less than zero");
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " is invalid for size " + this.size);
        }
        if (index < this.size / 2) {
            entry = this.header.after;
            for (int currentIndex = 0; currentIndex < index; ++currentIndex) {
                entry = entry.after;
            }
        } else {
            entry = this.header;
            for (int currentIndex = this.size; currentIndex > index; --currentIndex) {
                entry = entry.before;
            }
        }
        return entry;
    }

    protected void updateEntry(ArrayMapEntryMemory entry, Memory newValue) {
        entry.setValue(newValue);
    }

    protected void reuseEntry(ArrayMapEntryMemory entry, int hashIndex, int hashCode, Object key, Memory value) {
        entry.next = this.data[hashIndex];
        entry.hashCode = hashCode;
        entry.setKey(key);
        entry.setValue(value);
    }

    protected ArrayMapEntryMemory addMapping(int hashIndex, int hashCode, Object key, Memory value) {
        ++this.modCount;
        ArrayMapEntryMemory entry = new ArrayMapEntryMemory(this.data[hashIndex], hashCode, key, value);
        this.addEntry(entry, hashIndex);
        ++this.size;
        this.checkCapacity();
        return entry;
    }

    protected void addEntry(ArrayMapEntryMemory entry, int hashIndex) {
        ArrayMapEntryMemory link = entry;
        link.after = this.header;
        link.before = this.header.before;
        this.header.before.after = link;
        this.header.before = link;
        this.data[hashIndex] = entry;
    }

    protected void removeMapping(ArrayMapEntryMemory entry, int hashIndex, ArrayMapEntryMemory previous) {
        ++this.modCount;
        this.removeEntry(entry, hashIndex, previous);
        --this.size;
        this.destroyEntry(entry);
    }

    protected void removeEntry(ArrayMapEntryMemory entry, int hashIndex, ArrayMapEntryMemory previous) {
        ArrayMapEntryMemory link = entry;
        link.before.after = link.after;
        link.after.before = link.before;
        link.after = null;
        link.before = null;
        if (previous == null) {
            this.data[hashIndex] = entry.next;
        } else {
            previous.next = entry.next;
        }
    }

    protected ArrayMapEntryMemory entryBefore(ArrayMapEntryMemory entry) {
        return entry.before;
    }

    protected ArrayMapEntryMemory entryAfter(ArrayMapEntryMemory entry) {
        return entry.after;
    }

    protected void destroyEntry(ArrayMapEntryMemory entry) {
        entry.next = null;
        entry.setKey(null);
        entry.setValue(null);
    }

    protected void checkCapacity() {
        int newCapacity;
        if (this.size >= this.threshold && (newCapacity = this.data.length * 2) <= 0x40000000) {
            this.ensureCapacity(newCapacity);
        }
    }

    protected void ensureCapacity(int newCapacity) {
        int oldCapacity = this.data.length;
        if (newCapacity <= oldCapacity) {
            return;
        }
        if (this.size == 0) {
            this.threshold = this.calculateThreshold(newCapacity, this.loadFactor);
            this.data = new ArrayMapEntryMemory[newCapacity];
        } else {
            ArrayMapEntryMemory[] oldEntries = this.data;
            ArrayMapEntryMemory[] newEntries = new ArrayMapEntryMemory[newCapacity];
            ++this.modCount;
            for (int i = oldCapacity - 1; i >= 0; --i) {
                ArrayMapEntryMemory next;
                ArrayMapEntryMemory entry = oldEntries[i];
                if (entry == null) continue;
                oldEntries[i] = null;
                do {
                    next = entry.next;
                    int index = this.hashIndex(entry.hashCode, newCapacity);
                    entry.next = newEntries[index];
                    newEntries[index] = entry;
                } while ((entry = next) != null);
            }
            this.threshold = this.calculateThreshold(newCapacity, this.loadFactor);
            this.data = newEntries;
        }
    }

    protected int calculateNewCapacity(int proposedCapacity) {
        int newCapacity;
        if (proposedCapacity > 0x40000000) {
            newCapacity = 0x40000000;
        } else {
            for (newCapacity = 1; newCapacity < proposedCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > 0x40000000) {
                newCapacity = 0x40000000;
            }
        }
        return newCapacity;
    }

    protected int calculateThreshold(int newCapacity, float factor) {
        return (int)((float)newCapacity * factor);
    }

    protected ArrayMapEntryMemory entryNext(ArrayMapEntryMemory entry) {
        return entry.next;
    }

    protected int entryHashCode(ArrayMapEntryMemory entry) {
        return entry.hashCode;
    }

    protected Object entryKey(ArrayMapEntryMemory entry) {
        return entry.getKey();
    }

    protected Memory entryValue(ArrayMapEntryMemory entry) {
        return entry.getValue();
    }

    @Override
    public MapIterator<Object, Memory> mapIterator() {
        if (this.size == 0) {
            return EmptyMapIterator.INSTANCE;
        }
        return new LinkMapIterator(this);
    }

    public Iterator entriesIterator() {
        return new EntriesIterator(this);
    }

    @Override
    public OrderedMapIterator<Object, Memory> orderedMapIterator() {
        if (this.size == 0) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new LinkMapIterator(this);
    }

    @Override
    public Set<Map.Entry<Object, Memory>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    protected Iterator<Map.Entry<Object, Memory>> createEntrySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new EntrySetIterator(this);
    }

    @Override
    public Set<Object> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    protected Iterator<Object> createKeySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new KeySetIterator(this);
    }

    @Override
    public Collection<Memory> values() {
        if (this.values == null) {
            this.values = new Values(this);
        }
        return this.values;
    }

    protected Iterator<Memory> createValuesIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new ValuesIterator(this);
    }

    protected static abstract class LinkIterator {
        protected final ArrayMemoryMap parent;
        protected ArrayMapEntryMemory last;
        protected ArrayMapEntryMemory next;
        protected int expectedModCount;

        protected LinkIterator(ArrayMemoryMap parent) {
            this.parent = parent;
            this.next = parent.header.after;
            this.expectedModCount = parent.modCount;
        }

        public boolean hasNext() {
            return this.next != this.parent.header;
        }

        public boolean hasPrevious() {
            return this.next.before != this.parent.header;
        }

        protected ArrayMapEntryMemory nextEntry() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == this.parent.header) {
                throw new NoSuchElementException(ArrayMemoryMap.NO_NEXT_ENTRY);
            }
            this.last = this.next;
            this.next = this.next.after;
            return this.last;
        }

        protected ArrayMapEntryMemory previousEntry() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ArrayMapEntryMemory previous = this.next.before;
            if (previous == this.parent.header) {
                throw new NoSuchElementException(ArrayMemoryMap.NO_PREVIOUS_ENTRY);
            }
            this.next = previous;
            this.last = previous;
            return this.last;
        }

        protected ArrayMapEntryMemory currentEntry() {
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException(ArrayMemoryMap.REMOVE_INVALID);
            }
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.parent.remove(this.last.getKey());
            this.last = null;
            this.expectedModCount = this.parent.modCount;
        }

        public void reset() {
            this.last = null;
            this.next = this.parent.header.after;
        }

        public String toString() {
            if (this.last != null) {
                return "Iterator[" + this.last.getKey() + "=" + this.last.getValue() + "]";
            }
            return "Iterator[]";
        }
    }

    protected static class Values
    extends AbstractCollection<Memory> {
        protected final ArrayMemoryMap parent;

        protected Values(ArrayMemoryMap parent) {
            this.parent = parent;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.parent.containsValue(value);
        }

        @Override
        public Iterator<Memory> iterator() {
            return this.parent.createValuesIterator();
        }
    }

    protected static class KeySet
    extends AbstractSet<Object> {
        protected final ArrayMemoryMap parent;

        protected KeySet(ArrayMemoryMap parent) {
            this.parent = parent;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public boolean contains(Object key) {
            return this.parent.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            boolean result = this.parent.containsKey(key);
            this.parent.remove(key);
            return result;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.parent.createKeySetIterator();
        }
    }

    protected static class EntrySet
    extends AbstractSet<Map.Entry<Object, Memory>> {
        protected final ArrayMemoryMap parent;

        protected EntrySet(ArrayMemoryMap parent) {
            this.parent = parent;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        public boolean contains(ArrayMapEntryMemory entry) {
            ArrayMapEntryMemory e = entry;
            ArrayMapEntryMemory match = this.parent.getEntry(e.getKey());
            return match != null && match.equals(e);
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof ArrayMapEntryMemory)) {
                return false;
            }
            if (!this.contains(obj)) {
                return false;
            }
            ArrayMapEntryMemory entry = (ArrayMapEntryMemory)obj;
            Object key = entry.getKey();
            this.parent.remove(key);
            return true;
        }

        @Override
        public Iterator<Map.Entry<Object, Memory>> iterator() {
            return this.parent.createEntrySetIterator();
        }
    }

    protected static class EntrySetIterator
    extends LinkIterator
    implements OrderedIterator<Map.Entry<Object, Memory>>,
    ResettableIterator<Map.Entry<Object, Memory>> {
        protected EntrySetIterator(ArrayMemoryMap parent) {
            super(parent);
        }

        @Override
        public ArrayMapEntryMemory next() {
            return super.nextEntry();
        }

        @Override
        public ArrayMapEntryMemory previous() {
            return super.previousEntry();
        }
    }

    protected static class KeySetIterator
    extends LinkIterator
    implements OrderedIterator<Object>,
    ResettableIterator<Object> {
        protected KeySetIterator(ArrayMemoryMap parent) {
            super(parent);
        }

        @Override
        public Object next() {
            return super.nextEntry().getKey();
        }

        @Override
        public Object previous() {
            return super.previousEntry().getKey();
        }
    }

    protected static class ValuesIterator
    extends LinkIterator
    implements OrderedIterator<Memory>,
    ResettableIterator<Memory> {
        protected ValuesIterator(ArrayMemoryMap parent) {
            super(parent);
        }

        @Override
        public Memory next() {
            return super.nextEntry().getValue();
        }

        @Override
        public Memory previous() {
            return super.previousEntry().getValue();
        }
    }

    protected static class EntriesIterator
    extends LinkIterator
    implements OrderedIterator<ArrayMapEntryMemory>,
    ResettableIterator<ArrayMapEntryMemory> {
        protected EntriesIterator(ArrayMemoryMap parent) {
            super(parent);
        }

        @Override
        public ArrayMapEntryMemory next() {
            return super.nextEntry();
        }

        @Override
        public ArrayMapEntryMemory previous() {
            return super.previousEntry();
        }
    }

    protected static class LinkMapIterator
    extends LinkIterator
    implements OrderedMapIterator<Object, Memory>,
    OrderedIterator<Object>,
    ResettableIterator<Object> {
        protected LinkMapIterator(ArrayMemoryMap parent) {
            super(parent);
        }

        @Override
        public Object next() {
            return super.nextEntry().getKey();
        }

        @Override
        public Object previous() {
            return super.previousEntry().getKey();
        }

        @Override
        public Object getKey() {
            ArrayMapEntryMemory current = this.currentEntry();
            if (current == null) {
                throw new IllegalStateException(ArrayMemoryMap.GETKEY_INVALID);
            }
            return current.getKey();
        }

        @Override
        public Memory getValue() {
            ArrayMapEntryMemory current = this.currentEntry();
            if (current == null) {
                throw new IllegalStateException(ArrayMemoryMap.GETVALUE_INVALID);
            }
            return current.getValue();
        }

        @Override
        public Memory setValue(Memory value) {
            ArrayMapEntryMemory current = this.currentEntry();
            if (current == null) {
                throw new IllegalStateException(ArrayMemoryMap.SETVALUE_INVALID);
            }
            return current.setValue(value);
        }
    }

    static class LinkedMapList
    extends AbstractList<Object> {
        final ArrayMemoryMap parent;

        LinkedMapList(ArrayMemoryMap parent) {
            this.parent = parent;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public Object get(int index) {
            return this.parent.get(index);
        }

        @Override
        public boolean contains(Object obj) {
            return this.parent.containsKey(obj);
        }

        @Override
        public int indexOf(Object obj) {
            return this.parent.indexOf(obj);
        }

        @Override
        public int lastIndexOf(Object obj) {
            return this.parent.indexOf(obj);
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.parent.keySet().containsAll(coll);
        }

        @Override
        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return this.parent.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.parent.keySet().toArray(array);
        }

        @Override
        public Iterator<Object> iterator() {
            return UnmodifiableIterator.decorate(this.parent.keySet().iterator());
        }

        @Override
        public ListIterator<Object> listIterator() {
            return UnmodifiableListIterator.decorate(super.listIterator());
        }

        @Override
        public ListIterator<Object> listIterator(int fromIndex) {
            return UnmodifiableListIterator.decorate(super.listIterator(fromIndex));
        }

        @Override
        public List<Object> subList(int fromIndexInclusive, int toIndexExclusive) {
            return UnmodifiableList.decorate(super.subList(fromIndexInclusive, toIndexExclusive));
        }
    }
}

