/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.systemtray.event;

import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javax.swing.SwingUtilities;
import org.develnext.jphp.ext.javafx.support.EventProvider;

public class TrayIconEventAdapter
extends EventProvider<TrayIcon> {
    public TrayIconEventAdapter() {
        this.setHandler("click", new EventProvider.Handler(){

            public void set(TrayIcon target, EventHandler eventHandler) {
                target.addMouseListener(new ClickEventAdapter(target, eventHandler));
            }

            public EventHandler get(TrayIcon target) {
                for (MouseListener listener : target.getMouseListeners()) {
                    if (!(listener instanceof ClickEventAdapter)) continue;
                    return ((ClickEventAdapter)listener).getEventHandler();
                }
                return null;
            }
        });
        this.setHandler("mouseMove", new EventProvider.Handler(){

            public void set(TrayIcon target, EventHandler eventHandler) {
                target.addMouseListener(new MouseMoveEventAdapter(target, eventHandler));
            }

            public EventHandler get(TrayIcon target) {
                for (MouseListener listener : target.getMouseListeners()) {
                    if (!(listener instanceof MouseMoveEventAdapter)) continue;
                    return ((MouseEventAdapter)listener).getEventHandler();
                }
                return null;
            }
        });
        this.setHandler("mouseEnter", new EventProvider.Handler(){

            public void set(TrayIcon target, EventHandler eventHandler) {
                target.addMouseListener(new MouseEnterEventAdapter(target, eventHandler));
            }

            public EventHandler get(TrayIcon target) {
                for (MouseListener listener : target.getMouseListeners()) {
                    if (!(listener instanceof MouseEnterEventAdapter)) continue;
                    return ((MouseEventAdapter)listener).getEventHandler();
                }
                return null;
            }
        });
        this.setHandler("mouseExit", new EventProvider.Handler(){

            public void set(TrayIcon target, EventHandler eventHandler) {
                target.addMouseListener(new MouseExitEventAdapter(target, eventHandler));
            }

            public EventHandler get(TrayIcon target) {
                for (MouseListener listener : target.getMouseListeners()) {
                    if (!(listener instanceof MouseExitEventAdapter)) continue;
                    return ((MouseEventAdapter)listener).getEventHandler();
                }
                return null;
            }
        });
    }

    protected static MouseEvent convertToJavaFx(Object target, EventType eventType, java.awt.event.MouseEvent e) {
        MouseButton button = MouseButton.NONE;
        if (SwingUtilities.isLeftMouseButton(e)) {
            button = MouseButton.PRIMARY;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            button = MouseButton.SECONDARY;
        }
        if (SwingUtilities.isMiddleMouseButton(e)) {
            button = MouseButton.MIDDLE;
        }
        return new MouseEvent(target, null, eventType, (double)e.getX(), (double)e.getY(), (double)e.getXOnScreen(), (double)e.getYOnScreen(), button, e.getClickCount(), false, false, false, false, button == MouseButton.PRIMARY, button == MouseButton.MIDDLE, button == MouseButton.SECONDARY, false, false, false, new PickResult(null, (double)e.getXOnScreen(), (double)e.getYOnScreen()));
    }

    public Class<TrayIcon> getTargetClass() {
        return TrayIcon.class;
    }

    static class MouseExitEventAdapter
    extends MouseEventAdapter {
        protected MouseExitEventAdapter(Object target, EventHandler eventHandler) {
            super(target, eventHandler);
        }

        @Override
        public void mouseExited(java.awt.event.MouseEvent e) {
            Platform.runLater(() -> this.eventHandler.handle((Event)TrayIconEventAdapter.convertToJavaFx(this.target, MouseEvent.MOUSE_EXITED, e)));
        }
    }

    static class MouseEnterEventAdapter
    extends MouseEventAdapter {
        protected MouseEnterEventAdapter(Object target, EventHandler eventHandler) {
            super(target, eventHandler);
        }

        @Override
        public void mouseEntered(java.awt.event.MouseEvent e) {
            Platform.runLater(() -> this.eventHandler.handle((Event)TrayIconEventAdapter.convertToJavaFx(this.target, MouseEvent.MOUSE_ENTERED, e)));
        }
    }

    static class MouseMoveEventAdapter
    extends MouseEventAdapter {
        protected MouseMoveEventAdapter(Object target, EventHandler eventHandler) {
            super(target, eventHandler);
        }

        @Override
        public void mouseMoved(java.awt.event.MouseEvent e) {
            Platform.runLater(() -> this.eventHandler.handle((Event)TrayIconEventAdapter.convertToJavaFx(this.target, MouseEvent.MOUSE_MOVED, e)));
        }
    }

    static class ClickEventAdapter
    extends MouseEventAdapter {
        protected ClickEventAdapter(Object target, EventHandler eventHandler) {
            super(target, eventHandler);
        }

        @Override
        public void mouseClicked(java.awt.event.MouseEvent e) {
            Platform.runLater(() -> this.eventHandler.handle((Event)TrayIconEventAdapter.convertToJavaFx(this.target, MouseEvent.MOUSE_CLICKED, e)));
        }
    }

    static abstract class MouseEventAdapter<T>
    extends MouseAdapter {
        protected final EventHandler eventHandler;
        protected final T target;

        protected MouseEventAdapter(T target, EventHandler eventHandler) {
            this.eventHandler = eventHandler;
            this.target = target;
        }

        public EventHandler getEventHandler() {
            return this.eventHandler;
        }
    }
}

