/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.ArgumentParsingUtil;
import com.sun.deploy.util.GeneralUtil;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.ParameterUtil;
import com.sun.deploy.util.Property;
import com.sun.javaws.ExtensionInstallHandler;
import com.sun.javaws.Globals;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class JnlpxArgs {
    public static final String ARG_JVM = "jnlpx.jvm";
    public static final String ARG_SPLASHPORT = "jnlpx.splashport";
    public static final String ARG_REMOVE = "jnlpx.remove";
    public static final String ARG_OFFLINE = "jnlpx.offline";
    public static final String ARG_HEAPSIZE = "jnlpx.heapsize";
    public static final String ARG_VMARGS = "jnlpx.vmargs";
    public static final String ARG_HOME = "jnlpx.home";
    public static final String ARG_RELAUNCH = "jnlpx.relaunch";
    public static final String ARG_SESSION_DATA = "jnlpx.session.data";
    public static final String ARG_ORIGFILE_NAME = "jnlpx.origFilenameArg";
    public static final String ARG_DOCK_NAME = "macosx.jnlpx.dock.name";
    public static final String ARG_DOCK_ICON = "macosx.jnlpx.dock.icon";
    private static File _currentJVMCommand = null;
    private static final String JAVAWS_JAR = "javaws.jar";
    private static final String DEPLOY_JAR = "deploy.jar";
    private static final String PLUGIN_JAR = "plugin.jar";
    private static final Vector fileReadWriteList = new Vector();
    public static boolean _verbose = false;

    public static int getSplashPort() {
        try {
            return Integer.parseInt(System.getProperty(ARG_SPLASHPORT, "-1"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static String getVMArgs() {
        return System.getProperty(ARG_VMARGS);
    }

    public static boolean getIsRelaunch() {
        return JnlpxArgs.getBooleanProperty(ARG_RELAUNCH);
    }

    public static File getJVMCommand() {
        if (_currentJVMCommand == null) {
            String string = System.getProperty(ARG_JVM, "").trim();
            if (string.startsWith("X")) {
                string = JREInfo.getDefaultJavaPath();
            }
            if (string.startsWith("\"")) {
                string = string.substring(1);
            }
            if (string.endsWith("\"")) {
                string = string.substring(0, string.length() - 1);
            }
            _currentJVMCommand = new File(string);
        }
        return _currentJVMCommand;
    }

    public static boolean shouldRemoveArgumentFile() {
        return JnlpxArgs.getBooleanProperty(ARG_REMOVE);
    }

    public static void setShouldRemoveArgumentFile(String string) {
        System.setProperty(ARG_REMOVE, string);
    }

    public static boolean isOffline() {
        return JnlpxArgs.getBooleanProperty(ARG_OFFLINE);
    }

    public static void SetIsOffline() {
        System.setProperty(ARG_OFFLINE, "true");
    }

    public static String getHeapSize() {
        return System.getProperty(ARG_HEAPSIZE);
    }

    public static void setVerbose(boolean bl) {
        _verbose = bl;
    }

    public static long getInitialHeapSize() {
        String string = JnlpxArgs.getHeapSize();
        if (string == null) {
            return -1L;
        }
        String string2 = string.substring(string.lastIndexOf(61) + 1);
        String string3 = string2.substring(0, string2.lastIndexOf(44));
        return GeneralUtil.heapValToLong((String)string3);
    }

    public static long getMaxHeapSize() {
        String string = JnlpxArgs.getHeapSize();
        if (string == null) {
            return -1L;
        }
        String string2 = string.substring(string.lastIndexOf(61) + 1);
        String string3 = string2.substring(string2.lastIndexOf(44) + 1, string2.length());
        return GeneralUtil.heapValToLong((String)string3);
    }

    private static boolean heapSizesValid(long l, long l2) {
        return l != -1L || l2 != -1L;
    }

    static List getArgumentList(String string, long l, long l2, JVMParameters jVMParameters, List list, boolean bl, JfxRuntime jfxRuntime, boolean bl2, int n) {
        Property property;
        String string2;
        String string3;
        String string4 = "-Djnlpx.heapsize=NULL,NULL";
        if (JnlpxArgs.heapSizesValid(l, l2)) {
            string4 = "-Djnlpx.heapsize=" + l + "," + l2;
        }
        if ((string3 = JnlpxArgs.getVMArgs()) != null && !string3.isEmpty()) {
            jVMParameters = jVMParameters.copy();
            jVMParameters.addEncodedArguments(string3, true, false, true);
        }
        String string5 = System.getProperty(ARG_DOCK_ICON);
        String string6 = System.getProperty(ARG_DOCK_NAME);
        String string7 = System.getProperty(ARG_SESSION_DATA);
        System.setProperty(ARG_SESSION_DATA, "");
        String string8 = Environment.getForcedBootClassPath();
        String string9 = string8 == null ? "-Xbootclasspath/a:" + Environment.getDeploymentHome() + File.separator + "lib" + File.separator + JAVAWS_JAR + File.pathSeparator + Environment.getDeploymentHome() + File.separator + "lib" + File.separator + DEPLOY_JAR + File.pathSeparator + Environment.getDeploymentHome() + File.separator + "lib" + File.separator + PLUGIN_JAR : "-Xbootclasspath/p:" + string8;
        String string10 = "";
        String string11 = "";
        if (jfxRuntime != null) {
            string10 = "-Djnlp.fx=" + jfxRuntime.getProductVersion().toString();
            if (!bl2) {
                string11 = "-Djnlp.tk=awt";
            }
        }
        String string12 = System.getProperty(ARG_ORIGFILE_NAME);
        String[] stringArray = new String[]{string9, string10, string11, "-classpath", Environment.getDeploymentHome() + File.separator + "lib" + File.separator + DEPLOY_JAR, null, string5 != null ? "-Xdock:icon=" + string5 : "", string6 != null ? "-Xdock:name=" + string6 : "", "-Djnlpx.jvm=" + string, "-Djnlpx.splashport=" + JnlpxArgs.getSplashPort(), "-Djnlpx.home=" + Environment.getDeploymentHome() + File.separator + "bin", "-Djnlpx.remove=" + (JnlpxArgs.shouldRemoveArgumentFile() ? "true" : "false"), "-Djnlpx.offline=" + (JnlpxArgs.isOffline() ? "true" : "false"), "-Djnlpx.relaunch=true", "-Djnlpx.session.data=" + (string7 != null ? string7 : ""), string4, "-Djava.security.policy=" + JnlpxArgs.getPolicyURLString(), "-DtrustProxy=true", "-Xverify:remote", string12 == null ? "" : "-Djnlpx.origFilenameArg=" + string12, JnlpxArgs.useJCOV(), JnlpxArgs.useBootClassPath(), JnlpxArgs.useJpiProfile(), JnlpxArgs.useDebugMode(), JnlpxArgs.useDebugVMMode(), bl2 ? "" : "-Dsun.awt.warmup=true", "-Djava.security.manager", "com.sun.javaws.Main", bl ? "-secure" : "", _verbose ? "-verbose" : "", JnlpxArgs.setTCKHarnessOption(), Environment.isWebJava() ? "" : "-notWebJava", JnlpxArgs.useLogToHost()};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            n -= stringArray[i].length() + 1;
        }
        List list2 = jVMParameters.getCommandLineArguments(false, false, true, bl, false, n / 2 - 20);
        String string13 = ArgumentParsingUtil.encodeArgumentList((List)(list2 = ParameterUtil.mergeArgs((List)list2, (List)list, (int)1)));
        if ((n -= string13.length()) < (string2 = (property = new Property(ARG_VMARGS, string13)).toString()).length()) {
            Trace.println((String)("JnlpxArgs.getArgumentList: Internal Error:  remaining custArgsMaxLen: " + n + " < vmArgsPropertyStr.length: " + string2.length() + " dropping vmArgsPropertyStr"));
            string2 = null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                if (string2 == null) continue;
                list2.add(string2);
                string2 = null;
                continue;
            }
            if (stringArray[i].length() <= 0) continue;
            list2.add(stringArray[i]);
        }
        return list2;
    }

    static String getPolicyURLString() {
        String string;
        String string2 = string = Environment.getDeploymentHome() + File.separator + "lib" + File.separator + "security" + File.separator + "javaws.policy";
        try {
            URL uRL = new URL("file", "", string);
            string2 = uRL.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String useLogToHost() {
        if (Globals.LogToHost != null) {
            return "-XX:LogToHost=" + Globals.LogToHost;
        }
        return "";
    }

    public static String setTCKHarnessOption() {
        if (Globals.TCKHarnessRun) {
            return "-XX:TCKHarnessRun=true";
        }
        return "";
    }

    public static String useBootClassPath() {
        if (Globals.BootClassPath.equals("NONE")) {
            return "";
        }
        return "-Xbootclasspath" + Globals.BootClassPath;
    }

    public static String useJpiProfile() {
        String string = System.getProperty("javaplugin.user.profile");
        if (string != null) {
            return "-Djavaplugin.user.profile=" + string;
        }
        return "";
    }

    public static String useJCOV() {
        if (Globals.JCOV.equals("NONE")) {
            return "";
        }
        return "-Xrunjcov:file=" + Globals.JCOV;
    }

    public static String useDebugMode() {
        if (Config.isDebugMode()) {
            return "-Ddeploy.debugMode=true";
        }
        return "";
    }

    public static String useDebugVMMode() {
        if (Config.isDebugVMMode()) {
            return "-Ddeploy.useDebugJavaVM=true";
        }
        return "";
    }

    public static void removeArgumentFile(String string) {
        if (JnlpxArgs.shouldRemoveArgumentFile() && string != null) {
            new File(string).delete();
        }
    }

    public static void verify() {
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            Trace.println((String)"Java part started", (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("jnlpx.jvm: " + JnlpxArgs.getJVMCommand()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("jnlpx.splashport: " + JnlpxArgs.getSplashPort()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("jnlpx.remove: " + JnlpxArgs.shouldRemoveArgumentFile()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("jnlpx.heapsize: " + JnlpxArgs.getHeapSize()), (TraceLevel)TraceLevel.BASIC);
        }
    }

    private static boolean getBooleanProperty(String string) {
        String string2 = System.getProperty(string, "false");
        return string2 != null && string2.equals("true");
    }

    public static Vector getFileReadWriteList() {
        return fileReadWriteList;
    }

    protected static Process execProgram(JREInfo jREInfo, String[] stringArray, long l, long l2, JVMParameters jVMParameters, boolean bl) throws IOException {
        return JnlpxArgs.execProgram(jREInfo, stringArray, l, l2, jVMParameters, bl, null, false);
    }

    public static Process execProgram(JREInfo jREInfo, String[] stringArray, long l, long l2, JVMParameters jVMParameters, boolean bl, JfxRuntime jfxRuntime, boolean bl2) throws IOException {
        int n;
        String string = jREInfo.getPath();
        String string2 = Config.isDebugMode() && Config.isDebugVMMode() ? jREInfo.getDebugJavaPath() : jREInfo.getPath();
        if (string2 == null || string == null || string2.length() == 0 || string.length() == 0) {
            throw new IllegalArgumentException("must exist");
        }
        int n2 = Config.getMaxCommandLineLength();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            n2 -= stringArray[i].length() + 1;
        }
        String string3 = jREInfo.getVmArgs();
        List list = ArgumentParsingUtil.parseCommandLine((String)string3);
        List list2 = JnlpxArgs.getArgumentList(string, l, l2, jVMParameters, list, bl, jfxRuntime, bl2, n2 -= string2.length() + 1);
        List<String> list3 = new ArrayList<String>();
        if (Config.useSecureLaunch((JREInfo)jREInfo)) {
            list3.add(Platform.get().findSecureLauncher());
        } else {
            list3.add(string2);
        }
        list3.addAll(list2);
        list3.addAll(Arrays.asList(stringArray));
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            Trace.println((String)("Launching new JRE version: " + jREInfo), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("\t jvmParams: " + jVMParameters), (TraceLevel)TraceLevel.BASIC);
            for (n = 0; n < list3.size(); ++n) {
                Trace.println((String)("cmd " + n + " : " + list3.get(n)), (TraceLevel)TraceLevel.BASIC);
            }
        }
        if (Globals.TCKHarnessRun) {
            Main.tckprintln("JVM Starting");
        }
        Trace.flush();
        if (Config.useSecureLaunch((JREInfo)jREInfo)) {
            list3 = ArgumentParsingUtil.getSecureLaunchArgs((JREInfo)jREInfo, list3, (JVMParameters)(bl ? jVMParameters : null), (boolean)true, (boolean)true);
            for (n = 0; n < list3.size(); ++n) {
                Trace.println((String)("secure cmds " + n + " : " + list3.get(n)), (TraceLevel)TraceLevel.BASIC);
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(list3);
        return Platform.get().startProcessBuilder(processBuilder);
    }

    public static void executeInstallers(ArrayList arrayList, Preloader preloader) throws ExitException {
        if (preloader.getOwner() != null) {
            try {
                preloader.handleEvent((PreloaderEvent)new InitEvent(2));
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            try {
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, null);
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((String)file.getPath());
                localApplicationProperties.setExtensionInstalled(false);
                localApplicationProperties.store();
                Trace.println((String)("Installing extension: " + file), (TraceLevel)TraceLevel.EXTENSIONS);
                String[] stringArray = new String[]{"-installer", file.getAbsolutePath()};
                JREInfo jREInfo = launchDesc.selectJRE(false);
                if (jREInfo == null) {
                    preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                    LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException(launchDescException, 3);
                }
                boolean bl = JnlpxArgs.shouldRemoveArgumentFile();
                JnlpxArgs.setShouldRemoveArgumentFile("false");
                JREMatcher jREMatcher = launchDesc.getJREMatcher();
                JVMParameters jVMParameters = jREMatcher.getSelectedJVMParameters();
                JREDesc jREDesc = jREMatcher.getSelectedJREDesc();
                long l = jREDesc.getMinHeap();
                long l2 = jREDesc.getMaxHeap();
                Process process = JnlpxArgs.execProgram(jREInfo, stringArray, l, l2, jVMParameters, false);
                preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                EatInput.eatInput(process.getErrorStream());
                EatInput.eatInput(process.getInputStream());
                process.waitFor();
                JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(bl));
                localApplicationProperties.refresh();
                if (localApplicationProperties.isRebootNeeded()) {
                    boolean bl2 = false;
                    ExtensionInstallHandler extensionInstallHandler = ExtensionInstallHandler.getInstance();
                    if (extensionInstallHandler != null && extensionInstallHandler.doPreRebootActions((Component)preloader.getOwner())) {
                        bl2 = true;
                    }
                    localApplicationProperties.setExtensionInstalled(true);
                    localApplicationProperties.setRebootNeeded(false);
                    localApplicationProperties.store();
                    if (bl2 && extensionInstallHandler.doReboot()) {
                        throw new ExitException(null, 1);
                    }
                }
                if (localApplicationProperties.isExtensionInstalled()) continue;
                preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                throw new ExitException(new LaunchDescException(launchDesc, ResourceManager.getString((String)"Launch.error.installfailed"), null), 3);
            }
            catch (JNLPException jNLPException) {
                try {
                    preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                throw new ExitException(jNLPException, 3);
            }
            catch (IOException iOException) {
                try {
                    preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                throw new ExitException(iOException, 3);
            }
            catch (InterruptedException interruptedException) {
                try {
                    preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                throw new ExitException(interruptedException, 3);
            }
        }
    }

    public static void executeUninstallers(ArrayList arrayList) throws ExitException {
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            try {
                Object object;
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, null);
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((String)file.getPath());
                Trace.println((String)("uninstalling extension: " + file), (TraceLevel)TraceLevel.EXTENSIONS);
                if (!launchDesc.isInstaller()) {
                    throw new ExitException(null, 3);
                }
                String[] stringArray = new String[]{"-silent", "-installer", file.getAbsolutePath()};
                JREInfo jREInfo = launchDesc.selectJRE(false);
                if (jREInfo == null) {
                    object = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException((Throwable)object, 3);
                }
                object = launchDesc.getJREMatcher();
                JVMParameters jVMParameters = ((JREMatcher)object).getSelectedJVMParameters();
                JREDesc jREDesc = ((JREMatcher)object).getSelectedJREDesc();
                long l = jREDesc.getMinHeap();
                long l2 = jREDesc.getMaxHeap();
                Process process = JnlpxArgs.execProgram(jREInfo, stringArray, l, l2, jVMParameters, false);
                EatInput.eatInput(process.getErrorStream());
                EatInput.eatInput(process.getInputStream());
                process.waitFor();
                localApplicationProperties.refresh();
                if (!localApplicationProperties.isRebootNeeded()) continue;
                boolean bl = false;
                ExtensionInstallHandler extensionInstallHandler = ExtensionInstallHandler.getInstance();
                if (extensionInstallHandler != null && extensionInstallHandler.doPreRebootActions(null)) {
                    bl = true;
                }
                localApplicationProperties.setRebootNeeded(false);
                localApplicationProperties.setExtensionInstalled(false);
                localApplicationProperties.store();
                if (!bl || !extensionInstallHandler.doReboot()) continue;
                throw new ExitException(null, 1);
            }
            catch (JNLPException jNLPException) {
                throw new ExitException(jNLPException, 3);
            }
            catch (IOException iOException) {
                throw new ExitException(iOException, 3);
            }
            catch (InterruptedException interruptedException) {
                throw new ExitException(interruptedException, 3);
            }
        }
    }

    private static String sizeString(long l) {
        if (l > 0x100000L) {
            return "" + l / 0x100000L + "Mb";
        }
        return "" + l + "bytes";
    }

    private static class EatInput
    implements Runnable {
        private InputStream _is;

        EatInput(InputStream inputStream) {
            this._is = inputStream;
        }

        public void run() {
            byte[] byArray = new byte[1024];
            try {
                int n = 0;
                while (n != -1) {
                    n = this._is.read(byArray);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void eatInput(InputStream inputStream) {
            EatInput eatInput = new EatInput(inputStream);
            new Thread(eatInput).start();
        }
    }
}

