/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.desktop.hotkey.classes;

import com.tulskiy.keymaster.common.MediaKey;
import com.tulskiy.keymaster.common.Provider;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javax.swing.KeyStroke;
import php.runtime.annotation.Reflection;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.reflection.ClassEntity;

@Reflection.Namespace(value="php\\desktop")
public class HotKeyManager
extends BaseObject {
    private static final Map<String, String> keyAliases = new HashMap<String, String>();
    protected Provider provider;

    public HotKeyManager(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct() {
        this.provider = Provider.getCurrentProvider((boolean)false);
    }

    public static KeyStroke getKeyStroke(String keys) {
        String[] strings = StringUtils.split((String)keys, (char)'+');
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            String key = strings[i].trim();
            if (key.isEmpty()) continue;
            key = i == strings.length - 1 ? key.toUpperCase() : key.toLowerCase();
            if (keyAliases.containsKey(key)) {
                key = keyAliases.get(key);
            }
            sb.append(key).append(" ");
        }
        return KeyStroke.getKeyStroke(sb.toString().trim());
    }

    @Reflection.Signature
    public void register(String keys, Invoker callback) {
        KeyStroke keyStroke = HotKeyManager.getKeyStroke(keys);
        if (keyStroke == null) {
            throw new IllegalArgumentException("Invalid key stroke: " + keys);
        }
        this.provider.register(keyStroke, hotKey -> Platform.runLater(() -> callback.callAny(new Object[0])));
    }

    @Reflection.Signature
    public void registerMedia(MediaKey mediaKey, Invoker callback) {
        this.provider.register(mediaKey, hotKey -> Platform.runLater(() -> callback.callAny(new Object[0])));
    }

    @Reflection.Signature
    public void reset() {
        this.provider.reset();
    }

    @Reflection.Signature
    public void __destruct() {
        this.provider.stop();
    }

    static {
        keyAliases.put("DEL", "DELETE");
        keyAliases.put("ESC", "ESCAPE");
        keyAliases.put("CTRL", "CONTROL");
        keyAliases.put("CAPSLOCK", "CAPS_LOCK");
        keyAliases.put("BACKSPACE", "BACK_SPACE");
    }
}

