/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.json.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.lang.IObject;
import php.runtime.lang.StdClass;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;

public class MemoryDeserializer
implements JsonDeserializer<Memory> {
    protected boolean assoc;
    protected int maxDepth = 512;
    protected WeakReference<Environment> env;

    public boolean isAssoc() {
        return this.assoc;
    }

    public void setEnv(Environment env) {
        this.env = new WeakReference<Environment>(env);
    }

    public void setAssoc(boolean assoc) {
        this.assoc = assoc;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    protected Memory convert(JsonElement json, int depth) {
        if (depth > this.maxDepth) {
            throw new MaxDepthException();
        }
        if (json.isJsonNull()) {
            return Memory.NULL;
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
            if (jsonPrimitive.isString()) {
                return StringMemory.valueOf((String)jsonPrimitive.getAsString());
            }
            if (jsonPrimitive.isBoolean()) {
                return jsonPrimitive.getAsBoolean() ? Memory.TRUE : Memory.FALSE;
            }
            if (jsonPrimitive.isNumber()) {
                Memory l = StringMemory.toLong((String)jsonPrimitive.getAsString());
                if (l != null) {
                    return l;
                }
                return new DoubleMemory(json.getAsDouble());
            }
            return Memory.NULL;
        }
        if (json.isJsonArray()) {
            ArrayMemory array = new ArrayMemory();
            for (JsonElement el : json.getAsJsonArray()) {
                array.add(this.convert(el, depth + 1).toImmutable());
            }
            return array.toConstant();
        }
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            StdClass stdClass = this.assoc ? null : new StdClass((Environment)this.env.get());
            ArrayMemory array = this.assoc ? new ArrayMemory() : stdClass.getProperties();
            for (Map.Entry el : jsonObject.entrySet()) {
                String key = (String)el.getKey();
                if (key.startsWith("\u0000")) continue;
                array.put((Object)key, this.convert((JsonElement)el.getValue(), depth + 1).toImmutable());
            }
            return this.assoc ? array : new ObjectMemory((IObject)stdClass);
        }
        return Memory.NULL;
    }

    public Memory deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return this.convert(json, 0);
    }

    public static class MaxDepthException
    extends RuntimeException {
        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

