/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import org.firebirdsql.ds.RootCommonDataSource;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public class FBSimpleDataSource
extends RootCommonDataSource
implements DataSource,
Serializable,
Referenceable,
FirebirdConnectionProperties {
    private static final long serialVersionUID = 3156578540634970427L;
    protected FBManagedConnectionFactory mcf;
    protected transient FBDataSource ds;
    protected Reference jndiReference;
    protected String description;

    public FBSimpleDataSource() {
        this(GDSFactory.getDefaultGDSType());
    }

    public FBSimpleDataSource(GDSType type) {
        this.mcf = new FBManagedConnectionFactory(type);
    }

    public Integer getBlobBufferLength() {
        return this.mcf.getBlobBufferSize();
    }

    public void setBlobBufferLength(Integer length) {
        this.mcf.setBlobBufferSize(length);
    }

    @Deprecated
    public String getDatabaseName() {
        return this.getDatabase();
    }

    @Deprecated
    public void setDatabaseName(String name) {
        this.setDatabase(name);
    }

    @Override
    public String getDatabase() {
        return this.mcf.getDatabase();
    }

    @Override
    public void setDatabase(String name) {
        this.mcf.setDatabase(name);
    }

    @Deprecated
    public String getUser() {
        return this.getUserName();
    }

    @Deprecated
    public void setUser(String user) {
        this.setUserName(user);
    }

    @Override
    public String getUserName() {
        return this.mcf.getUserName();
    }

    @Override
    public void setUserName(String userName) {
        this.mcf.setUserName(userName);
    }

    @Override
    public String getPassword() {
        return this.mcf.getPassword();
    }

    @Override
    public void setPassword(String password) {
        this.mcf.setPassword(password);
    }

    @Override
    public String getEncoding() {
        return this.mcf.getEncoding();
    }

    @Override
    public void setEncoding(String encoding) {
        this.mcf.setEncoding(encoding);
    }

    @Override
    public String getTpbMapping() {
        return this.mcf.getTpbMapping();
    }

    @Override
    public void setTpbMapping(String tpbMapping) {
        this.mcf.setTpbMapping(tpbMapping);
    }

    @Override
    public int getBlobBufferSize() {
        return this.mcf.getBlobBufferSize();
    }

    @Override
    public int getBuffersNumber() {
        return this.mcf.getBuffersNumber();
    }

    @Override
    public String getCharSet() {
        return this.mcf.getCharSet();
    }

    @Override
    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        return this.mcf.getDatabaseParameterBuffer();
    }

    @Override
    public String getDefaultIsolation() {
        return this.mcf.getDefaultIsolation();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.mcf.getDefaultTransactionIsolation();
    }

    @Override
    public String getNonStandardProperty(String key) {
        return this.mcf.getNonStandardProperty(key);
    }

    @Override
    public String getRoleName() {
        return this.mcf.getRoleName();
    }

    @Override
    public int getSocketBufferSize() {
        return this.mcf.getSocketBufferSize();
    }

    @Override
    public String getSqlDialect() {
        return this.mcf.getSqlDialect();
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.mcf.getTransactionParameters(isolation);
    }

    @Override
    public String getType() {
        return this.mcf.getType();
    }

    @Override
    public String getUseTranslation() {
        return this.mcf.getUseTranslation();
    }

    @Override
    public boolean isTimestampUsesLocalTimezone() {
        return this.mcf.isTimestampUsesLocalTimezone();
    }

    @Override
    public boolean isUseStandardUdf() {
        return this.mcf.isUseStandardUdf();
    }

    @Override
    public boolean isUseStreamBlobs() {
        return this.mcf.isUseStreamBlobs();
    }

    @Override
    public void setBlobBufferSize(int bufferSize) {
        this.mcf.setBlobBufferSize(bufferSize);
    }

    @Override
    public void setBuffersNumber(int buffersNumber) {
        this.mcf.setBuffersNumber(buffersNumber);
    }

    @Override
    public void setCharSet(String charSet) {
        this.mcf.setCharSet(charSet);
    }

    @Override
    public void setDefaultIsolation(String isolation) {
        this.mcf.setDefaultIsolation(isolation);
    }

    @Override
    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        this.mcf.setDefaultTransactionIsolation(defaultIsolationLevel);
    }

    @Override
    public void setNonStandardProperty(String key, String value) {
        this.mcf.setNonStandardProperty(key, value);
    }

    @Override
    public void setNonStandardProperty(String propertyMapping) {
        this.mcf.setNonStandardProperty(propertyMapping);
    }

    @Override
    public void setRoleName(String roleName) {
        this.mcf.setRoleName(roleName);
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.mcf.setSocketBufferSize(socketBufferSize);
    }

    @Override
    public void setSqlDialect(String sqlDialect) {
        this.mcf.setSqlDialect(sqlDialect);
    }

    @Override
    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        this.mcf.setTimestampUsesLocalTimezone(timestampUsesLocalTimezone);
    }

    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.mcf.setTransactionParameters(isolation, tpb);
    }

    @Override
    public void setType(String type) {
        this.mcf.setType(type);
    }

    @Override
    public void setUseStandardUdf(boolean useStandardUdf) {
        this.mcf.setUseStandardUdf(useStandardUdf);
    }

    @Override
    public void setUseStreamBlobs(boolean useStreamBlobs) {
        this.mcf.setUseStreamBlobs(useStreamBlobs);
    }

    @Override
    public void setUseTranslation(String translationPath) {
        this.mcf.setUseTranslation(translationPath);
    }

    @Override
    public boolean isDefaultResultSetHoldable() {
        return this.mcf.isDefaultResultSetHoldable();
    }

    @Override
    public void setDefaultResultSetHoldable(boolean isHoldable) {
        this.mcf.setDefaultResultSetHoldable(isHoldable);
    }

    @Override
    public int getSoTimeout() {
        return this.mcf.getSoTimeout();
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.mcf.setSoTimeout(soTimeout);
    }

    @Override
    public int getConnectTimeout() {
        return this.mcf.getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.mcf.setConnectTimeout(connectTimeout);
    }

    @Override
    public boolean isUseFirebirdAutocommit() {
        return this.mcf.isUseFirebirdAutocommit();
    }

    @Override
    public void setUseFirebirdAutocommit(boolean useFirebirdAutocommit) {
        this.mcf.setUseFirebirdAutocommit(useFirebirdAutocommit);
    }

    public Reference getReference() throws NamingException {
        return this.jndiReference;
    }

    public void setReference(Reference reference) {
        this.jndiReference = reference;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDataSource().getConnection(username, password);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getConnectTimeout();
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.setConnectTimeout(loginTimeout);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected synchronized DataSource getDataSource() throws SQLException {
        if (this.ds != null) {
            return this.ds;
        }
        if (this.mcf.getDatabase() == null || "".equals(this.mcf.getDatabase().trim())) {
            throw new SQLException("Database was not specified. Cannot provide connections.");
        }
        try {
            this.ds = (FBDataSource)this.mcf.createConnectionFactory();
            return this.ds;
        }
        catch (ResourceException rex) {
            throw new SQLException(rex.getMessage());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Unable to unwrap to class " + iface.getName());
        }
        return iface.cast(this);
    }
}

