/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.IEncodingFactory;

public interface DatatypeCoder {
    public static final int NANOSECONDS_PER_FRACTION = 100000;
    public static final int FRACTIONS_PER_MILLISECOND = 10;
    public static final int FRACTIONS_PER_SECOND = 10000;
    public static final int FRACTIONS_PER_MINUTE = 600000;
    public static final int FRACTIONS_PER_HOUR = 36000000;

    public byte[] encodeShort(short var1);

    public byte[] encodeShort(int var1);

    public short decodeShort(byte[] var1);

    public byte[] encodeInt(int var1);

    public int decodeInt(byte[] var1);

    public byte[] encodeLong(long var1);

    public long decodeLong(byte[] var1);

    public byte[] encodeFloat(float var1);

    public float decodeFloat(byte[] var1);

    public byte[] encodeDouble(double var1);

    public double decodeDouble(byte[] var1);

    public byte[] encodeString(String var1, String var2, String var3) throws SQLException;

    public byte[] encodeString(String var1, Encoding var2, String var3) throws SQLException;

    public String decodeString(byte[] var1, String var2, String var3) throws SQLException;

    public String decodeString(byte[] var1, Encoding var2, String var3) throws SQLException;

    public Timestamp encodeTimestamp(Timestamp var1, Calendar var2);

    public Timestamp encodeTimestamp(Timestamp var1, Calendar var2, boolean var3);

    public byte[] encodeTimestamp(Timestamp var1);

    public byte[] encodeTimestampRaw(RawDateTimeStruct var1);

    public byte[] encodeTimestampCalendar(Timestamp var1, Calendar var2);

    public Timestamp decodeTimestamp(Timestamp var1, Calendar var2);

    public Timestamp decodeTimestamp(Timestamp var1, Calendar var2, boolean var3);

    public Timestamp decodeTimestamp(byte[] var1);

    public RawDateTimeStruct decodeTimestampRaw(byte[] var1);

    public Timestamp decodeTimestampCalendar(byte[] var1, Calendar var2);

    public Time encodeTime(Time var1, Calendar var2, boolean var3);

    public byte[] encodeTime(Time var1);

    public byte[] encodeTimeRaw(RawDateTimeStruct var1);

    public byte[] encodeTimeCalendar(Time var1, Calendar var2);

    public Time decodeTime(Time var1, Calendar var2, boolean var3);

    public Time decodeTime(byte[] var1);

    public RawDateTimeStruct decodeTimeRaw(byte[] var1);

    public Time decodeTimeCalendar(byte[] var1, Calendar var2);

    public Date encodeDate(Date var1, Calendar var2);

    public byte[] encodeDate(Date var1);

    public byte[] encodeDateRaw(RawDateTimeStruct var1);

    public byte[] encodeDateCalendar(Date var1, Calendar var2);

    public Date decodeDate(Date var1, Calendar var2);

    public Date decodeDate(byte[] var1);

    public RawDateTimeStruct decodeDateRaw(byte[] var1);

    public Date decodeDateCalendar(byte[] var1, Calendar var2);

    public boolean decodeBoolean(byte[] var1);

    public byte[] encodeBoolean(boolean var1);

    public byte[] encodeLocalTime(int var1, int var2, int var3, int var4);

    public byte[] encodeLocalDate(int var1, int var2, int var3);

    public byte[] encodeLocalDateTime(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public IEncodingFactory getEncodingFactory();

    public static final class RawDateTimeStruct {
        public int year;
        public int month;
        public int day;
        public int hour;
        public int minute;
        public int second;
        public int fractions;

        public RawDateTimeStruct() {
        }

        public RawDateTimeStruct(RawDateTimeStruct raw) {
            this.year = raw.year;
            this.month = raw.month;
            this.day = raw.day;
            this.hour = raw.hour;
            this.minute = raw.minute;
            this.second = raw.second;
            this.fractions = raw.fractions;
        }

        public int getFractionsAsNanos() {
            return this.fractions * 100000;
        }
    }
}

