/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

final class LongList {
    public static int DEFAULT_CAPACITY = 10;
    public static int DEFAULT_INCREMENT = 10;
    private final int DELTA;
    private int size = 0;
    public long[] list;

    LongList() {
        this(DEFAULT_CAPACITY, DEFAULT_INCREMENT);
    }

    LongList(int n) {
        this(n, DEFAULT_INCREMENT);
    }

    LongList(int n, int n2) {
        this.DELTA = n2;
        this.list = this.allocate(n);
    }

    public final int size() {
        return this.size;
    }

    public final boolean add(long l) {
        if (this.size >= this.list.length) {
            this.resize();
        }
        this.list[this.size++] = l;
        return true;
    }

    public final void add(int n, long l) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (n >= this.list.length) {
            this.resize();
        }
        if (n == this.size) {
            this.list[this.size++] = l;
            return;
        }
        System.arraycopy(this.list, n, this.list, n + 1, this.size - n);
        this.list[n] = l;
        ++this.size;
    }

    public final void add(int n, long[] lArray, int n2, int n3) {
        if (n3 <= 0) {
            return;
        }
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.ensure(this.size + n3);
        if (n < this.size) {
            System.arraycopy(this.list, n, this.list, n + n3, this.size - n);
        }
        System.arraycopy(lArray, n2, this.list, n, n3);
        this.size += n3;
    }

    public final long remove(int n, int n2) {
        if (n2 < 1 || n < 0) {
            return -1L;
        }
        if (n + n2 > this.size) {
            return -1L;
        }
        long l = this.list[n];
        int n3 = this.size;
        this.size -= n2;
        if (n == this.size) {
            return l;
        }
        System.arraycopy(this.list, n + n2, this.list, n, this.size - n);
        return l;
    }

    public final long remove(int n) {
        if (n >= this.size) {
            return -1L;
        }
        long l = this.list[n];
        this.list[n] = 0L;
        if (n == --this.size) {
            return l;
        }
        System.arraycopy(this.list, n + 1, this.list, n, this.size - n);
        return l;
    }

    public final long[] toArray(long[] lArray) {
        System.arraycopy(this.list, 0, lArray, 0, this.size);
        return lArray;
    }

    public final long[] toArray() {
        return this.toArray(new long[this.size]);
    }

    private final void resize() {
        long[] lArray = this.allocate(this.list.length + this.DELTA);
        System.arraycopy(this.list, 0, lArray, 0, this.size);
        this.list = lArray;
    }

    private final void ensure(int n) {
        if (this.list.length < n) {
            int n2 = this.list.length + this.DELTA;
            n = n < n2 ? n2 : n;
            long[] lArray = this.allocate(n);
            System.arraycopy(this.list, 0, lArray, 0, this.size);
            this.list = lArray;
        }
    }

    private final long[] allocate(int n) {
        return new long[n];
    }
}

