/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.sql.classes;

import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.develnext.jphp.ext.sql.classes.WrapSqlException;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.MiscStream;
import php.runtime.ext.core.classes.time.WrapTime;
import php.runtime.lang.BaseObject;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Abstract
@Reflection.Name(value="SqlResult")
@Reflection.Namespace(value="php\\sql")
public class PSqlResult
extends BaseObject {
    protected ResultSet resultSet;
    protected ResultSetMetaData metaData;

    public PSqlResult(Environment env, ResultSet resultSet) {
        super(env);
        this.resultSet = resultSet;
        try {
            this.metaData = resultSet.getMetaData();
        }
        catch (SQLException e) {
            throw new WrapSqlException(env, e);
        }
    }

    public PSqlResult(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    @Reflection.Signature
    public boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    public Memory getTyped(Environment env, int index) throws SQLException {
        ResultSet set = this.resultSet;
        int type = this.metaData.getColumnType(++index);
        if (set.getObject(index) == null) {
            return Memory.NULL;
        }
        switch (type) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                return LongMemory.valueOf((long)set.getLong(index));
            }
            case 16: {
                return TrueMemory.valueOf((boolean)set.getBoolean(index));
            }
            case 3: 
            case 6: 
            case 8: {
                return DoubleMemory.valueOf((double)set.getDouble(index));
            }
            case 0: {
                return Memory.NULL;
            }
            case 92: {
                Time time = set.getTime(index);
                return ObjectMemory.valueOf((IObject)new WrapTime(env, (java.util.Date)time));
            }
            case 93: {
                Timestamp timestamp = set.getTimestamp(index);
                return ObjectMemory.valueOf((IObject)new WrapTime(env, (java.util.Date)timestamp));
            }
            case 91: {
                Date date = set.getDate(index);
                return ObjectMemory.valueOf((IObject)new WrapTime(env, (java.util.Date)date));
            }
            case -5: 
            case -1: 
            case 1: 
            case 12: {
                return StringMemory.valueOf((String)set.getString(index));
            }
            case -16: 
            case -9: {
                return StringMemory.valueOf((String)set.getNString(index));
            }
            case -2: {
                return new BinaryMemory(set.getBytes(index));
            }
            case 2004: 
            case 2005: 
            case 2011: {
                try {
                    Blob blob = set.getBlob(index);
                    return ObjectMemory.valueOf((IObject)new MiscStream(env, blob.getBinaryStream()));
                }
                catch (SQLException e) {
                    return new BinaryMemory(set.getBytes(index));
                }
            }
        }
        return StringMemory.valueOf((String)set.getString(index));
    }

    @Reflection.Signature
    public Memory get(Environment env, Memory column) throws SQLException {
        return this.getTyped(env, this.resultSet.findColumn(column.toString()) - 1);
    }

    @Reflection.Signature
    public ArrayMemory toArray(Environment env) throws SQLException {
        return this.toArray(env, true);
    }

    @Reflection.Signature
    public void delete() throws SQLException {
        this.resultSet.deleteRow();
    }

    @Reflection.Signature
    public boolean isDeleted() throws SQLException {
        return this.resultSet.rowDeleted();
    }

    @Reflection.Signature
    public void refresh() throws SQLException {
        this.resultSet.refreshRow();
    }

    @Reflection.Signature
    public ArrayMemory toArray(Environment env, boolean assoc) throws SQLException {
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        ArrayMemory result = new ArrayMemory();
        int count = metaData.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Memory value = this.getTyped(env, i);
            if (assoc) {
                result.putAsKeyString(metaData.getColumnLabel(i + 1), value);
                continue;
            }
            result.add(value);
        }
        return result.toConstant();
    }
}

