/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.game.support;

import javafx.animation.AnimationTimer;
import javafx.css.Styleable;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import org.develnext.jphp.ext.game.support.GameScene2D;
import org.develnext.jphp.ext.game.support.Vec2d;

public class GameBackground
extends Canvas
implements Styleable {
    private final GraphicsContext g2;
    protected Image image;
    protected Image drawImage;
    protected boolean autoSize;
    protected Vec2d viewPos = new Vec2d(0.0, 0.0);
    protected Vec2d velocity = new Vec2d(0.0, 0.0);
    protected AnimationTimer animationTimer = new AnimationTimer(){

        public void handle(long now) {
            if (GameBackground.this.image != null && (GameBackground.this.velocity.x != 0.0 || GameBackground.this.velocity.y != 0.0)) {
                float dt = 0.016666668f;
                GameBackground.this.viewPos.x += (double)GameScene2D.toPixels(GameBackground.this.velocity.x * (double)dt);
                GameBackground.this.viewPos.y += (double)GameScene2D.toPixels(GameBackground.this.velocity.y * (double)dt);
                if (GameBackground.this.viewPos.x + GameBackground.this.image.getWidth() < 0.0) {
                    GameBackground.this.viewPos.x = 0.0;
                }
                if (GameBackground.this.viewPos.y + GameBackground.this.image.getHeight() < 0.0) {
                    GameBackground.this.viewPos.y = 0.0;
                }
                if (GameBackground.this.viewPos.x > GameBackground.this.image.getWidth()) {
                    GameBackground.this.viewPos.x = 0.0;
                }
                if (GameBackground.this.viewPos.y > GameBackground.this.image.getHeight()) {
                    GameBackground.this.viewPos.y = 0.0;
                }
                GameBackground.this.update();
            }
        }
    };

    public Vec2d getVelocity() {
        return this.velocity;
    }

    public Vec2d getViewPos() {
        return this.viewPos;
    }

    public void setViewPos(Vec2d viewPos) {
        this.viewPos = viewPos;
    }

    public void setVelocity(Vec2d velocity) {
        this.velocity = velocity;
    }

    public void setVelocityX(double value) {
        this.velocity.x = value;
    }

    public void setVelocityY(double value) {
        this.velocity.y = value;
    }

    public double getVelocityX() {
        return this.velocity.x;
    }

    public double getVelocityY() {
        return this.velocity.y;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.update();
    }

    public GameBackground() {
        this.animationTimer.start();
        this.g2 = this.getGraphicsContext2D();
        this.widthProperty().addListener((observableValue, number, t1) -> this.update());
        this.heightProperty().addListener((observableValue, number, t1) -> this.update());
        this.parentProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.animationTimer.stop();
            } else {
                this.animationTimer.start();
            }
        });
        this.getStyleClass().add((Object)"without-focus");
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
        this.update();
    }

    public void resize(double v, double v1) {
        this.setWidth(v);
        this.setHeight(v1);
    }

    public boolean isResizable() {
        return !this.autoSize;
    }

    protected void update() {
        if (this.autoSize) {
            this.setWidth(this.image == null ? 0.0 : this.image.getWidth());
            this.setHeight(this.image == null ? 0.0 : this.image.getHeight());
        }
        this.g2.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            double x = 0.0;
            double y = 0.0;
            double w = this.image.getWidth();
            double h = this.image.getHeight();
            int horCount = (int)Math.ceil(this.getWidth() / w);
            int verCount = (int)Math.ceil(this.getHeight() / h);
            for (int i = -1; i < verCount + 1; ++i) {
                for (int j = -1; j < horCount + 1; ++j) {
                    this.g2.drawImage(this.image, this.viewPos.x + (double)j * w, this.viewPos.y + (double)i * h, w, h);
                }
            }
        }
    }
}

